/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;

/**
 * @author yoshida
 *
 */
public class AttendanceListVo extends AttendanceMenuVo {
	
	private static final long	serialVersionUID	= 5745704400845358952L;
	
	// 萔
	public static final int		MODE_IMPOSSIBLE		= 0;
	public static final int		MODE_POSSIBLE		= 1;
	
	// p[^
	public static final String	PRM_PLT_YEAR		= "pltYear";
	public static final String	PRM_PLT_MONTH		= "pltMonth";
	
	public static final String	PRM_HID_KCODE		= "hidKCode";
	
	// tB[h
	private String				selectKCode;
	
	private String				workTimes;
	private String				breakTimes;
	private String				lateTimes;
	private String				leaveEarlyTimes;
	private String				overTimes;
	private String				workOnHoliday;
	private String				lateNightTimes;
	
	private String				presence;
	private String				paidHoliday;
	private String				particularHoliday;
	private String				absence;
	private String				sick;
	private String				compensationLeave;
	private String				transfer;
	private String				other;
	
	private String				leaveAndLate;
	
	private String				allowance;
	private String				perfectAttendance;
	
	private String[][]			aryAttendance;
	private String[]			aryLabel;
	
	private String				pltYear;
	private String				pltMonth;
	
	//private String hidKCode;
	
	/*						
	 *  	2009/01/20	m.yoshida	ߓΉ
	 */
	//private String hidDay;
	
	// Tu^Cgj[R}h
	//private String cmdMenuButton;
	//private String cmdListButton;
	//private String namListButton;
	
	// v_EXg
	/**
	 * 
	 */
	public String[][]			aryPltYear;
	/**
	 * 
	 */
	public String[][]			aryPltMonth;
	
	private String				overTimeCssClass;
	

	/**
	 * RXgN^
	 */
	public AttendanceListVo() {
		super();
		setMode(MODE_IMPOSSIBLE);
		setViewPath(getClassName());
		pltYear = "";
		pltMonth = "";
		//hidKCode = "";
		aryAttendance = new String[0][0];
		aryLabel = new String[0];
		overTimeCssClass = "";
		/*						
		 *  	2009/01/20	m.yoshida	ߓΉ
		 */
		//hidDay = "";
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_ATTENDANCE_LIST;
	}
	
	/**
	 * p[^ݒ
	 * @param request NGXg
	 */
	@Override
	public void setParams(HttpServletRequest request) {
		pltYear = request.getParameter(PRM_PLT_YEAR);
		pltMonth = request.getParameter(PRM_PLT_MONTH);
		/*						
		 *  	2009/01/20	m.yoshida	ߓΉ
		 */
		//hidDay = "";
		// oΕo͗p
		//hidKCode = request.getParameter(PRM_HID_KCODE);
		//super.setParams(request);
	}
	
	/**
	 * tB[hݒ
	 * @param aryAttendance	Wvf[^Xg
	 * @param aryCompile	Wvf[^
	 * @param aryLabel		Wvf[^x
	 */
	public void setFields(String[][] aryAttendance, String[] aryCompile, String[] aryLabel) {
		this.aryAttendance = escapeArray(aryAttendance.clone());
		this.aryLabel = escapeArray(aryLabel.clone());
		
		workTimes = aryCompile[0];
		breakTimes = aryCompile[1];
		lateTimes = aryCompile[2];
		leaveEarlyTimes = aryCompile[3];
		overTimes = aryCompile[4];
		workOnHoliday = aryCompile[5];
		lateNightTimes = aryCompile[6];
		
		presence = aryCompile[7];
		paidHoliday = aryCompile[8];
		particularHoliday = aryCompile[9];
		absence = aryCompile[10];
		sick = aryCompile[11];
		compensationLeave = aryCompile[12];
		transfer = aryCompile[13];
		other = aryCompile[14];
		
		leaveAndLate = aryCompile[15];
		allowance = aryCompile[16];
		perfectAttendance = aryCompile[17];
		
		overTimeCssClass = aryCompile[18];
	}
	
	// ANZT\bh
	public String[][] getEscAryAttendance() {
		return aryAttendance.clone();
	}
	
	public String[] getEscAryLabel() {
		return aryLabel.clone();
	}
	
	public String getSelectKCode() {
		return selectKCode;
	}
	
	public String getEscSelectKCode() {
		return escapeHTML(selectKCode);
	}
	
	public void setSelectKCode(String selectKCode) {
		this.selectKCode = selectKCode;
	}
	
	public String getPltYear() {
		return pltYear;
	}
	
	public String getPltMonth() {
		return pltMonth;
	}
	
	public String getEscPltYear() {
		return escapeHTML(pltYear);
	}
	
	public String getEscPltMonth() {
		return escapeHTML(pltMonth);
	}
	
	public void setPltYear(String pltYear) {
		this.pltYear = pltYear;
	}
	
	public void setPltMonth(String pltMonth) {
		this.pltMonth = pltMonth;
	}
	
	public String getEscWorkTimes() {
		return escapeHTML(workTimes);
	}
	
	public String getEscBreakTimes() {
		return escapeHTML(breakTimes);
	}
	
	public String getEscLateTimes() {
		return escapeHTML(lateTimes);
	}
	
	public String getEscLeaveEarlyTimes() {
		return escapeHTML(leaveEarlyTimes);
	}
	
	public String getEscOverTimes() {
		return escapeHTML(overTimes);
	}
	
	public String getEscWorkOnHoliday() {
		return escapeHTML(workOnHoliday);
	}
	
	public String getEscLateNightTimes() {
		return escapeHTML(lateNightTimes);
	}
	
	public String getEscPresence() {
		return escapeHTML(presence);
	}
	
	public String getEscPaidHoliday() {
		return escapeHTML(paidHoliday);
	}
	
	public String getEscParticularHoliday() {
		return escapeHTML(particularHoliday);
	}
	
	public String getEscAbsence() {
		return escapeHTML(absence);
	}
	
	public String getEscSick() {
		return escapeHTML(sick);
	}
	
	public String getEscCompensationLeave() {
		return escapeHTML(compensationLeave);
	}
	
	public String getEscTransfer() {
		return escapeHTML(transfer);
	}
	
	public String getEscOther() {
		return escapeHTML(other);
	}
	
	public String getEscLeaveAndLate() {
		return escapeHTML(leaveAndLate);
	}
	
	public String getEscAllowance() {
		return escapeHTML(allowance);
	}
	
	public String getEscPerfectAttendance() {
		return escapeHTML(perfectAttendance);
	}
	
	/**
	 * @return overTimeCssClass
	 */
	public String getOverTimeCssClass() {
		return overTimeCssClass;
	}
	
	/**
	 * @param overTimeCssClass Zbg overTimeCssClass
	 */
	public void setOverTimeCssClass(String overTimeCssClass) {
		this.overTimeCssClass = overTimeCssClass;
	}
	
}
