/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.payroll.vo;

import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.common.MospException;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.kintai.dto.MYukyuDto;

/**
 * @author yoshida
 *
 */
public class PaidHolidayOldCardVo extends MosPVo {
	
	private static final long	serialVersionUID			= 4422751719733412912L;
	
	// 萔
	/**
	 * 
	 */
	public static final int		MODE_VIEW					= 0;
	/**
	 * 
	 */
	public static final int		MODE_UPDATE					= 1;
	
	// p[^
	/**
	 * selectKCode
	 */
	public static final String	PRM_HID_SELECT_K_CODE		= "hidSelectKCode";
	/**
	 * hidSelectYearMonth
	 */
	public static final String	PRM_HID_SELECT_YEAR_MONTH	= "hidSelectYearMonth";
	/**
	 * hidTotalRemain
	 */
	public static final String	PRM_HID_TOTAL_REMAIN		= "hidTotalRemain";
	/**
	 * hidThisRemain
	 */
	public static final String	PRM_HID_THIS_REMAIN			= "hidThisRemain";
	/**
	 * hidLastRemain
	 */
	public static final String	PRM_HID_LAST_REMAIN			= "hidLastRemain";
	/**
	 * hidSupply
	 */
	public static final String	PRM_HID_SUPPLY				= "hidSupply";
	/**
	 * hidWaste
	 */
	public static final String	PRM_HID_WASTE				= "hidWaste";
	/**
	 * txtThisRemain
	 */
	public static final String	PRM_TXT_THIS_SUPPLY			= "txtThisSupply";
	/**
	 * txtLastSupply
	 */
	public static final String	PRM_TXT_LAST_SUPPLY			= "txtLastSupply";
	/**
	 * txtThisWaste
	 */
	public static final String	PRM_TXT_THIS_WASTE			= "txtThisWaste";
	/**
	 * txtLastWaste
	 */
	public static final String	PRM_TXT_LAST_WASTE			= "txtLastWaste";
	/**
	 * txtTotalRemain
	 */
	public static final String	PRM_TXT_TOTAL_REMAIN		= "txtTotalRemain";
	/**
	 * txtThisRemain
	 */
	public static final String	PRM_TXT_THIS_REAMIN			= "txtThisRemain";
	/**
	 * txtLastRemain
	 */
	public static final String	PRM_TXT_LAST_REMAIN			= "txtLastRemain";
	
	// tB[h
	private String				hidSelectKCode;
	private String				hidTotalRemain;
	private String				hidThisRemain;
	private String				hidLastRemain;
	private String				hidSupply;
	private String				hidWaste;
	private String				lblTotalRemain;
	private String				lblThisRemain;
	private String				lblLastRemain;
	private String				txtThisSupply;
	private String				txtLastSupply;
	private String				txtThisWaste;
	private String				txtLastWaste;
	private String				txtTotalRemain;
	private String				txtThisRemain;
	private String				txtLastRemain;
	private String				hidSelectYear;
	private String				hidSelectMonth;
	private String				hidSelectYearMonth;
	private String				lblSelectYearMonth;
	
	private String[][]			aryPaidHoliday;
	
	// [h(1FXV)
	private int					mode;
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_K_CODE;
	/**
	 * 
	 */
	public String				NAM_K_NAME;
	/**
	 * 
	 */
	public String				NAM_STATION;
	/**
	 * 
	 */
	public String				NAM_SELECT_YEAR_MONTH;
	/**
	 * 
	 */
	public String				NAM_YEAR_MONTH;
	/**
	 * 
	 */
	public String				NAM_SUPPLY;
	/**
	 * 
	 */
	public String				NAM_THIS_SUPPLY;
	/**
	 * 
	 */
	public String				NAM_LAST_SUPPLY;
	/**
	 * 
	 */
	public String				NAM_WASTE;
	/**
	 * 
	 */
	public String				NAM_THIS_WASTE;
	/**
	 * 
	 */
	public String				NAM_LAST_WASTE;
	/**
	 * 
	 */
	public String				NAM_REST;
	/**
	 * 
	 */
	public String				NAM_USE;
	/**
	 * 
	 */
	public String				NAM_THIS_MONTH;
	/**
	 * 
	 */
	public String				NAM_LAST_MONTH;
	/**
	 * 
	 */
	public String				NAM_THIS_YEAR;
	/**
	 * 
	 */
	public String				NAM_LAST_YEAR;
	/**
	 * 
	 */
	public String				NAM_TOTAL;
	/**
	 * 
	 */
	public int					LEN_PAID_HOLIDAY;
	/**
	 * 
	 */
	public int					LEN_INTEGER;
	/**
	 * 
	 */
	public int					LEN_DECIMAL;
	

	/**
	 * RXgN^
	 */
	public PaidHolidayOldCardVo() {
		super();
		mode = 0;
		setViewPath(getClassName());
		aryPaidHoliday = new String[0][0];
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_PAID_HOLIDAY;
		createAryMenu(CMD_MENU_PAYROLL, MosPMenuConst.getMenuPaidHolidayManagement());
	}
	
	@Override
	protected void setFieldsName() {
		NAM_K_CODE = CommonConst.NAM_K_CODE;
		NAM_K_NAME = CommonConst.NAM_K_NAME;
		NAM_STATION = CommonConst.NAM_STATION;
		NAM_SELECT_YEAR_MONTH = "IN";
		NAM_YEAR_MONTH = "xN";
		NAM_SUPPLY = CommonConst.NAM_GET_NUMBER;
		NAM_THIS_SUPPLY = CommonConst.NAM_GET_NUMBER + CommonConst.NAM_YEAR_THIS;
		NAM_LAST_SUPPLY = CommonConst.NAM_GET_NUMBER + CommonConst.NAM_YEAR_FORMER;
		NAM_WASTE = CommonConst.NAM_DISPOSE;
		NAM_THIS_WASTE = CommonConst.NAM_DISPOSE + CommonConst.NAM_YEAR_THIS;
		NAM_LAST_WASTE = CommonConst.NAM_DISPOSE + CommonConst.NAM_YEAR_FORMER;
		NAM_REST = CommonConst.NAM_ABB_PAID_HOLIDAY + CommonConst.NAM_AMOUNT;
		NAM_USE = CommonConst.NAM_USE;
		NAM_THIS_MONTH = CommonConst.NAM_MONTH_THIS;
		NAM_LAST_MONTH = CommonConst.NAM_MONTH_FORMER;
		NAM_THIS_YEAR = CommonConst.NAM_YEAR_THIS;
		NAM_LAST_YEAR = CommonConst.NAM_YEAR_FORMER;
		NAM_TOTAL = CommonConst.NAM_COMMON_SUM;
		LEN_PAID_HOLIDAY = 5;
		LEN_INTEGER = 2;
		LEN_DECIMAL = 1;
	}
	
	/**
	 * lݒ
	 */
	public void setDefaultValues() {
		setTxtLastRemain("0.0");
		setTxtLastSupply("0");
		setTxtLastWaste("0.0");
		setTxtThisRemain("0.0");
		setTxtThisSupply("0");
		setTxtThisWaste("0.0");
		setTxtTotalRemain("0.0");
	}
	
	/**
	 * p[^ݒ
	 */
	@Override
	public void setParams(HttpServletRequest request) {
		hidSelectKCode = request.getParameter(PRM_HID_SELECT_K_CODE);
		hidSelectYearMonth = request.getParameter(PRM_HID_SELECT_YEAR_MONTH);
		hidTotalRemain = request.getParameter(PRM_HID_TOTAL_REMAIN);
		hidThisRemain = request.getParameter(PRM_HID_THIS_REMAIN);
		hidLastRemain = request.getParameter(PRM_HID_LAST_REMAIN);
		hidSupply = request.getParameter(PRM_HID_SUPPLY);
		hidWaste = request.getParameter(PRM_HID_WASTE);
		txtThisSupply = request.getParameter(PRM_TXT_THIS_SUPPLY);
		txtLastSupply = request.getParameter(PRM_TXT_LAST_SUPPLY);
		txtThisWaste = request.getParameter(PRM_TXT_THIS_WASTE);
		txtLastWaste = request.getParameter(PRM_TXT_LAST_WASTE);
		txtTotalRemain = request.getParameter(PRM_TXT_TOTAL_REMAIN);
		txtThisRemain = request.getParameter(PRM_TXT_THIS_REAMIN);
		txtLastRemain = request.getParameter(PRM_TXT_LAST_REMAIN);
		String[] selectYearMonth = StringUtil.divideByHyphen(hidSelectYearMonth);
		hidSelectYear = selectYearMonth[0];
		hidSelectMonth = selectYearMonth[1];
	}
	
	/**
	 * tB[hݒ
	 * @param dto ΏDTO
	 */
	public void setFields(MYukyuDto dto) {
		hidThisRemain = String.valueOf(dto.getTZanT());
		hidLastRemain = String.valueOf(dto.getTZanZ());
		hidTotalRemain = String.valueOf(dto.getTZanT() + dto.getTZanZ());
		hidSupply = String.valueOf(dto.getSyutoku());
		hidWaste = String.valueOf(dto.getHaiki());
		lblThisRemain = hidThisRemain;
		lblLastRemain = hidLastRemain;
		lblTotalRemain = hidTotalRemain;
		txtThisRemain = hidThisRemain;
		txtLastRemain = hidLastRemain;
		txtTotalRemain = hidTotalRemain;
	}
	
	@Override
	public void setFields(List<?> list) {
		// Xg̐ݒ
		this.list = list;
		// f[^̎擾
		count = list.size();
		// z̏
		aryPaidHoliday = new String[count][6];
		// f[^̐ݒ
		int i = 0;
		for (Object obj : list) {
			MYukyuDto dto = (MYukyuDto)obj;
			aryPaidHoliday[i][0] = escapeHTML(DateUtil.convDateToJPYearMonthShort(DateUtil.convIntegerDateToDate(dto
				.getKyuyoYMD())));
			aryPaidHoliday[i][1] = String.valueOf(dto.getTZanT());
			aryPaidHoliday[i][2] = String.valueOf(dto.getTZanZ());
			aryPaidHoliday[i][3] = String.valueOf(dto.getSyutoku());
			aryPaidHoliday[i][4] = String.valueOf(dto.getHaiki());
			aryPaidHoliday[i][5] = String.valueOf(dto.getSyoka());
			i++;
		}
	}
	
	/**
	 * tB[h̑ÓmF
	 * @throws MospException 	MosPOꍇ
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// K{mF
		checkRequired(txtThisSupply, NAM_THIS_SUPPLY, PRM_TXT_THIS_SUPPLY);
		checkRequired(txtLastSupply, NAM_LAST_SUPPLY, PRM_TXT_LAST_SUPPLY);
		checkRequired(txtThisWaste, NAM_THIS_WASTE, PRM_TXT_THIS_WASTE);
		checkRequired(txtLastWaste, NAM_LAST_WASTE, PRM_TXT_LAST_WASTE);
		// mF
		checkNumber(txtThisSupply, NAM_THIS_SUPPLY, PRM_TXT_THIS_SUPPLY);
		checkNumber(txtLastSupply, NAM_LAST_SUPPLY, PRM_TXT_LAST_SUPPLY);
		checkNumeric(txtThisWaste, NAM_THIS_WASTE, PRM_TXT_THIS_WASTE);
		checkNumeric(txtLastWaste, NAM_LAST_WASTE, PRM_TXT_LAST_WASTE);
		// mF	
		checkLength(txtThisSupply, LEN_PAID_HOLIDAY, NAM_THIS_SUPPLY, PRM_TXT_THIS_SUPPLY);
		checkLength(txtLastSupply, LEN_PAID_HOLIDAY, NAM_LAST_SUPPLY, PRM_TXT_LAST_SUPPLY);
		checkLength(txtThisWaste, LEN_PAID_HOLIDAY, NAM_THIS_WASTE, PRM_TXT_THIS_WASTE);
		checkLength(txtLastWaste, LEN_PAID_HOLIDAY, NAM_LAST_WASTE, PRM_TXT_LAST_WASTE);
		// ÓmFI
		endValidation();
	}
	
	@Override
	public String getDirectJs(Class<?> cls, Object obj) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls, obj));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		return sb.toString();
	}
	
	// ANZT\bh	
	/**
	 * @return hidSelectKCode
	 */
	public String getHidSelectKCode() {
		return hidSelectKCode;
	}
	
	/**
	 * @return hidTotalRemain
	 */
	public String getHidTotalRemain() {
		return hidTotalRemain;
	}
	
	/**
	 * @return hidThisRemain
	 */
	public String getHidThisRemain() {
		return hidThisRemain;
	}
	
	/**
	 * @return hidLastRemain
	 */
	public String getHidLastRemain() {
		return hidLastRemain;
	}
	
	/**
	 * @return hidSupply
	 */
	public String getHidSupply() {
		return hidSupply;
	}
	
	/**
	 * @return hidWaste
	 */
	public String getHidWaste() {
		return hidWaste;
	}
	
	/**
	 * @return lblTotalRemain
	 */
	public String getLblTotalRemain() {
		return lblTotalRemain;
	}
	
	/**
	 * @return lblThisRemain
	 */
	public String getLblThisRemain() {
		return lblThisRemain;
	}
	
	/**
	 * @return lblLastRemain
	 */
	public String getLblLastRemain() {
		return lblLastRemain;
	}
	
	/**
	 * @return txtThisSupply
	 */
	public String getTxtThisSupply() {
		return txtThisSupply;
	}
	
	/**
	 * @return txtLastSupply
	 */
	public String getTxtLastSupply() {
		return txtLastSupply;
	}
	
	/**
	 * @return txtThisWaste
	 */
	public String getTxtThisWaste() {
		return txtThisWaste;
	}
	
	/**
	 * @return txtLastWaste
	 */
	public String getTxtLastWaste() {
		return txtLastWaste;
	}
	
	/**
	 * @return txtTotalRemain
	 */
	public String getTxtTotalRemain() {
		return txtTotalRemain;
	}
	
	/**
	 * @return txtThisRemain
	 */
	public String getTxtThisRemain() {
		return txtThisRemain;
	}
	
	/**
	 * @return txtLastRemain
	 */
	public String getTxtLastRemain() {
		return txtLastRemain;
	}
	
	/**
	 * @return hidSelectYear
	 */
	public String getHidSelectYear() {
		return hidSelectYear;
	}
	
	/**
	 * @return hidSelectMonth
	 */
	public String getHidSelectMonth() {
		return hidSelectMonth;
	}
	
	/**
	 * @return hidSelectYearMonth
	 */
	public String getHidSelectYearMonth() {
		return hidSelectYearMonth;
	}
	
	/**
	 * @return lblSelectYearMonth
	 */
	public String getLblSelectYearMonth() {
		return lblSelectYearMonth;
	}
	
	/**
	 * @return aryPaidHoliday
	 */
	public String[][] getAryPaidHoliday() {
		return aryPaidHoliday.clone();
	}
	
	/**
	 * @return mode
	 */
	public int getMode() {
		return mode;
	}
	
	/**
	 * @param hidSelectKCode Zbg hidSelectKCode
	 */
	public void setHidSelectKCode(String hidSelectKCode) {
		this.hidSelectKCode = hidSelectKCode;
	}
	
	/**
	 * @param hidTotalRemain Zbg hidTotalRemain
	 */
	public void setHidTotalRemain(String hidTotalRemain) {
		this.hidTotalRemain = hidTotalRemain;
	}
	
	/**
	 * @param hidThisRemain Zbg hidThisRemain
	 */
	public void setHidThisRemain(String hidThisRemain) {
		this.hidThisRemain = hidThisRemain;
	}
	
	/**
	 * @param hidLastRemain Zbg hidLastRemain
	 */
	public void setHidLastRemain(String hidLastRemain) {
		this.hidLastRemain = hidLastRemain;
	}
	
	/**
	 * @param hidSupply Zbg hidSupply
	 */
	public void setHidSupply(String hidSupply) {
		this.hidSupply = hidSupply;
	}
	
	/**
	 * @param hidWaste Zbg hidWaste
	 */
	public void setHidWaste(String hidWaste) {
		this.hidWaste = hidWaste;
	}
	
	/**
	 * @param lblTotalRemain Zbg lblTotalRemain
	 */
	public void setLblTotalRemain(String lblTotalRemain) {
		this.lblTotalRemain = lblTotalRemain;
	}
	
	/**
	 * @param lblThisRemain Zbg lblThisRemain
	 */
	public void setLblThisRemain(String lblThisRemain) {
		this.lblThisRemain = lblThisRemain;
	}
	
	/**
	 * @param lblLastRemain Zbg lblLastRemain
	 */
	public void setLblLastRemain(String lblLastRemain) {
		this.lblLastRemain = lblLastRemain;
	}
	
	/**
	 * @param txtThisSupply Zbg txtThisSupply
	 */
	public void setTxtThisSupply(String txtThisSupply) {
		this.txtThisSupply = txtThisSupply;
	}
	
	/**
	 * @param txtLastSupply Zbg txtLastSupply
	 */
	public void setTxtLastSupply(String txtLastSupply) {
		this.txtLastSupply = txtLastSupply;
	}
	
	/**
	 * @param txtThisWaste Zbg txtThisWaste
	 */
	public void setTxtThisWaste(String txtThisWaste) {
		this.txtThisWaste = txtThisWaste;
	}
	
	/**
	 * @param txtLastWaste Zbg txtLastWaste
	 */
	public void setTxtLastWaste(String txtLastWaste) {
		this.txtLastWaste = txtLastWaste;
	}
	
	/**
	 * @param txtTotalRemain Zbg txtTotalRemain
	 */
	public void setTxtTotalRemain(String txtTotalRemain) {
		this.txtTotalRemain = txtTotalRemain;
	}
	
	/**
	 * @param txtThisRemain Zbg txtThisRemain
	 */
	public void setTxtThisRemain(String txtThisRemain) {
		this.txtThisRemain = txtThisRemain;
	}
	
	/**
	 * @param txtLastRemain Zbg txtLastRemain
	 */
	public void setTxtLastRemain(String txtLastRemain) {
		this.txtLastRemain = txtLastRemain;
	}
	
	/**
	 * @param hidSelectYear Zbg hidSelectYear
	 */
	public void setHidSelectYear(String hidSelectYear) {
		this.hidSelectYear = hidSelectYear;
	}
	
	/**
	 * @param hidSelectMonth Zbg hidSelectMonth
	 */
	public void setHidSelectMonth(String hidSelectMonth) {
		this.hidSelectMonth = hidSelectMonth;
	}
	
	/**
	 * @param hidSelectYearMonth Zbg hidSelectYearMonth
	 */
	public void setHidSelectYearMonth(String hidSelectYearMonth) {
		this.hidSelectYearMonth = hidSelectYearMonth;
	}
	
	/**
	 * @param lblSelectYearMonth Zbg lblSelectYearMonth
	 */
	public void setLblSelectYearMonth(String lblSelectYearMonth) {
		this.lblSelectYearMonth = lblSelectYearMonth;
	}
	
	/**
	 * @param aryPaidHoliday Zbg aryPaidHoliday
	 */
	public void setAryPaidHoliday(String[][] aryPaidHoliday) {
		this.aryPaidHoliday = aryPaidHoliday.clone();
	}
	
	/**
	 * @param mode Zbg mode
	 */
	public void setMode(int mode) {
		this.mode = mode;
	}
	
}
