/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/**
 * 
 */
package jp.mosp.kintai.payroll.action;

import java.util.Date;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.NumberUtil;
import jp.mosp.common.utils.VariousUtil;
import jp.mosp.kintai.common.action.KintaiCommonAction;
import jp.mosp.kintai.common.part.SubstituteHolidayPart;
import jp.mosp.kintai.payroll.dao.KdSubstituteHolidayDao;
import jp.mosp.kintai.payroll.dto.KdSubstituteHolidayDto;
import jp.mosp.kintai.payroll.dto.KdWorkDto;
import jp.mosp.kintai.payroll.vo.SubHolidayCloseOperationCardVo;

/**
 * @author matsusita
 *
 */
public class SubHolidayCloseOperationCardAction extends KintaiCommonAction {
	
	// R}h
	private static final String	CMD_OPERATION_CARD_SHOW		= "P1330";
	private static final String	CMD_OPERATION_CARD_REGIST	= "P1331";
	

	/**
	 * RXgN^B
	 */
	public SubHolidayCloseOperationCardAction() {
		super();
	}
	
	public void action() throws Exception {
		// VO̎擾
		prepareVo();
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_OPERATION_CARD_SHOW)) {
			// \
			show();
		} else if (cmd.equals(CMD_OPERATION_CARD_REGIST)) {
			// Jn
			regist();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new SubHolidayCloseOperationCardVo();
	}
	
	@Override
	protected void init() throws Exception {
		// PAYROLLmF
		confirmPayrollAuth();
	}
	
	@Override
	protected void show() throws Exception {
		SubHolidayCloseOperationCardVo vo = (SubHolidayCloseOperationCardVo)getVo();
		Date calcMonth = getCalcMonth();
		int occurYear = MospUtility.getYear(calcMonth);
		int occurMonth = MospUtility.getMonth(calcMonth);
		// N
		vo.setHidOccurYear(String.valueOf(occurYear));
		// 
		vo.setHidOccurMonth(String.valueOf(occurMonth));
		// WvJn
		vo.setLblStartDate(DateUtil.convDateFormatted(getStartDate(calcMonth)));
		// WvI
		vo.setLblEndDate(DateUtil.convDateFormatted(getEndDate(calcMonth)));
		if (part().subHoliday().getKdSubstituteHolidayDao().findForCondition(occurYear, occurMonth,
				CommonConst.CODE_DECISION_STATUS_INIT, DateUtil.getSystemDate()).size() == 0) {
			// [hݒ
			vo.setMode(SubHolidayCloseOperationCardVo.MODE_IMPOSSIBLE);
		}
	}
	
	private void regist() throws Exception {
		SubHolidayCloseOperationCardVo vo = (SubHolidayCloseOperationCardVo)getVo();
		vo.setParams(request);
		// p[^̑ÓmF
		vo.validate();
		// DAȌ
		KdSubstituteHolidayDao dao = part().subHoliday().getKdSubstituteHolidayDao();
		Date date = DateUtil.getSystemDate();
		// o^
		int number = 0;
		List<KdSubstituteHolidayDto> list = dao.findForCondition(NumberUtil.getIntParam(vo.getHidOccurYear()),
				NumberUtil.getIntParam(vo.getHidOccurMonth()), CommonConst.CODE_DECISION_STATUS_INIT, date);
		for (KdSubstituteHolidayDto dto : list) {
			// Jg
			setLaborAgreementInfo(dto.getKCode(), date);
			KdWorkDto workDto = part().compile().getKdWorkInfo(dto.getKCode(), vo.getHidOccurYear(),
					vo.getHidOccurMonth());
			if (SubstituteHolidayPart.isAttitudeInit(dto)) {
				// mF͉̏ꍇ
				dto.setAttitudeStatus(CommonConst.CODE_ATTITUDE_STATUS_FIXED);
				dto.setPaymentAcquireTime(0);
				dto.setPaymentAcquireHoliday(0);
				dto.setPaymentQuitTime(0);
				dto.setLiquidationOverTime(0);
				dto.setLiquidationWeekHoliday(0);
				if (VariousUtil.isNotNull(agreement)) {
					// Z
					double rate = Double.valueOf(agreement.getSubQuitRate() - agreement.getSubAcquireRate())
							/ CommonConst.NUM_PERCENTAGE;
					// xZ
					double holidayRate = Double.valueOf(agreement.getSubQuitRate()
							- agreement.getSubAcquireHolidayRate())
							/ CommonConst.NUM_PERCENTAGE;
					int liquidationOverTime = Double.valueOf(workDto.getMonthlyOverTime() * rate).intValue();
					int liquidationWeekHoliday = Double.valueOf(workDto.getMonthlyWeekHoliday() * holidayRate)
						.intValue();
					dto.setPaymentQuitTime(liquidationOverTime + liquidationWeekHoliday);
					dto.setLiquidationOverTime(liquidationOverTime);
					dto.setLiquidationWeekHoliday(liquidationWeekHoliday);
				}
				dto.setUseHolidayTime(0);
				dto.setAcquisitionStatus(CommonConst.CODE_ACQUISITION_STATUS_FINISH);
				dto.setDecisionStatus(CommonConst.CODE_DECISION_STATUS_PAYMENT);
			} else if (SubstituteHolidayPart.isAttitudeFixed(dto)) {
				// ӌmFς̏ꍇ
				dto.setAcquisitionStatus(CommonConst.CODE_ACQUISITION_STATUS_REMAIN);
				dto.setDecisionStatus(CommonConst.CODE_DECISION_STATUS_FIXED);
				if (dto.getPaymentAcquireTime() + dto.getPaymentAcquireHoliday() == 0) {
					dto.setAcquisitionStatus(CommonConst.CODE_ACQUISITION_STATUS_FINISH);
					dto.setDecisionStatus(CommonConst.CODE_DECISION_STATUS_PAYMENT);
				}
			}
			// rmF
			chkExclusive(dto, dao.findForKey(dto.getSubstituteId()));
			// f[^̍XV
			dao.update(dto);
			// DTO̍Ď擾
			chkUpdate(dao.findForKey(dto.getSubstituteId()));
			number++;
		}
		// R~bg
		commit();
		// bZ[Wݒ
		setMessage(getMessage(CommonConst.MSG_NUMBER_OF_UPDATES, String.valueOf(number)));
		// [hݒ
		vo.setMode(SubHolidayCloseOperationCardVo.MODE_IMPOSSIBLE);
	}
}
