/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.common.action;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.dao.MosPUserDao;
import jp.mosp.common.dto.CmUserDto;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.human.action.HumanKihonCardAction;
import jp.mosp.human.action.HumanPersonalCardAction;
import jp.mosp.human.dao.MEmergencyDao;
import jp.mosp.human.dao.MKojinDao;
import jp.mosp.human.dto.MEmergencyDto;
import jp.mosp.human.dto.MKojinDto;
import jp.mosp.human.vo.HumanCardVo;
import jp.mosp.human.vo.HumanKihonCardVo;
import jp.mosp.kintai.common.dao.MKihonDao;
import jp.mosp.kintai.common.dto.MKihonDto;

/**
 * @author yoshida
 *
 */
public abstract class MosPHumanAction extends KintaiCommonAction {
	
	// tB[h
	/**
	 * 
	 */
	protected MKihonDto		mKihonDto;
	/**
	 * 
	 */
	protected MKihonDto		storedmKihonDto;
	/**
	 * 
	 */
	protected MKojinDto		mKojinDto;
	/**
	 * 
	 */
	protected MEmergencyDto	mEmergencyDto;
	

	/**
	 * l{pDAO擾
	 * @return	MKihonDao
	 * @throws Exception	Oꍇ
	 */
	protected MKihonDao humanBasisDao() throws Exception {
		return part().human().getMKihonDao();
	}
	
	/**
	 * lpDAO擾
	 * @return	MKojinDao
	 * @throws Exception	Oꍇ
	 */
	protected MKojinDao humanParsonalDao() throws Exception {
		return part().human().getMKojinDao();
	}
	
	/**
	 * ً}pDAO擾
	 * @return	MEmergencyDao
	 * @throws Exception Oꍇ
	 */
	protected MEmergencyDao emergencyDao() throws Exception {
		return part().human().getMEmergencyDao();
	}
	
	/**
	 * l{擾
	 * @param kCode       ЈR[h
	 * @param isForUpdate Abvf[gptO
	 * @throws Exception 	Oꍇ
	 */
	protected void findHumanBasisInfo(String kCode, boolean isForUpdate) throws Exception {
		// ݂̏擾
		if (isForUpdate) {
			mKihonDto = humanBasisDao().findForUpdate(kCode);
		} else {
			mKihonDto = humanBasisDao().findForKey(kCode);
		}
	}
	
	/**
	 * l擾
	 * @param kCode       ЈR[h
	 * @param isForUpdate Abvf[gptO
	 * @throws Exception 	Oꍇ
	 */
	protected void findHumanPersonnelInfo(String kCode, boolean isForUpdate) throws Exception {
		// ݂̏擾
		if (isForUpdate) {
			mKojinDto = humanParsonalDao().findForUpdate(kCode);
		} else {
			mKojinDto = humanParsonalDao().findForKey(kCode);
		}
	}
	
	/**
	 * ً}A擾
	 * @param kCode       ЈR[h
	 * @param isForUpdate Abvf[gptO
	 * @throws Exception 	Oꍇ
	 */
	protected void findHumanEmergencyInfo(String kCode, boolean isForUpdate) throws Exception {
		mEmergencyDto = new MEmergencyDto();
		String maxEno = emergencyDao().findForMax(kCode);
		// ݂̏擾
		if (isForUpdate) {
			mEmergencyDto = emergencyDao().findForConditionUp(maxEno, kCode);
		} else {
			mEmergencyDto = emergencyDao().findForCondition(maxEno, kCode);
		}
	}
	
	/**
	 * ύXe擾
	 * @param kCode ЈR[h
	 * @return ύXe
	 * @throws Exception 	Oꍇ
	 */
	protected String getChanging(String kCode) throws Exception {
		// l{擾
		findHumanBasisInfo(kCode, false);
		// ύXe擾
		StringBuffer sb = new StringBuffer();
		if (mKihonDto == null) {
			sb.append(CommonConst.NAM_MAKE_NEW_DATA);
		} else {
			if (sb.length() > 0) {
				return sb.substring(0, sb.length() - 1);
			}
		}
		return sb.toString();
	}
	
	/**
	 * [UKp
	 * @param kCode        ЈR[h
	 * @param isBatchApply ꊇKptO(trueFꊇKpAfalseFʓKp)
	 * @return 
	 * @throws Exception	Oꍇ
	 */
	protected int applyHistory(String kCode, boolean isBatchApply) throws Exception {
		// l{擾
		findHumanBasisInfo(kCode, false);
		// rmF
		if (!isBatchApply && storedmKihonDto != null) {
			chkExclusive(storedmKihonDto, mKihonDto);
		} else {
			// l{擾
			storedmKihonDto = humanBasisDao().findForKey(kCode);
		}
		// [U[擾
		MosPUserDao mospuserDao = part().mospuser().getMosPUserDao();
		CmUserDto cmUserDto = mospuserDao.findForUpdate(kCode);
		// [U
		if (cmUserDto == null) {
			// [U[̍쐬
			cmUserDto = new CmUserDto();
			cmUserDto.setUserId(kCode);
			cmUserDto.setPassword(MospUtility.getDigest(MospUtility.getDigest(kCode)));
			cmUserDto.setKCode(kCode);
			cmUserDto.setUserName(mKihonDto.getSimei());
			cmUserDto.setAuthority(CommonConst.AUTH_DEFAULT_USER);
			cmUserDto.setChangePass(DateUtil.getNowDate());
			cmUserDto.setDataLevel(CommonConst.DATA_DEFAULT_LEVEL);
			cmUserDto.setDeleteFlag(mKihonDto.getTsDate() == 0 ? CommonConst.DEFAULT_FLAG_OFF
					: CommonConst.DEFAULT_FLAG_ON);
			mospuserDao.insert(cmUserDto);
		} else {
			// [U̍XV
			cmUserDto.setUserName(mKihonDto.getSimei());
			cmUserDto.setDeleteFlag(mKihonDto.getTsDate() == 0 ? CommonConst.DEFAULT_FLAG_OFF
					: CommonConst.DEFAULT_FLAG_ON);
			mospuserDao.update(cmUserDto, true);
		}
		return 1;
	}
	
	/**
	 * IЈl{擾
	 * @throws Exception 	Oꍇ
	 */
	protected void getSelectedEmployeeBasis() throws Exception {
		HumanCardVo vo = (HumanCardVo)getVo();
		// IЈR[h擾
		String kCode = "";
		if (StringUtil.isNotNull(vo.getTxtChangeKCode())) {
			kCode = vo.getTxtChangeKCode();
		} else if (StringUtil.isNotNull(key1)) {
			kCode = key1;
		} else {
			HumanKihonCardVo kihonVo = (HumanKihonCardVo)getStoredVo(HumanKihonCardVo.class.getName());
			if (kihonVo == null) {
				// {ʂ֖߂({񂪖ꍇ)
				throwNoBasisException();
			} else {
				kCode = kihonVo.getTxtKCode() == null ? "" : kihonVo.getTxtKCode();
			}
		}
		// l{擾
		findHumanBasisInfo(kCode, false);
		if (mKihonDto == null) {
			// {ʂ֖߂({񂪖ꍇ)
			throwNoBasisException();
		}
		// Ј擾
		if (mKihonDto != null) {
			vo.setLblKCode(mKihonDto.getKCode());
			vo.setLblKName(mKihonDto.getSimei());
			vo.setLblKKana(mKihonDto.getFurigana());
		}
	}
	
	/**
	 * l{擾s\
	 * @throws MospException	MosPOꍇ
	 */
	protected void throwNoBasisException() throws MospException {
		String errMessage = getMessage(CommonConst.MSG_NO_HUMAN_DATA, "");
		addErrMessage(errMessage);
		setNextCmd(HumanKihonCardAction.CMD_HUMAN_BASIS_SHOW);
		throw new MospException(CommonConst.EX_NO_BASIS, errMessage);
	}
	
	/**
	 * ZbVێDTO擾
	 */
	protected void getStoredDto() {
		storedmKihonDto = (MKihonDto)session.getAttribute(MKihonDto.class.getName());
	}
	
	/**
	 * ZbVێDTOݒ
	 */
	protected void setStoredDto() {
		session.setAttribute(MKihonDto.class.getName(), storedmKihonDto);
	}
	
	/**
	 * {^\ݒ
	 */
	protected void setListButton() {
		HumanCardVo vo = (HumanCardVo)getVo();
		vo.setCmdListButton1("H1012");
		vo.setNamListButton1(CommonConst.NAM_TO_HUMAN_LIST);
	}
	
	/**
	 * @\{^ݒ
	 * @param isNewData VKo^tO 
	 */
	protected void setFunctionButton(boolean isNewData) {
		HumanCardVo vo = (HumanCardVo)getVo();
		vo.setAryFunction(getFunctionArray(isNewData));
	}
	
	/**
	 * @\{^z擾
	 * @param isNewData VKo^tO
	 * @return @\{^z
	 */
	protected String[][] getFunctionArray(boolean isNewData) {
		if (isNewData) {
			return new String[][]{ { "btnNewData", HumanKihonCardAction.CMD_HUMAN_BASIS_SHOW,
				CommonConst.NAM_MAKE_NEW_DATA }, };
		} else {
			return new String[][]{
				{ "btnBasic", HumanKihonCardAction.CMD_HUMAN_BASIS_SELECT, CommonConst.NAM_EDIT_HUMAN_BASIC },
				{ "btnKojin", HumanPersonalCardAction.CMD_HUMAN_PERSONAL_SELECT, CommonConst.NAM_EDIT_HUMAN_KOJIN }, };
		}
	}
	
}
