/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Date;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.MospUtility;

import org.apache.commons.csv.CSVParser;

/**
 * CSVt@CɊւPartNX
 * @author yoshida
 *	@version	0.0.1
 */
public class CsvUtil {
	
	/**
	 * RXgN^
	 */
	private CsvUtil() {
	}
	
	/**
	 * CSVt@CReader擾
	 * @param csvFile	ΏCSVt@C
	 * @return	ΏCSVt@CpBufferedReader
	 * @throws FileNotFoundException	t@CȂꍇ
	 */
	public static BufferedReader getCsvFileReader(File csvFile) throws FileNotFoundException {
		return new BufferedReader(new InputStreamReader(new FileInputStream(csvFile), Charset.forName("JISAutoDetect")));
	}
	
	/**
	 * CSVt@C̎擾
	 * @param csvFile		ΏCSVt@C
	 * @return	CSVt@C
	 * @throws IOException	o͂ŃG[ꍇ
	 */
	public static String[][] getAllValues(File csvFile) throws IOException {
		BufferedReader reader = getCsvFileReader(csvFile);
		CSVParser parser = new CSVParser(reader);
		String[][] aryValues = parser.getAllValues();
		reader.close();
		if (VariousUtil.isNull(aryValues)) {
			return new String[][]{};
		}
		return aryValues;
	}
	
	/**
	 * CSVt@Cwb_[̎擾
	 * @param csvFile		ΏCSVt@C
	 * @return	CSVt@Cwb_[
	 * @throws IOException		o͂ŃG[ꍇ
	 */
	public static String[] getHeader(File csvFile) throws IOException {
		return getAllValues(csvFile).clone()[0];
	}
	
	/**
	 * CSVt@Cpf[^ϊ
	 * @param array		Ώ۔z
	 * @return	CSVt@Cpf[^
	 */
	public static String toCsvLine(String[] array) {
		StringBuffer sb = new StringBuffer();
		for (String value : array) {
			sb.append(getCsvData(value));
			sb.append(CommonConst.STR_CSV_SEPARATOR);
		}
		sb.deleteCharAt(sb.lastIndexOf(CommonConst.STR_CSV_SEPARATOR));
		sb.append(CommonConst.STR_CSV_NEW_LINE);
		return sb.toString();
	}
	
	/**
	 * ""t
	 * @param data tΏۃf[^
	 * @return t㕶
	 */
	public static String getCsvData(String data) {
		if (data == null) {
			return "";
		}
		String newData = data.replaceAll("\"", "\"\"");
		return "\"" + newData + "\"";
	}
	
	/**
	 * ""t
	 * @param data tΏۃf[^
	 * @return t㕶
	 */
	public static String getCsvData(int data) {
		return "\"" + String.valueOf(data) + "\"";
	}
	
	/**
	 * ""t
	 * @param data tΏۃf[^
	 * @return t㕶
	 */
	public static String getCsvData(float data) {
		return "\"" + String.valueOf(data) + "\"";
	}
	
	/**
	 * ""t
	 * @param data tΏۃf[^
	 * @param format	to̓tH[}bg
	 * @return t㕶
	 */
	public static String getCsvData(Date data, String format) {
		if (data == null) {
			return "";
		}
		String newData = MospUtility.getDateString(data, format);
		return "\"" + newData + "\"";
	}
	
}
