/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.legal;

import java.math.BigDecimal;

public class LegalUtility {
    private static int[][] aryIncomeDeduction = new int[][]{{135417, 0, 54167}, {150000, 40, 0}, {300000, 30, 15000}, {550000, 20, 45000}, {833334, 10, 100000}, {0, 5, 141667}};
    private static int dependentDeductionUnit = 31667;
    private static int baseDeductionUnit = 31667;
    private static int[][] aryIncomeTax = new int[][]{{162501, 5, 0}, {275001, 10, 8125}, {579167, 20, 35625}, {750001, 23, 53000}, {1500001, 33, 128000}, {0, 40, 233000}};
    private static int[][] aryIncomeFloor = new int[][]{{88000, 98999, 1000}, {99000, 220999, 2000}, {221000, 1009999, 3000}};
    private static int incomeOtuBase = 367400;
    private static int incomeOtuLower = 88000;
    private static int incomeOtuHigher = 1010000;
    private static float incomeOtuCalcRate1 = 0.03f;
    private static float incomeOtuCalcRate2 = 0.38f;
    private static float incomeOtuBaseAll = 2.5f;
    private static float incomeOtuBaseMain = 1.5f;
    private static double[] aryBonusIncomeRate = new double[]{2.0, 4.0, 6.0, 8.0, 10.0, 12.0, 14.0, 16.0, 18.0, 20.0, 22.0, 24.0, 26.0, 28.0, 30.0, 32.0, 35.0, 38.0};
    private static double[] arySuportRate0 = new double[]{68.0, 79.0, 252.0, 300.0, 334.0, 363.0, 395.0, 426.0, 550.0, 668.0, 714.0, 750.0, 791.0, 847.0, 917.0, 1280.0, 1482.0, 1761.0};
    private static double[] arySuportRate1 = new double[]{94.0, 243.0, 282.0, 338.0, 365.0, 394.0, 422.0, 455.0, 550.0, 689.0, 738.0, 775.0, 817.0, 876.0, 949.0, 1304.0, 1510.0, 1794.0};
    private static double[] arySuportRate2 = new double[]{133.0, 269.0, 312.0, 369.0, 393.0, 420.0, 450.0, 484.0, 550.0, 710.0, 762.0, 801.0, 844.0, 905.0, 950.0, 1328.0, 1538.0, 1828.0};
    private static double[] arySuportRate3 = new double[]{171.0, 295.0, 345.0, 398.0, 417.0, 445.0, 477.0, 513.0, 557.0, 730.0, 786.0, 826.0, 872.0, 934.0, 1012.0, 1352.0, 1566.0, 1861.0};
    private static double[] arySuportRate4 = new double[]{210.0, 300.0, 378.0, 424.0, 444.0, 470.0, 504.0, 543.0, 592.0, 751.0, 810.0, 852.0, 901.0, 963.0, 1043.0, 1377.0, 1594.0, 1894.0};
    private static double[] arySuportRate5 = new double[]{243.0, 300.0, 406.0, 450.0, 472.0, 496.0, 531.0, 574.0, 622.0, 771.0, 834.0, 879.0, 929.0, 992.0, 1074.0, 1401.0, 1622.0, 1928.0};
    private static double[] arySuportRate6 = new double[]{275.0, 333.0, 431.0, 476.0, 499.0, 525.0, 559.0, 604.0, 652.0, 792.0, 859.0, 905.0, 957.0, 1021.0, 1106.0, 1425.0, 1651.0, 1961.0};
    private static double[] arySuportRate7 = new double[]{308.0, 372.0, 456.0, 502.0, 527.0, 553.0, 588.0, 632.0, 683.0, 812.0, 884.0, 932.0, 985.0, 1050.0, 1137.0, 1449.0, 1679.0, 1994.0};
    private static double[] aryRankRate = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 241.0, 0.0, 0.0, 0.0, 0.0, 305.0, 0.0, 0.0, 0.0, 0.0, 563.0, 0.0, 563.0};
    private static int[][] aryAdjustType = new int[][]{{1000, 1619000}, {2000, 1620000}, {4000, 1624000}};
    private static int[] aryMaxTotalPayment = new int[]{1619999, 1623999, 6599999};
    private static int[] aryAdjustPaymentType = new int[]{1619999, 1621999, 1623999, 1627999, 1799999, 3599999, 6599999, 9999999, 20000000};
    private static int[][] aryPaymentCalc = new int[][]{{60, 2400}, {60, 2000}, {60, 1200}, {60, 400}, {60, 0}, {70, 180000}, {80, 540000}, {90, 1200000}, {95, 1700000}};
    private static int[] aryCalcIncomeTax = new int[]{1950000, 3300000, 6950000, 9000000, 16920000};
    private static int[][] aryCalcIncomeTaxRatio = new int[][]{{5, 0}, {10, 97500}, {20, 427500}, {23, 636000}, {33, 0x177000}};
    private static int[][] ARY_COMMUTE_LIMIT = new int[][]{{2, 0}, {10, 4100}, {15, 6500}, {25, 11300}, {35, 16100}, {45, 20900}, {45, 24500}};
    private static int COMMUTE_LIMIT = 100000;

    public static String getMospLegalJarVersion() {
        return "1.0.2";
    }

    public static int calcIncomeTax(String incomeTaxType, int income, int dependent) {
        if ("1".equals(incomeTaxType)) {
            return LegalUtility.calcIncomeTax(income, dependent);
        }
        if ("2".equals(incomeTaxType)) {
            return LegalUtility.calcIncomeTaxOtu(income);
        }
        return 0;
    }

    private static int calcIncomeTax(int income, int dependent) {
        int incomeDeduction = LegalUtility.calcIncomeDeduction(income);
        int dependentDeduction = LegalUtility.calcDependentDeduction(dependent);
        int baseDeduction = LegalUtility.calcBaseDeduction();
        int taxation = income - incomeDeduction - dependentDeduction - baseDeduction;
        return LegalUtility.calcIncomeTax(taxation);
    }

    private static int calcIncomeTaxOtu(int income) {
        int incomeOtu = 0;
        incomeOtu = income < incomeOtuLower ? LegalUtility.calcIncomeTaxOtu1(income) : (incomeOtuHigher < income ? LegalUtility.calcIncomeTaxOtu2(income) : LegalUtility.calcIncomeTaxOtu3(income));
        return incomeOtu;
    }

    private static int calcIncomeTaxOtu1(int income) {
        int incomeOtu = 0;
        incomeOtu = (int)LegalUtility.round((float)income * incomeOtuCalcRate1, -2, 4);
        return incomeOtu > 0 ? incomeOtu : 0;
    }

    private static int calcIncomeTaxOtu2(int income) {
        int incomeOtu = 0;
        float exceedMoney = (float)(income - incomeOtuHigher) * incomeOtuCalcRate2;
        incomeOtu = (int)LegalUtility.round(exceedMoney + (float)incomeOtuBase, -2, 4);
        return incomeOtu > 0 ? incomeOtu : 0;
    }

    private static int calcIncomeTaxOtu3(int income) {
        int baseDeductionMain;
        int incomeDeductionMain;
        int basicAmountMain;
        int taxationMain;
        int incomeTaxMain;
        int baseDeductionAll;
        int incomeDeductionAll;
        int basicAmount = LegalUtility.calcBasic(income);
        int basicAmountAll = (int)((float)basicAmount * incomeOtuBaseAll);
        int taxationAll = basicAmountAll - (incomeDeductionAll = LegalUtility.calcIncomeDeduction(basicAmountAll)) - (baseDeductionAll = LegalUtility.calcBaseDeduction());
        int incomeTaxAll = LegalUtility.calcIncomeTax(taxationAll);
        int incomeOtu = (int)LegalUtility.round(incomeTaxAll - (incomeTaxMain = LegalUtility.calcIncomeTax(taxationMain = (basicAmountMain = (int)((float)basicAmount * incomeOtuBaseMain)) - (incomeDeductionMain = LegalUtility.calcIncomeDeduction(basicAmountMain)) - (baseDeductionMain = LegalUtility.calcBaseDeduction()))), -2, 4);
        return incomeOtu > 0 ? incomeOtu : 0;
    }

    private static int calcBasic(int income) {
        if (income == incomeOtuHigher) {
            return income;
        }
        int index = 0;
        for (index = 0; index < aryIncomeFloor.length && income >= aryIncomeFloor[index][1]; ++index) {
        }
        if (index >= aryIncomeFloor.length) {
            index = aryIncomeFloor.length - 1;
        }
        int difference = (int)LegalUtility.round((income - aryIncomeFloor[index][0]) % aryIncomeFloor[index][2], 0, 1);
        return income - difference;
    }

    private static int calcIncomeDeduction(int income) {
        int index = 0;
        for (index = 0; index < aryIncomeDeduction.length && income >= aryIncomeDeduction[index][0]; ++index) {
        }
        if (index >= aryIncomeDeduction.length) {
            index = aryIncomeDeduction.length - 1;
        }
        return (int)LegalUtility.round((float)income * (float)aryIncomeDeduction[index][1] / 100.0f + (float)aryIncomeDeduction[index][2], 0, 2);
    }

    private static int calcDependentDeduction(int dependent) {
        return dependentDeductionUnit * dependent;
    }

    private static int calcBaseDeduction() {
        return baseDeductionUnit;
    }

    private static int calcIncomeTax(int taxation) {
        int incomeTax;
        int index = 0;
        for (index = 0; index < aryIncomeTax.length && taxation >= aryIncomeTax[index][0]; ++index) {
        }
        if (index >= aryIncomeTax.length) {
            index = aryIncomeTax.length - 1;
        }
        return (incomeTax = (int)LegalUtility.round((float)taxation * (float)aryIncomeTax[index][1] / 100.0f - (float)aryIncomeTax[index][2], -1, 4)) > 0 ? incomeTax : 0;
    }

    public static int calcPremium(int standardPay, float ratio, int mode) {
        int premium = (int)LegalUtility.round((float)standardPay * ratio, 0, mode);
        return premium < 0 ? 0 : premium;
    }

    public static int getBasisHealthPayment(int allBonusAllowance, int bonusAllowance) {
        int totalBonusUpperAmount = 5400000;
        int helthPayment = 0;
        if (allBonusAllowance + bonusAllowance >= totalBonusUpperAmount) {
            if (allBonusAllowance > totalBonusUpperAmount) {
                helthPayment = 0;
            } else {
                int total = allBonusAllowance + bonusAllowance - totalBonusUpperAmount;
                helthPayment = bonusAllowance - total;
            }
        } else {
            helthPayment = bonusAllowance;
        }
        return helthPayment / 1000;
    }

    public static int getBasisNursingPayment(int allBonusAllowance, int bonusAllowance) {
        int totalBonusUpperAmount = 5400000;
        int nursingPayment = 0;
        if (allBonusAllowance + bonusAllowance >= totalBonusUpperAmount) {
            if (allBonusAllowance > totalBonusUpperAmount) {
                nursingPayment = 0;
            } else {
                int total = allBonusAllowance + bonusAllowance - totalBonusUpperAmount;
                nursingPayment = bonusAllowance - total;
            }
        } else {
            nursingPayment = bonusAllowance;
        }
        return nursingPayment / 1000;
    }

    public static int getBasisPensionPayment(int bonusAllowance) {
        int totalAllowanceUpperAmount = 1500000;
        int pensionPayment = 0;
        pensionPayment = bonusAllowance > totalAllowanceUpperAmount ? totalAllowanceUpperAmount : bonusAllowance;
        return pensionPayment / 1000;
    }

    public static int getBasisFundPayment(int bonusAllowance) {
        int totalAllowanceUpperAmount = 1500000;
        int fundPayment = 0;
        fundPayment = bonusAllowance > totalAllowanceUpperAmount ? totalAllowanceUpperAmount : bonusAllowance;
        return fundPayment / 1000;
    }

    public static int getBasisUnemployPayment(int bonusAllowance) {
        return bonusAllowance / 1000;
    }

    public static int calcBonusIncomeTax(String incomeTaxType, int payTaxation, int bonusTaxation, int dependent) {
        double incomeTaxRate;
        int incomeTax = 0;
        if ("1".equals(incomeTaxType)) {
            switch (dependent) {
                case 0: {
                    incomeTaxRate = LegalUtility.getBonusIncomeRate(arySuportRate0, payTaxation);
                    break;
                }
                case 1: {
                    incomeTaxRate = LegalUtility.getBonusIncomeRate(arySuportRate1, payTaxation);
                    break;
                }
                case 2: {
                    incomeTaxRate = LegalUtility.getBonusIncomeRate(arySuportRate2, payTaxation);
                    break;
                }
                case 3: {
                    incomeTaxRate = LegalUtility.getBonusIncomeRate(arySuportRate3, payTaxation);
                    break;
                }
                case 4: {
                    incomeTaxRate = LegalUtility.getBonusIncomeRate(arySuportRate4, payTaxation);
                    break;
                }
                case 5: {
                    incomeTaxRate = LegalUtility.getBonusIncomeRate(arySuportRate5, payTaxation);
                    break;
                }
                case 6: {
                    incomeTaxRate = LegalUtility.getBonusIncomeRate(arySuportRate6, payTaxation);
                    break;
                }
                case 7: {
                    incomeTaxRate = LegalUtility.getBonusIncomeRate(arySuportRate7, payTaxation);
                    break;
                }
                default: {
                    incomeTaxRate = 0.0;
                    break;
                }
            }
        } else {
            incomeTaxRate = "2".equals(incomeTaxType) ? LegalUtility.getBonusIncomeRate(aryRankRate, payTaxation) : ("0".equals(incomeTaxType) ? 0.0 : LegalUtility.getBonusIncomeRate(arySuportRate0, payTaxation));
        }
        incomeTax = LegalUtility.calcIncomeTax(bonusTaxation, incomeTaxRate);
        return incomeTax;
    }

    public static double[] getBonIncomeTaxArray(String incomeTaxType, int dependent) {
        if ("1".equals(incomeTaxType)) {
            switch (dependent) {
                case 0: {
                    return (double[])arySuportRate0.clone();
                }
                case 1: {
                    return (double[])arySuportRate1.clone();
                }
                case 2: {
                    return (double[])arySuportRate2.clone();
                }
                case 3: {
                    return (double[])arySuportRate3.clone();
                }
                case 4: {
                    return (double[])arySuportRate4.clone();
                }
                case 5: {
                    return (double[])arySuportRate5.clone();
                }
                case 6: {
                    return (double[])arySuportRate6.clone();
                }
                case 7: {
                    return (double[])arySuportRate7.clone();
                }
            }
            return (double[])arySuportRate0.clone();
        }
        if ("2".equals(incomeTaxType)) {
            return (double[])aryRankRate.clone();
        }
        if ("0".equals(incomeTaxType)) {
            return null;
        }
        return (double[])arySuportRate0.clone();
    }

    public static double getBonusIncomeRate(double[] arySuportRate, int taxation) {
        double incomeTaxRate = 0.0;
        if (taxation <= 0) {
            return 0.0;
        }
        int idx = 0;
        for (int i = 0; i < arySuportRate.length; ++i) {
            if ((double)taxation < arySuportRate[0] * 1000.0) {
                return 0.0;
            }
            if (arySuportRate[arySuportRate.length - 1] * 1000.0 < (double)taxation) {
                idx = arySuportRate.length - 1;
                break;
            }
            if (arySuportRate[i] * 1000.0 < (double)taxation) continue;
            idx = i - 1;
            break;
        }
        incomeTaxRate = aryBonusIncomeRate[idx] / 100.0;
        return incomeTaxRate;
    }

    private static int calcIncomeTax(int taxation, double rate) {
        int incomeTaxPremium = 0;
        incomeTaxPremium = (int)LegalUtility.round((double)taxation * rate, 0, 4);
        if (incomeTaxPremium < 0) {
            incomeTaxPremium = 0;
        }
        return incomeTaxPremium;
    }

    public static int setAdjustPayment(int paymentAllowance, int bonusAllowance, int midwayAdjustIncome) {
        int totalPayment = paymentAllowance + bonusAllowance + midwayAdjustIncome;
        int adjustPayment = 0;
        if (totalPayment <= 1618999) {
            adjustPayment = totalPayment;
        } else if (6600000 <= totalPayment) {
            adjustPayment = totalPayment;
        } else {
            int idx = 0;
            for (int i = 0; i < aryMaxTotalPayment.length; ++i) {
                if (totalPayment > aryMaxTotalPayment[i]) continue;
                idx = i;
                break;
            }
            int remnants = 0;
            remnants = (totalPayment - aryAdjustType[idx][1]) % aryAdjustType[idx][0];
            adjustPayment = totalPayment - remnants;
        }
        return adjustPayment;
    }

    public static boolean checkAdjustPayment(int adjustPayment) {
        return 20000000 >= adjustPayment;
    }

    public static int setIncomePaymentData(int adjustPayment) {
        int incomePayment = 0;
        if (adjustPayment <= 650999) {
            return 0;
        }
        if (adjustPayment <= 1618999) {
            incomePayment = (int)LegalUtility.round(adjustPayment - 650000, 0, 1);
            return incomePayment;
        }
        int idx2 = 0;
        for (int i = 0; i < aryAdjustPaymentType.length; ++i) {
            if (adjustPayment > aryAdjustPaymentType[i]) continue;
            idx2 = i;
            break;
        }
        float ratio = (float)aryPaymentCalc[idx2][0] / 100.0f;
        int minus = aryPaymentCalc[idx2][1];
        incomePayment = (int)LegalUtility.round((float)adjustPayment * ratio - (float)minus, 0, 1);
        return incomePayment;
    }

    public static int getAdjustBasisDeduction() {
        return 380000;
    }

    public static int getSpouseIntendType(String spouseIntendType) {
        int spouseDeduction = 0;
        if (spouseIntendType.equals("")) {
            spouseDeduction = 0;
        } else if (spouseIntendType.equals("1")) {
            spouseDeduction = 380000;
        } else if (spouseIntendType.equals("2")) {
            spouseDeduction = 480000;
        } else if (spouseIntendType.equals("3")) {
            spouseDeduction = 730000;
        } else if (spouseIntendType.equals("4")) {
            spouseDeduction = 830000;
        }
        return spouseDeduction;
    }

    public static int getDependentDeduction(int generalDependent, int specificDependent, int elderlyDependent, int liveWithEldRel, int liveWithHandiGe, int liveWithHandiSp, int liveWithHandiEl, int liveWithHandiEr) {
        int dependentDeduction = 0;
        dependentDeduction = 380000 * generalDependent + 630000 * specificDependent + 480000 * elderlyDependent + 580000 * liveWithEldRel + 730000 * liveWithHandiGe + 980000 * liveWithHandiSp + 830000 * liveWithHandiEl + 930000 * liveWithHandiEr;
        return dependentDeduction;
    }

    public static int getHandicapDeduction(String selfWidowType, String selfHandicapType, String selfStudentType, int specificHandicap, int generalHandicap) {
        int handicapDeduction = 0;
        int countGeneral = 0;
        countGeneral += generalHandicap;
        if (selfWidowType != null && !selfWidowType.equals("") && selfWidowType.equals("1")) {
            ++countGeneral;
        }
        if (selfHandicapType != null && !selfHandicapType.equals("") && selfHandicapType.equals("1")) {
            ++countGeneral;
        }
        if (selfStudentType != null && !selfStudentType.equals("") && selfStudentType.equals("1")) {
            ++countGeneral;
        }
        handicapDeduction += 270000 * countGeneral;
        int countSpecific = 0;
        countSpecific += specificHandicap;
        if (selfHandicapType != null && !selfHandicapType.equals("") && selfHandicapType.equals("2")) {
            ++countSpecific;
        }
        handicapDeduction += 400000 * countSpecific;
        if (selfWidowType != null && !selfWidowType.equals("") && selfWidowType.equals("2")) {
            handicapDeduction += 350000;
        }
        return handicapDeduction;
    }

    public static boolean checkCalcTaxedIncome(int calcTaxedIncome) {
        return 16920000 >= calcTaxedIncome;
    }

    public static int getCalcIncomeTax(int calcTaxedIncome) {
        int deduction;
        float ratio;
        int idx = 0;
        int calcIncomeTax = 0;
        for (int i = 0; i < aryCalcIncomeTax.length; ++i) {
            if (calcTaxedIncome > aryCalcIncomeTax[i]) continue;
            idx = i;
            break;
        }
        if ((calcIncomeTax = (int)((float)calcTaxedIncome * (ratio = (float)aryCalcIncomeTaxRatio[idx][0] / 100.0f)) - (deduction = aryCalcIncomeTaxRatio[idx][1])) < 0) {
            calcIncomeTax = 0;
        }
        return calcIncomeTax;
    }

    public static int getDeductedIncomeTax(int adjustedIncomeTax) {
        int deductedIncomeTax = 0;
        deductedIncomeTax = (int)LegalUtility.round((float)adjustedIncomeTax * 0.0f, 0, 2);
        if (125000 < deductedIncomeTax) {
            deductedIncomeTax = 125000;
        }
        return deductedIncomeTax;
    }

    public static int getTaxationForCarCommute(int commutation, float distance) {
        int limit;
        int index = 0;
        for (index = 0; index < ARY_COMMUTE_LIMIT.length && !(distance < (float)ARY_COMMUTE_LIMIT[index][0]); ++index) {
        }
        if (index >= ARY_COMMUTE_LIMIT.length) {
            index = ARY_COMMUTE_LIMIT.length - 1;
        }
        if ((limit = ARY_COMMUTE_LIMIT[index][1]) < commutation) {
            return commutation - limit;
        }
        return 0;
    }

    public static int getTaxationForCommutation(int commutation) {
        if (COMMUTE_LIMIT < commutation) {
            return commutation - COMMUTE_LIMIT;
        }
        return 0;
    }

    private static double round(double value, int scale, int mode) {
        if (scale >= 0) {
            BigDecimal bd = new BigDecimal(value);
            return bd.setScale(scale, mode).doubleValue();
        }
        int minusScale = scale * -1;
        double dividing = 1.0;
        for (int i = 0; i < minusScale; ++i) {
            dividing *= 10.0;
        }
        BigDecimal bd = new BigDecimal(value / dividing);
        return bd.setScale(0, mode).doubleValue() * dividing;
    }
}

