/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.common.vo;

import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.dto.CmAspUserDto;
import jp.mosp.common.dto.CmUserDto;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PasswordVo
extends BaseVo {
    private static final long serialVersionUID = 5173131320694134432L;
    public static final int MODE_SHOW = 0;
    public static final int MODE_FORCE_UPDATE = 1;
    public static final String PRM_TXT_OLD_PASSWORD = "txtOldPassword";
    public static final String PRM_TXT_NEW_PASSWORD = "txtNewPassword";
    public static final String PRM_TXT_CONFIRM_PASS = "txtConfirmPass";
    public static final String PRM_HDN_OLD_PASSWORD = "hdnOldPassword";
    public static final String PRM_HDN_NEW_PASSWORD = "hdnNewPassword";
    public static final String PRM_HDN_CONFIRM_PASS = "hdnConfirmPass";
    public static final String PRM_HID_USER_ID = "hidUserId";
    public static final int LEN_PASSWORD = 32;
    public static final int LEN_MIN_PASSWORD = 4;
    private String cmdMenu;
    private String hdnOldPassword;
    private String hdnNewPassword;
    private String hdnConfirmPass;
    private int mode;
    public String NAM_PASSWORD;
    public String NAM_OLD_PASSWORD;
    public String NAM_NEW_PASSWORD;
    public String NAM_CONFIRM_PASS;

    public PasswordVo(Properties cfg, Properties msg, Properties nam, String cmd, CmAspUserDto aspUser, CmUserDto user) {
        super(cfg, msg, nam, cmd, aspUser, user);
        this.needDirectJs = true;
        this.setViewPath(this.getClassName());
        this.mode = 0;
    }

    @Override
    protected void setFieldsName() {
        super.setFieldsName();
        this.NAM_PASSWORD = this.getName("C_PASSWORD");
        this.NAM_OLD_PASSWORD = this.getName("C_OLD") + this.getName("C_PASSWORD");
        this.NAM_NEW_PASSWORD = this.getName("C_NEW") + this.getName("C_PASSWORD");
        this.NAM_CONFIRM_PASS = this.getName("C_PASSWORD") + this.getName("C_CONFIRM");
    }

    @Override
    protected void setSubTitle() {
        super.setSubTitle();
        this.subTitle = this.getName("C_PASSWORD") + this.getName("C_CHANGE");
        this.aryMenu = new String[1][2];
        this.aryMenu[0][0] = "C1010";
        this.aryMenu[0][1] = this.getName("C_MENU") + this.getName("C_TO");
    }

    public void setParams(HttpServletRequest request) {
        this.hdnOldPassword = request.getParameter(PRM_HDN_OLD_PASSWORD);
        this.hdnNewPassword = request.getParameter(PRM_HDN_NEW_PASSWORD);
        this.hdnConfirmPass = request.getParameter(PRM_HDN_CONFIRM_PASS);
    }

    public void validate(String currentPassword) throws NoSuchAlgorithmException, MospException {
        this.startValidation();
        this.checkRequired(this.hdnOldPassword, this.NAM_OLD_PASSWORD, PRM_TXT_OLD_PASSWORD);
        this.checkRequired(this.hdnNewPassword, this.NAM_NEW_PASSWORD, PRM_TXT_NEW_PASSWORD);
        this.checkRequired(this.hdnConfirmPass, this.NAM_CONFIRM_PASS, PRM_TXT_CONFIRM_PASS);
        this.checkLength(this.hdnOldPassword, 32, this.NAM_OLD_PASSWORD, PRM_TXT_OLD_PASSWORD);
        this.checkLength(this.hdnNewPassword, 32, this.NAM_NEW_PASSWORD, PRM_TXT_NEW_PASSWORD);
        this.checkLength(this.hdnConfirmPass, 32, this.NAM_CONFIRM_PASS, PRM_TXT_CONFIRM_PASS);
        this.checkPassword(MospUtility.getDigest(this.hdnOldPassword), currentPassword, PRM_TXT_OLD_PASSWORD);
        this.checkCompare(this.hdnNewPassword, this.hdnConfirmPass, 0, this.NAM_PASSWORD, PRM_TXT_NEW_PASSWORD, PRM_TXT_CONFIRM_PASS);
        this.endValidation();
    }

    @Override
    public String getDirectJs(Class<?> cls, Object obj) throws IllegalAccessException {
        StringBuffer sb = new StringBuffer();
        sb.append(super.getDirectJs(cls, obj));
        sb.append("var MODE = ");
        sb.append(this.mode);
        sb.append(";");
        return sb.toString();
    }

    public String getHdnOldPassword() {
        return this.hdnOldPassword;
    }

    public String getHdnNewPassword() {
        return this.hdnNewPassword;
    }

    public String getHdnConfirmPass() {
        return this.hdnConfirmPass;
    }

    public void setHdnOldPassword(String hdnOldPassword) {
        this.hdnOldPassword = hdnOldPassword;
    }

    public void setHdnNewPassword(String hdnNewPassword) {
        this.hdnNewPassword = hdnNewPassword;
    }

    public void setHdnConfirmPass(String hdnConfirmPass) {
        this.hdnConfirmPass = hdnConfirmPass;
    }

    public String getCmdMenu() {
        return this.cmdMenu;
    }

    public void setCmdMenu(String cmdMenu) {
        this.cmdMenu = cmdMenu;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public int getMode() {
        return this.mode;
    }
}

