/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.common.common;

import java.io.IOException;
import java.util.Properties;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import jp.mosp.common.common.LogFormatClass;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.dto.CmAspUserDto;
import jp.mosp.common.dto.CmUserDto;

public final class LogUtility {
    private static Logger getLogger(Properties cfg) throws IOException {
        Logger logger = Logger.getLogger(cfg.getProperty("log.name"));
        if (logger.getHandlers().length == 0) {
            FileHandler fh = new FileHandler(cfg.getProperty("app.docbase") + cfg.getProperty("log.pattern"), Integer.parseInt(cfg.getProperty("log.size")), Integer.parseInt(cfg.getProperty("log.count")), true);
            fh.setFormatter(new LogFormatClass(cfg.getProperty("log.separator")));
            logger.addHandler(fh);
            LogUtility.setLevel(cfg);
        }
        return logger;
    }

    public static void outputErrorLog(Throwable ex, HttpServletRequest request) {
        try {
            String msg = MospUtility.getStackTrace(ex);
            LogUtility.log(request, 6, "\u5b9f\u884c\u6642\u30a8\u30e9\u30fc", msg);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void log(HttpServletRequest request, int level, String logType, String message) {
        try {
            Properties cfg = (Properties)request.getAttribute("cfg");
            CmAspUserDto aspUser = (CmAspUserDto)request.getAttribute("aspUser");
            CmUserDto user = (CmUserDto)request.getAttribute("user");
            String strAspUser = aspUser != null ? aspUser.getAspUserId() : "";
            String strUser = user != null ? user.getUserId() : "";
            String strCmd = (String)request.getAttribute("cmd");
            LogUtility.log(cfg, strAspUser, strUser, strCmd, level, logType, message);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void log(Properties cfg, String strAspUser, String strUser, String strCmd, int level, String logType, String message) {
        try {
            Logger logger = LogUtility.getLogger(cfg);
            StringBuffer msg = new StringBuffer();
            msg.append(logType);
            msg.append(cfg.getProperty("log.separator"));
            msg.append(strAspUser);
            msg.append(cfg.getProperty("log.separator"));
            msg.append(strUser);
            msg.append(cfg.getProperty("log.separator"));
            msg.append(strCmd);
            msg.append(cfg.getProperty("log.separator"));
            msg.append(message);
            Level lvl = null;
            switch (level) {
                case 0: {
                    lvl = Level.FINEST;
                    break;
                }
                case 1: {
                    lvl = Level.FINER;
                    break;
                }
                case 2: {
                    lvl = Level.FINE;
                    break;
                }
                case 3: {
                    lvl = Level.CONFIG;
                    break;
                }
                case 4: {
                    lvl = Level.INFO;
                    break;
                }
                case 5: {
                    lvl = Level.WARNING;
                    break;
                }
                case 6: {
                    lvl = Level.SEVERE;
                    break;
                }
                default: {
                    lvl = Level.SEVERE;
                }
            }
            logger.log(lvl, msg.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setLevel(Properties cfg) {
        Logger logger = Logger.getLogger(cfg.getProperty("log.name"));
        String lvl = cfg.getProperty("log.level");
        if (lvl.equals("ALL")) {
            logger.setLevel(Level.ALL);
        } else if (lvl.equals("FINER")) {
            logger.setLevel(Level.FINER);
        } else if (lvl.equals("FINE")) {
            logger.setLevel(Level.FINE);
        } else if (lvl.equals("CONFIG")) {
            logger.setLevel(Level.CONFIG);
        } else if (lvl.equals("INFO")) {
            logger.setLevel(Level.INFO);
        } else if (lvl.equals("WARNING")) {
            logger.setLevel(Level.WARNING);
        } else if (lvl.equals("SEVERE")) {
            logger.setLevel(Level.SEVERE);
        } else {
            logger.setLevel(Level.ALL);
        }
    }
}

