/* 

Copyright 2003-2006 MicroNova (R)
All rights reserved.

Redistribution and use in source and binary forms, with or
without modification, are permitted provided that the following
conditions are met:

    * Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.

    * Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

    * Neither the name of MicroNova nor the names of its contributors
    may be used to endorse or promote products derived from this
    software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

*/


package com.micronova.jsp.tag;

import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;
import org.apache.taglibs.standard.lang.support.ExpressionEvaluatorManager;
import com.micronova.util.*;

/**

JSP-version-dependent root class for YUZU tags

*/

public class YuzuRoot extends BodyTagSupport
{
    /** default string buffer */

    protected StringBuffer _buffer;

    /** obtain deault StringBuffer. */

    protected StringBuffer getBuffer()
    {
        StringBuffer buffer = _buffer;

        if (buffer == null)
        {
            buffer = new StringBuffer();
            _buffer = buffer;
        }
        
        buffer.setLength(0);

        return buffer;
    }

    /** evaluates EL expression */

    protected Object evaluateExpression(String name, String expression, Class valueClass) throws Exception
    {
        return EL.evaluateExpression(pageContext, name, expression, valueClass);
    }

    /** evaluates attribute, applying EL.replaceEvalEscape() for EL attributes */

    protected Object evaluateAttributeExpression(String name, Object expression, Class valueClass) throws Exception
    {
        if (valueClass == EL.class)
        {
            Object object = evaluateExpression(name, (String)expression, String.class);
            StringBuffer buffer = getBuffer();
            
            buffer.append(object.toString());
            
            return EL.replaceEvalEscape(buffer).toString();
        }
        else
        {
            return evaluateExpression(name, (String)expression, valueClass);
        }
    }
}
