/* 

Copyright 2003-2006 MicroNova (R)
All rights reserved.

Redistribution and use in source and binary forms, with or
without modification, are permitted provided that the following
conditions are met:

    * Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.

    * Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

    * Neither the name of MicroNova nor the names of its contributors
    may be used to endorse or promote products derived from this
    software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

*/


package com.micronova.util.servlet;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import java.io.*;
import java.util.*;

import com.micronova.util.*;

/** Servlet dispatching with object passing */

public class HttpDispatch
{
    /** dispatch include with object passing */

    public static String include(RequestDispatcher dispatcher, String path, HttpServletRequest request, HttpServletResponse response, Object requestObject) throws Exception
    {
        BufferedHttpServletResponse bufferedResponse = new BufferedHttpServletResponse(response);

        DispatchHttpServletRequest mappedRequest = new DispatchHttpServletRequest(request, path, request, requestObject);

        dispatcher.include(mappedRequest, bufferedResponse);

        return bufferedResponse.getString();
    }

    /** dispatch include using PageContext */

    public static String include(PageContext pageContext, String path, String contextPath, Object requestObject) throws Exception
    {
        ServletRequest request = pageContext.getRequest();
        ServletResponse response = pageContext.getResponse();

        ServletContext context = pageContext.getServletContext();

        if (contextPath != null)
        {
            context = context.getContext(contextPath);
        }

        RequestDispatcher dispatcher = context.getRequestDispatcher(path);

        return include(dispatcher, path, (HttpServletRequest)request, (HttpServletResponse)response, requestObject);
    }

    /** dispatch include using PageContext */

    public static String include(PageContext pageContext, String path, Object requestObject) throws Exception
    {
        return include(pageContext, path, null, requestObject);
    }

    /** dispatch forward with object passing */

    public static void forward(RequestDispatcher dispatcher, String path, HttpServletRequest request, HttpServletResponse response, Object requestObject) throws Exception
    {
        DispatchHttpServletRequest mappedRequest = new DispatchHttpServletRequest(request, path, request, requestObject);

        dispatcher.forward(mappedRequest, response);
    }

    /** dispatch include using PageContext */

    public static void forward(PageContext pageContext, String path, String contextPath, Object requestObject) throws Exception
    {
        ServletRequest request = pageContext.getRequest();
        ServletResponse response = pageContext.getResponse();

        ServletContext context = pageContext.getServletContext();

        if (contextPath != null)
        {
            context = context.getContext(contextPath);
        }

        RequestDispatcher dispatcher = context.getRequestDispatcher(path);

        forward(dispatcher, path, (HttpServletRequest)request, (HttpServletResponse)response, requestObject);
        
    }

    /** dispatch forward using PageContext */

    public static void forward(PageContext pageContext, String path, Object requestObject) throws Exception
    {
        forward(pageContext, path, null, requestObject);
    }

}

