/* 

Copyright 2003-2004 MicroNova (R)
All rights reserved.

Redistribution and use in source and binary forms, with or
without modification, are permitted provided that the following
conditions are met:

    * Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.

    * Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

    * Neither the name of MicroNova nor the names of its contributors
    may be used to endorse or promote products derived from this
    software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

*/


package com.micronova.util.codec;

import java.util.*;
import com.micronova.util.*;
import org.w3c.dom.*;
import javax.xml.parsers.*;
import org.xml.sax.*;
import java.io.*;
import java.net.*;
import javax.xml.transform.*;
import javax.xml.transform.dom.*;
import javax.xml.transform.sax.*;
import javax.xml.transform.stream.*;

/** XMLMap codecs */

public class CodecXMLMap extends Codec
{
    /** builds a XML out of NestedMap using root name and control map */

    public static final Object encode(Object object, Object control) throws Exception
    {
        if (object != null)
        {
            object = XMLMap.encode(object, new NestedMap(control));
        }

        return object;
    }

    /** builds a XML out of NestedMap using root name */

    public static final Object encode(Object object) throws Exception
    {
        if (object != null)
        {
            object = XMLMap.encode(object, null);
        }

        return object;
    }

    /** decodes XML into NestedMap */

    public static final Object decode(Object object) throws Exception
    {
        return decode(object, null);
    }

    /** decodes XML into NestedMap, according to the given control */

    public static final Object decode(Object object, Object control) throws Exception
    {
        if (object != null)
        {
            NestedMap controlMap = TypeUtil.isNestedMap(control);

            if (!(object instanceof Node))
            {
                object = XMLUtil.parse(object, controlMap);
            }

            object = XMLMap.decode((Node)object, controlMap);
        }

        return object;
    }
}

