/* 

Copyright 2003-2006 MicroNova (R)
All rights reserved.

Redistribution and use in source and binary forms, with or
without modification, are permitted provided that the following
conditions are met:

    * Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.

    * Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

    * Neither the name of MicroNova nor the names of its contributors
    may be used to endorse or promote products derived from this
    software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

*/


package com.micronova.util.codec;

import java.util.*;
import com.micronova.util.*;

/** Thread codecs */

public class CodecThread extends Codec
{
    /** sleeps for given number of milliseconds */

    public static Object sleep(Object object) throws Exception
    {
        Long l = TypeUtil.isLong(object);
        
        if (l != null)
        {
            Thread.currentThread().sleep(l.longValue());
        }

        return l;
    }

    /** obtain current thread */

    public static Object currentThread()
    {
        return Thread.currentThread();
    }

    /** join a thread */

    public static Object join(Object object, Object wait) throws Exception
    {
        if (object instanceof Thread)
        {
            ((Thread)object).join(TypeUtil.isLong(wait).longValue());
        }

        return object;
    }

    /** interrupt a thread */

    public static Object interrupt(Object object)
    {
        if (object instanceof Thread)
        {
            ((Thread)object).interrupt();
        }

        return object;
    }

    /** yield current thread */

    public static Object yield()
    {
        Thread.yield();

        return Thread.currentThread();
    }

    /** returns max priority as Integer */

    public static Object maxPriority()
    {
        return new Integer(Thread.MAX_PRIORITY);
    }

    /** returns min priority as Integer */

    public static Object minPriority()
    {
        return new Integer(Thread.MIN_PRIORITY);
    }

    /** returns normal priority as Integer */

    public static Object normPriority()
    {
        return new Integer(Thread.NORM_PRIORITY);
    }

    /** stops a thread (deprecated) */

    public static Object stop(Object object)
    {
        if (object instanceof Thread)
        {
            ((Thread)object).stop();
        }

        return object;
    }

    /** suspends a thread (deprecated) */

    public static Object suspend(Object object)
    {
        if (object instanceof Thread)
        {
            ((Thread)object).suspend();
        }

        return object;
    }

    /** resumes a thread (deprecated) */

    public static Object resume(Object object)
    {
        if (object instanceof Thread)
        {
            ((Thread)object).resume();
        }

        return object;
    }
}
