/* 

Copyright 2003-2006 MicroNova (R)
All rights reserved.

Redistribution and use in source and binary forms, with or
without modification, are permitted provided that the following
conditions are met:

    * Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.

    * Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

    * Neither the name of MicroNova nor the names of its contributors
    may be used to endorse or promote products derived from this
    software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

*/


package com.micronova.util.codec;

import java.util.*;
import java.util.regex.*;
import com.micronova.util.*;

/** String codecs */

public class CodecString extends Codec
{
    /** compiles pattern if patternSpec is a String */

    protected static Pattern getPattern(Object patternSpec)
    {
        Pattern pattern = null;

        if (patternSpec instanceof Pattern)
        {
            pattern = (Pattern)patternSpec;
        }
        else if (patternSpec != null)
        {
            pattern = Pattern.compile(patternSpec.toString());
        }

        return pattern;
    }

    /** replace all substrings matching pattern with replacement */

    public static final Object replaceAll(Object object, Object pattern, Object replacement)
    {
        if (object != null)
        {
            object = object.toString().replaceAll(pattern.toString(), replacement.toString());
        }

        return object;
    }

    /** replace first substring matching with pattern with replacement */

    public static final Object replaceFirst(Object object, Object pattern, Object replacement)
    {
        if (object != null)
        {
            object = object.toString().replaceFirst(pattern.toString(), replacement.toString());
        }

        return object;
    }

    /** return list of matching groups */

    public static final Object matchingGroups(Object object, Object patternSpec)
    {
        if (object != null)
        {
            object = StringUtil.matchingGroups(object.toString(), TypeUtil.isPattern(patternSpec));
        }

        return object;
    }

    /** 

    // splits string at pattern into List of strings 

    public static final Object split(Object object, Object pattern)
    {
        if (object != null)
        {
            object = TypeUtil.isList(object.toString().split(pattern.toString()));
        }

        return object;
    }

    // splits string at "," 

    public static final Object split(Object object)
    {
        return split(object, ",");
    }

    */

    /** trims string */

    public static final Object trim(Object object)
    {
        if (object != null)
        {
            object = object.toString().trim();
        }

        return object;
    }

    /** converts to upper case */

    public static final Object toUpperCase(Object object)
    {
        if (object != null)
        {
            object = object.toString().toUpperCase();
        }

        return object;
    }

    /** converts to lower case */

    public static final Object toLowerCase(Object object)
    {
        if (object != null)
        {
            object = object.toString().toLowerCase();
        }

        return object;
    }

    /** capitalize */

    public static final Object capitalize(Object object)
    {
        if (object != null)
        {
            object = StringUtil.capitalize(object.toString());
        }

        return object;
    }

    /** reverse */

    public static final Object reverse(Object object)
    {
        if (object != null)
        {
            object = StringUtil.reverse(object.toString());
        }

        return object;
    }

    /** multiply */

    public static final Object multiply(Object object, Object countSpec)
    {
        if (object != null)
        {
            Integer countInteger = TypeUtil.isInteger(countSpec);

            int count = (countInteger != null) ? countInteger.intValue() : 0;

            object = StringUtil.multiply(object.toString(), count);
        }

        return object;
    }

    /** append */

    public static final Object append(Object object, Object appended)
    {
        if (object != null)
        {
            if (appended != null)
            {
                object = object.toString() + appended.toString();
            }
        }
        else
        {
            object = appended;
        }

        return object;
    }

    /** prepend */

    public static final Object prepend(Object object, Object prepended)
    {
        if (object != null)
        {
            if (prepended != null)
            {
                object = prepended.toString() + object.toString();
            }
        }
        else
        {
            object = prepended;
        }

        return object;
    }

    /** returns substring from start to end */

    public static final Object substring(Object object, Object start, Object end)
    {
        if (object != null)
        {
            String string = object.toString();

            int length = string.length();

            int startIndex = TypeUtil.isInteger(start).intValue();
            int endIndex = TypeUtil.isInteger(end).intValue();

            object = StringUtil.substring(string, startIndex, endIndex);
        }

        return object;
    }

    /** returns substring starting at start */

    public static final Object substring(Object object, Object start)
    {
        if (object != null)
        {
            String string = object.toString();

            int startIndex = TypeUtil.isInteger(start).intValue();

            object = StringUtil.substring(string, startIndex);
        }

        return object;
    }

    /** finds index of given substring */

    public static final Object indexOf(Object object, Object sub)
    {
        if ((object != null) && (sub != null))
        {
            object = new Integer(object.toString().indexOf(sub.toString()));
        }

        return object;
    }

    /** finds last index of given substring */

    public static final Object lastIndexOf(Object object, Object sub)
    {
        if ((object != null) && (sub != null))
        {
            object = new Integer(object.toString().lastIndexOf(sub.toString()));
        }

        return object;
    }

    /** returns string length */

    public static final Object length(Object object)
    {
        if (object != null)
        {
            return new Integer(object.toString().length());
        }
        
        return object;
    }

    /** converts String into Character list */

    public static final Object toCharacterList(Object object)
    {
        if (object != null)
        {
            return TypeUtil.isList(object.toString().toCharArray());
        }

        return object;
    }

    /** converts List of Characters to String */

    public static final Object fromCharacterList(Object object)
    {
        if (object != null)
        {
            List list = (List)TypeUtil.isList(object);

            int length = list.size();
            
            char[] array = new char[length];

            for (int i = length; --i >= 0;)
            {
                array[i] = ((Character)(list.get(i))).charValue();
            }

            object = new String(array);
        }

        return object;
    }


    /** split by patterns */

    public static final Object split(Object object, Object patternSpec, Object groupSpec)
    {
        if (object != null)
        {
            Pattern pattern = getPattern(patternSpec);

            int groupIndex = 0;

            Integer groupIndexInteger = TypeUtil.isInteger(groupSpec);

            if (groupIndexInteger != null)
            {
                groupIndex = groupIndexInteger.intValue();
            }

            object = StringUtil.split(object.toString(), pattern, groupIndex);
        }

        return object;
    }

    /** split by pattern */

    public static final Object split(Object object, Object patternSpec)
    {
        return split(object, patternSpec, null);
    }

    /** split by pattern */

    public static final Object split(Object object)
    {
        return split(object, ",");
    }

    /** list matching patterns */

    public static final Object matchAll(Object object, Object patternSpec, Object groupSpec)
    {
        if (object != null)
        {
            Pattern pattern = getPattern(patternSpec);

            int groupIndex = 0;

            Integer groupIndexInteger = TypeUtil.isInteger(groupSpec);

            if (groupIndexInteger != null)
            {
                groupIndex = groupIndexInteger.intValue();
            }

            object = StringUtil.matchAll(object.toString(), pattern, groupIndex);
        }

        return object;
    }

    /** list matching patterns */

    public static final Object matchAll(Object object, Object patternSpec)
    {
        return matchAll(object, patternSpec, null);
    }

    /** decompose by pattern */

    public static final Object decompose(Object object, Object patternSpec, Object groupSpec)
    {
        if (object != null)
        {
            Pattern pattern = getPattern(patternSpec);

            int groupIndex = 0;

            Integer groupIndexInteger = TypeUtil.isInteger(groupSpec);

            if (groupIndexInteger != null)
            {
                groupIndex = groupIndexInteger.intValue();
            }

            object = StringUtil.decompose(object.toString(), pattern, groupIndex);
        }

        return object;
    }

    /** decompose by pattern */

    public static final Object decompose(Object object, Object patternSpec)
    {
        return decompose(object, patternSpec, null);
    }


    /** returns the matching group, or null */

    public static final Object match(Object object, Object patternSpec, Object groupSpec)
    {
        if (object != null)
        {
            Pattern pattern = getPattern(patternSpec);

            int groupIndex = 0;

            Integer groupIndexInteger = TypeUtil.isInteger(groupSpec);

            if (groupIndexInteger != null)
            {
                groupIndex = groupIndexInteger.intValue();
            }

            object = StringUtil.match(object.toString(), pattern, groupIndex);
        }

        return object;
    }

    /** match the first one or null */

    public static final Object match(Object object, Object patternSpec)
    {
        return match(object, patternSpec, null);
    }

    /** joins elements of sequence object using glue */

    public static final Object join(Object object, Object glue)
    {
        if (object != null)
        {
            List list = TypeUtil.isList(object);

            if ((list != null) && (glue != null))
            {
                object = StringUtil.join(list, glue.toString());
            }
            else
            {
                object = null;
            }
        }
        
        return object;
    }
    
    /** join elements of sequence object using "," */

    public static final Object join(Object object)
    {
        return join(object, ",");
    }

    /** converts to byte array with specific encoding */

    public static final Object toByteArray(Object object, Object encoding) throws Exception
    {
        if (object != null)
        {
            String string = object.toString();

            if (encoding != null)
            {
                object = string.getBytes(encoding.toString());
            }
            else
            {
                object = string.getBytes();
            }
        }

        return object;
    }

    /** converts from byte array with specific encoding */

    public static final Object fromByteArray(Object object, Object encoding) throws Exception
    {
        if (object != null)
        {
            byte[] byteArray = (byte[])object;
            
            if (encoding != null)
            {
                object = new String(byteArray, encoding.toString());
            }
            else
            {
                object = new String(byteArray);
            }
        }
        
        return object;
    }

    /** word counts */

    public static final Object countWords(Object object, Object pattern)
    {
        if (object != null)
        {
            object = StringUtil.countWords(object.toString(), getPattern(pattern.toString()));
        }

        return object;
    }

    /** word counts using default splitting pattern ([ ]+) */
    
    public static final Object countWords(Object object)
    {
        return countWords(object, "[ ]+");
    }

    /** replaces characts */

    public static final Object replaceCharacters(Object object, Object from, Object to)
    {
        if (object != null)
        {
            object = StringUtil.replaceCharacters(object.toString(), from.toString().toCharArray(), to.toString().toCharArray());
        }

        return object;
    }
}

