/* 

Copyright 2003-2006 MicroNova (R)
All rights reserved.

Redistribution and use in source and binary forms, with or
without modification, are permitted provided that the following
conditions are met:

    * Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.

    * Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

    * Neither the name of MicroNova nor the names of its contributors
    may be used to endorse or promote products derived from this
    software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

*/


package com.micronova.util.codec;

import java.text.*;
import java.security.*;
import javax.crypto.*;
import javax.crypto.spec.*;

import com.micronova.util.*;

/** Security-related codecs */

public class CodecSecurity extends Codec
{
    /** create message digest as binary string */

    public static final Object digest(Object object, Object algorithm) throws Exception
    {
        if (object != null)
        {
            MessageDigest messageDigest = MessageDigest.getInstance(algorithm.toString());

            byte[] input;

            if (object instanceof byte[])
            {
                input = (byte[])object;
            }
            else
            {
                input = StringUtil.fromBinaryString(object.toString());
            }

            return StringUtil.toBinaryString(messageDigest.digest(input));
        }

        return object;
    }

    /** create and return a secure random of given size */

    public static final Object secureRandom(Object object, Object algorithm) throws Exception
    {
        if (object != null)
        {
            SecureRandom secureRandom = SecureRandom.getInstance(algorithm.toString());
            String objectString = object.toString();

            int size = 0;

            try
            {
                size = Integer.parseInt(objectString);
            }
            catch (Exception e)
            {
            }
            
            if (size <= 0)
            {
                size = StringUtil.fromBinaryString(objectString).length;
            }

            byte[] b = new byte[size];

            secureRandom.nextBytes(b);

            object = StringUtil.toBinaryString(b);
        }

        return object;
    }

    /** generate a secret key as binary string for given algorithm */

    public static Object generateSecretKey(Object object) throws Exception
    {
        if (object != null)
        {
            String algorithm = object.toString();

            KeyGenerator keyGenerator = KeyGenerator.getInstance(algorithm);

            SecretKey secretKey = keyGenerator.generateKey();

            object = StringUtil.toBinaryString(secretKey.getEncoded());
        }

        return object;
    }

    private static Object crypt(Object object, Object keySpec, Object algorithmSpec, int mode) throws Exception
    {
        if (object != null)
        {
            String algorithm = algorithmSpec.toString();

            byte[] source = StringUtil.fromBinaryString(object.toString());

            Cipher cipher = Cipher.getInstance(algorithm);

            byte[] keyBytes = StringUtil.fromBinaryString(keySpec.toString());

            SecretKey secretKey = new SecretKeySpec(keyBytes, algorithm);

            cipher.init(mode, secretKey);

            object = StringUtil.toBinaryString(cipher.doFinal(source));
        }

        return object;
    }

    public static Object encrypt(Object object, Object keySpec, Object algorithmSpec) throws Exception
    {
        return crypt(object, keySpec, algorithmSpec, Cipher.ENCRYPT_MODE);
    }

    public static Object decrypt(Object object, Object keySpec, Object algorithmSpec) throws Exception
    {
        return crypt(object, keySpec, algorithmSpec, Cipher.DECRYPT_MODE);
    }
}

