/* 

Copyright 2003-2006 MicroNova (R)
All rights reserved.

Redistribution and use in source and binary forms, with or
without modification, are permitted provided that the following
conditions are met:

    * Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.

    * Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

    * Neither the name of MicroNova nor the names of its contributors
    may be used to endorse or promote products derived from this
    software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

*/


package com.micronova.util.codec;

import com.micronova.util.*;

/** numeric conversions */

public class CodecNumber extends Codec
{
    public static Object toBinaryString(Object object, Object filler)
    {
        if (object != null)
        {
            Long longNumber = TypeUtil.isLong(object);

            if (longNumber != null)
            {
                object = NumberUtil.toBinaryString(longNumber.longValue(), (String)filler);
            }
            else
            {
                object = null;
            }
        }

        return object;
    }

    public static Object toBinaryString(Object object)
    {
        return toBinaryString(object, null);
    }

    public static Object toHexString(Object object, Object filler)
    {
        if (object != null)
        {
            Long longNumber = TypeUtil.isLong(object);

            if (longNumber != null)
            {
                object = NumberUtil.toHexString(longNumber.longValue(), (String)filler);
            }
            else
            {
                object = null;
            }
        }

        return object;
    }

    public static Object toHexString(Object object)
    {
        return toHexString(object, null);
    }

    public static Object toOctalString(Object object, Object filler)
    {
        if (object != null)
        {
            Long longNumber = TypeUtil.isLong(object);

            if (longNumber != null)
            {
                object = NumberUtil.toOctalString(longNumber.longValue(), (String)filler);
            }
            else
            {
                object = null;
            }
        }

        return object;
    }

    public static Object toOctalString(Object object)
    {
        return toOctalString(object, null);
    }

    public static Object fromBinaryString(Object object)
    {
        if (object != null)
        {
            object = new Long(NumberUtil.fromBinaryString(object.toString()));
        }

        return object;
    }

    public static Object fromHexString(Object object)
    {
        if (object != null)
        {
            object = new Long(NumberUtil.fromHexString(object.toString()));
        }

        return object;
    }

    public static Object fromOctalString(Object object)
    {
        if (object != null)
        {
            object = new Long(NumberUtil.fromOctalString(object.toString()));
        }

        return object;
    }

    private static Object asDouble(double d)
    {
        return new Double(d);
    }

    private static Object asLong(double d)
    {
        return new Long((long)d);
    }

    public static Object e()
    {
        return asDouble(Math.E);
    }

    public static Object pi()
    {
        return asDouble(Math.PI);
    }

    public static Object abs(Object object)
    {
        Double d = TypeUtil.isDouble(object);
        
        if (d != null)
        {
            return asDouble(Math.abs(d.doubleValue()));
        }
        
        return null;
    }


    public static Object max(Object object1, Object object2 )
    {
        Double d1 = TypeUtil.isDouble(object1);
        Double d2 = TypeUtil.isDouble(object2);
        
        if ((d1 != null) && (d2 != null))
        {
            return asDouble(Math.max(d1.doubleValue(), d2.doubleValue()));
        }
        
        return null;
    }

    public static Object min(Object object1, Object object2 )
    {
        Double d1 = TypeUtil.isDouble(object1);
        Double d2 = TypeUtil.isDouble(object2);
        
        if ((d1 != null) && (d2 != null))
        {
            return asDouble(Math.min(d1.doubleValue(), d2.doubleValue()));
        }
        
        return null;
    }

    public static Object ceil(Object object)
    {
        Double d = TypeUtil.isDouble(object);

        if (d != null)
        {
            return asLong(Math.ceil(d.doubleValue()));
        }
        
        return null;
    }

    public static Object floor(Object object)
    {
        Double d = TypeUtil.isDouble(object);

        if (d != null)
        {
            return asLong(Math.floor(d.doubleValue()));
        }
        
        return null;
    }

    public static Object round(Object object)
    {
        Double d = TypeUtil.isDouble(object);

        if (d != null)
        {
            return asLong(Math.round(d.doubleValue()));
        }
        
        return null;
    }

    public static Object exp(Object object)
    {
        Double d = TypeUtil.isDouble(object);

        if (d != null)
        {
            return asDouble(Math.exp(d.doubleValue()));
        }
        
        return null;
    }

    public static Object log(Object object)
    {
        Double d = TypeUtil.isDouble(object);

        if (d != null)
        {
            return asDouble(Math.log(d.doubleValue()));
        }
        
        return null;
    }

    public static Object sqrt(Object object)
    {
        Double d = TypeUtil.isDouble(object);

        if (d != null)
        {
            return asDouble(Math.sqrt(d.doubleValue()));
        }
        
        return null;
    }

    public static Object pow(Object object1, Object object2 )
    {
        Double d1 = TypeUtil.isDouble(object1);
        Double d2 = TypeUtil.isDouble(object2);
        
        if ((d1 != null) && (d2 != null))
        {
            return asDouble(Math.pow(d1.doubleValue(), d2.doubleValue()));
        }
        
        return null;
    }

    public static Object sin(Object object)
    {
        Double d = TypeUtil.isDouble(object);

        if (d != null)
        {
            return asDouble(Math.sin(d.doubleValue()));
        }
        
        return null;
    }

    public static Object cos(Object object)
    {
        Double d = TypeUtil.isDouble(object);

        if (d != null)
        {
            return asDouble(Math.cos(d.doubleValue()));
        }
        
        return null;
    }

    public static Object tan(Object object)
    {
        Double d = TypeUtil.isDouble(object);

        if (d != null)
        {
            return asDouble(Math.tan(d.doubleValue()));
        }
        
        return null;
    }


    public static Object asin(Object object)
    {
        Double d = TypeUtil.isDouble(object);

        if (d != null)
        {
            return asDouble(Math.asin(d.doubleValue()));
        }
        
        return null;
    }

    public static Object acos(Object object)
    {
        Double d = TypeUtil.isDouble(object);
        
        if (d != null)
        {
            return asDouble(Math.acos(d.doubleValue()));
        }
        
        return null;
    }

    public static Object atan(Object object)
    {
        Double d = TypeUtil.isDouble(object);

        if (d != null)
        {
            return asDouble(Math.atan(d.doubleValue()));
        }

        return null;
    }

    public static Object toDegrees(Object object)
    {
        Double d = TypeUtil.isDouble(object);

        if (d != null)
        {
            return asDouble(Math.toDegrees(d.doubleValue()));
        }
        
        return null;
    }

    public static Object toRadians(Object object)
    {
        Double d = TypeUtil.isDouble(object);

        if (d != null)
        {
            return asDouble(Math.toRadians(d.doubleValue()));
        }
        
        return null;
    }
}

