/* 

Copyright 2003-2006 MicroNova (R)
All rights reserved.

Redistribution and use in source and binary forms, with or
without modification, are permitted provided that the following
conditions are met:

    * Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.

    * Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

    * Neither the name of MicroNova nor the names of its contributors
    may be used to endorse or promote products derived from this
    software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

*/


package com.micronova.util.codec;

import java.util.*;
import java.util.regex.*;
import javax.servlet.*;
import javax.servlet.jsp.*;
import javax.servlet.http.*;
import com.micronova.util.*;
import com.micronova.jsp.tag.*;

/** JSP codecs */

public class CodecJSP extends Codec
{
    public final static String PATTERN = "pattern";
    public final static String RECURSIVE = "recursive";
    public final static String ALLOWGROUP = "allowGroup";
    public final static String ENVIRONMENT = "environment";
    public final static String EVALCODEC = "evalCodec";

    /** evaluates EL */

    public static Object eval(Object context, Object object, Object control) throws Exception
    {
        if (object != null)
        {
            Object valueVarSaved = null;
            boolean isValueVarChanged = false;

            PageContext pageContext = (PageContext)context;

            try
            {
                NestedMap controlMap = new NestedMap(control);

                Pattern pattern = EL.getPattern(controlMap.get(PATTERN));

                if (pattern == null)
                {
                    pattern = EL.defaultPatternEval;
                }

                Boolean bRecursive = TypeUtil.isBoolean(controlMap.get(RECURSIVE));
                Boolean bAllowGroup = TypeUtil.isBoolean(controlMap.get(ALLOWGROUP));
                Object environment = controlMap.get(ENVIRONMENT);
                String evalCodec = controlMap.getString(EVALCODEC);
            
                if (bRecursive == null)
                {
                    bRecursive = Boolean.FALSE;
                }
                
                if (bAllowGroup == null)
                {
                    bAllowGroup = Boolean.FALSE;
                }

                EL el = new EL(pageContext, evalCodec);
                
                valueVarSaved = pageContext.getAttribute(YuzuTag.VALUEVAR);
                
                if (environment != null)
                {
                    EL.setPageAttribute(pageContext, YuzuTag.VALUEVAR, new NestedMap(environment));
                }

                isValueVarChanged = true;

                object = Template.render(object.toString(), pattern, 1, el, null, bRecursive.booleanValue(), bAllowGroup.booleanValue());
            }
            catch (Exception e)
            {
                throw e;
            }
            finally
            {
                if (isValueVarChanged)
                {
                    EL.setPageAttribute(pageContext, YuzuTag.VALUEVAR, valueVarSaved);
                }
            }
        }

        return object;
    }

    /** evaluate using default arguments */

    public static Object eval(Object context, Object object) throws Exception
    {
        return eval(context, object, null);
    }

    /** encodes URL */

    public static Object encodeURL(Object context, Object object) throws Exception
    {
        if (object != null)
        {
            object = ((HttpServletResponse)((PageContext)context).getResponse()).encodeURL(object.toString());
        }

        return object;
    }

    /** encodes redirect URL */

    public static Object encodeRedirectURL(Object context, Object object) throws Exception
    {
        if (object != null)
        {
            object = ((HttpServletResponse)((PageContext)context).getResponse()).encodeRedirectURL(object.toString());
        }

        return object;
    }

    /** returns real path */

    public static Object getRealPath(Object context, Object object)
    {
        if (object != null)
        {
            object = (((PageContext)context).getServletContext()).getRealPath(object.toString());
        }

        return object;
    }

    /** returns resource URL */

    public static Object getResource(Object context, Object object) throws Exception
    {
        if (object != null)
        {
            object = (((PageContext)context).getServletContext()).getResource(object.toString());
        }

        return object;
    }

    /** returns mimetype */

    public static Object getMimeType(Object context, Object object)
    {
        if (object != null)
        {
            object = (((PageContext)context).getServletContext()).getMimeType(object.toString());
        }

        return object;
    }

    /** creates a dynamic map */

    public static Object dynamicMap(Object context, Object object) throws Exception
    {
        return new ELMap((PageContext)context, object);
    }

    /** creates a dynamic iterator */

    public static Object dynamicIterator(Object context, Object object) throws Exception
    {
        return new ELIterator((PageContext)context, object);
    }

    /** applies given codec */

    public static Object applyCodec(Object context, Object object, Object codec) throws Exception
    {
        return EL.applyCodec((PageContext)context, EL.replaceEvalEscape(codec.toString()), object);
    }

    /** applies filter */

    public static Object applyFilter(Object context, Object object, Object filter) throws Exception
    {
        NestedMap filterMap = new NestedMap(filter);

        String include = EL.replaceEvalEscape(filterMap.getString(EL.INCLUDE, "true"));
        String breakExpression = EL.replaceEvalEscape(filterMap.getString(EL.BREAK));
        String apply = EL.replaceEvalEscape(filterMap.getString(EL.APPLY));
        String applyCodec = EL.replaceEvalEscape(filterMap.getString(EL.APPLYCODEC));
        
        return EL.applyFilter((PageContext)context, object, include, breakExpression, apply, applyCodec);
    }

    /** converts relative path (not string with a "/") to absolute, if necessary */

    public static Object getPath(Object context, Object object) throws Exception
    {
        String path = null;

        if (object != null)
        {
            PageContext pageContext = (PageContext)context;
            
            path = object.toString();

            if (!path.startsWith("/"))
            {
                path = ((HttpServletRequest)pageContext.getRequest()).getServletPath().replaceFirst("/[^/]*$", "") + "/" + path;
            }
        }
            
        return path;
    }

    public static final String RETURNPROPERTY = com.micronova.jsp.tag.CallTag.RETURNPROPERTY;
    public static final String VALUEPROPERTY = com.micronova.jsp.tag.CallTag.VALUEPROPERTY;
    public static final String BODYPROPERTY = com.micronova.jsp.tag.CallTag.BODYPROPERTY;

    /** calls a JSP */

    public static Object call(Object context, Object object, Object control) throws Exception
    {
        if (object != null)
        {
            PageContext pageContext = (PageContext)context;
            NestedMap controlMap = TypeUtil.isNestedMap(control);

            String path = (String)getPath(context, controlMap.get("path"));
            String contextPath = controlMap.getString("contextPath");
            String bodyParameter = controlMap.getString("bodyParameter", BODYPROPERTY);

            NestedMap map = TypeUtil.isNestedMap(controlMap.get("parameter"));

            if (object instanceof NestedMap)
            {
                map.copyFromSource(object);
            }
            else
            {
                String body = (String)TypeUtil.isString(object);

                if (!TypeUtil.isEmptyString(body))
                {
                    map.put(bodyParameter, body);
                }
            }

            Map returnMap = map.getSubMap(RETURNPROPERTY);

            returnMap.put(VALUEPROPERTY, null);

            object = com.micronova.util.servlet.HttpDispatch.include(pageContext, path, contextPath, map);

            Object returnValue = returnMap.get(VALUEPROPERTY);

            if (!TypeUtil.isEmptyString(returnValue))
            {
                object = returnValue;
            }
        }

        return object;
    }

    public static Object _log(PageContext pageContext, Object object, String destination) throws Exception
    {
        if (object != null)
        {
            if ("log".equals(destination))
            {
                ServletContext context = pageContext.getServletContext();

                context.log(object.toString());
            }
            else if ("out".equals(destination))
            {
                System.out.println(object.toString());
            }
            else if ("err".equals(destination))
            {
                System.err.println(object.toString());
            }
        }

        return object;
    }

    /** simple log facility */

    public static Object log(Object context, Object object, Object control) throws Exception
    {
        if (object != null)
        {
            PageContext pageContext = (PageContext)context;
            NestedMap controlMap = TypeUtil.isNestedMap(control);

            String destination = controlMap.getString("destination", "log");

            object = _log(pageContext, object, destination);
        }

        return object;
    }

    /** sorts a collection */

    public static Object sort(Object context, Object object, Object comparatorSpec) throws Exception
    {
        if (object != null)
        {
            List list = TypeUtil.isList(object);
            
            if (list != null)
            {
                if (comparatorSpec != null)
                {
                    ELComparator comparator = new ELComparator((PageContext)context, comparatorSpec);

                    Collections.sort(list, comparator);
                }
                else
                {
                    Collections.sort(list);
                }
            }
            
            object = list;
        }

        return object;
    }

    public static Object sort(Object context, Object object) throws Exception
    {
        return sort(context, object, null);
    }

    /** finds max in a collection using given comparator */

    public static Object max(Object context, Object object, Object comparatorSpec) throws Exception
    {
        if (object != null)
        {
            if (comparatorSpec != null)
            {
                ELComparator comparator = new ELComparator((PageContext)context, comparatorSpec);

                object = Collections.max((Collection)object, comparator);
            }
            else
            {
                object = Collections.max((Collection)object);
            }
        }

        return object;
    }

    public static Object max(Object context, Object object) throws Exception
    {
        return max(context, object, null);
    }

    /** finds min in a collection using given comparator */

    public static Object min(Object context, Object object, Object comparatorSpec) throws Exception
    {
        if (object != null)
        {
            if (comparatorSpec != null)
            {
                ELComparator comparator = new ELComparator((PageContext)context, comparatorSpec);

                object = Collections.min((Collection)object, comparator);
            }
            else
            {
                object = Collections.min((Collection)object);
            }
        }

        return object;
    }

    public static Object min(Object context, Object object) throws Exception
    {
        return min(context, object, null);
    }

    /** create message map */

    public static Object getMessageMap(Object context, Object object) throws Exception
    {
        MessageMap messageMap = new MessageMap((PageContext)context);

        if (object != null)
        {
            BeanUtil.fill(messageMap, TypeUtil.isNestedMap(object));
        }

        return messageMap;
    }

    public static Object getMessageMap(Object context) throws Exception
    {
        return getMessageMap(context, null);
    }

    /** create EL comparator */

    public static Object comparator(Object context, Object object) throws Exception
    {
        return new ELComparator((PageContext)context, TypeUtil.isNestedMap(object));
    }
}
