/* 

Copyright 2003-2006 MicroNova (R)
All rights reserved.

Redistribution and use in source and binary forms, with or
without modification, are permitted provided that the following
conditions are met:

    * Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.

    * Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

    * Neither the name of MicroNova nor the names of its contributors
    may be used to endorse or promote products derived from this
    software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

*/


package com.micronova.util;

import java.io.*;

/** Interactive process */

public class Shell
{
    Pipe _inPipe;
    Pipe _outPipe;
    Pipe _errPipe;
    Process _process;

    public Shell(Process process, InputStream in, OutputStream out, OutputStream err)
    {
        super();

        _process = process;

        _inPipe = new Pipe(in, process.getOutputStream());
        _outPipe = new Pipe(process.getInputStream(), out);
        _errPipe = new Pipe(process.getErrorStream(), err);
    }
    
    public int exec()
    {
        try
        {
            Thread inThread = new Thread(_inPipe);
            Thread outThread = new Thread(_outPipe);
            Thread errThread = new Thread(_errPipe);
            
            inThread.start();
            outThread.start();
            errThread.start();

            int rc = _process.waitFor();

            inThread.join();
            outThread.join();
            errThread.join();

            return rc;
        }
        catch (Exception e)
        {
            e.printStackTrace();
        }

        return -1;
    }
   
}
