/* 

Copyright 2003-2006 MicroNova (R)
All rights reserved.

Redistribution and use in source and binary forms, with or
without modification, are permitted provided that the following
conditions are met:

    * Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.

    * Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

    * Neither the name of MicroNova nor the names of its contributors
    may be used to endorse or promote products derived from this
    software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

*/


package com.micronova.util;

import java.util.*;
import java.util.regex.*;
import java.sql.*;
import com.micronova.util.*;

/** ObjectSource for SQL query template rendering */

public class SQLObjectSource implements ObjectSource
{
    protected Connection _connection;
    protected List _list;
    protected ObjectSource _objectSource;

    public SQLObjectSource(Connection connection, ObjectSource objectSource, List list)
    {
        _connection = connection;
        _list = list;
        _objectSource = objectSource;
    }

    public SQLObjectSource(Connection connection, ObjectSource objectSource)
    {
        this(connection, objectSource, new ArrayList());
    }

    public Object getObject(Object client, Object key)
    {
        try
        {
            Object replacement = _objectSource.getObject(this, key);
            
            if (replacement != null)
            {
                // expand into "?,?,?,..." if replacement is a List

                List list = TypeUtil.isList(replacement);
                
                if (list != null)
                {
                    StringBuffer buffer = new StringBuffer();
                    String separator = "";
                    
                    Iterator iterator = list.iterator();
                    
                    while (iterator.hasNext())
                    {
                        _list.add(iterator.next());

                        buffer.append(separator);
                        buffer.append("?");
                    
                        separator = ",";
                    }
                    
                    return buffer.toString();
                }
            }
            
            _list.add(replacement);
            return "?";
        }
        catch (Exception e)
        {
            throw new RuntimeException(e);
        }
    }

    public PreparedStatement apply(PreparedStatement preparedStatement) throws Exception
    {
        List list = _list;

        for (int i = 0; i < list.size(); i ++)
        {
            Object replacement = list.get(i);
            
            if (replacement != null)
            {
                if (replacement instanceof java.util.Date)
                {
                    replacement = new java.sql.Timestamp(((java.util.Date)replacement).getTime());
                }

                preparedStatement.setObject(i + 1, replacement);
            }
            else
            {
                preparedStatement.setNull(i + 1, Types.CHAR);
            }
        }
        
        return preparedStatement;
    }

    public PreparedStatement render(String query, Pattern pattern, boolean isRecursive, boolean doesAllowGroup) throws Exception
    {
        String renderedQuery = (String)Template.render(query, pattern, 1, this, this, isRecursive, doesAllowGroup);

        return apply(_connection.prepareStatement(renderedQuery));
    }

    public PreparedStatement render(String query, Pattern pattern) throws Exception
    {
        return render(query, pattern, false, false);
    }

    public static PreparedStatement prepareStatement(Connection connection, String query, Pattern pattern, ObjectSource objectSource) throws Exception
    {
        return prepareStatement(connection, query, pattern, objectSource, false, false);
    }

    public static PreparedStatement prepareStatement(Connection connection, String query, Pattern pattern, ObjectSource objectSource, boolean isRecursive, boolean doesAllowGroup) throws Exception
    {
        SQLObjectSource sqlObjectSource = new SQLObjectSource(connection, objectSource);

        return sqlObjectSource.render(query, pattern, isRecursive, doesAllowGroup);
    }
}


