/* 

Copyright 2003-2006 MicroNova (R)
All rights reserved.

Redistribution and use in source and binary forms, with or
without modification, are permitted provided that the following
conditions are met:

    * Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.

    * Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

    * Neither the name of MicroNova nor the names of its contributors
    may be used to endorse or promote products derived from this
    software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

*/


package com.micronova.util;

import java.util.*;
import java.io.*;

/** IO-related utilities */

public class IOUtil
{
    /** default buffer size used, if not given */

    public static final int DEFAULTBUFFERSIZE = 2048;

    /** tries to close an InputStream if not null */

    public static final void tryClose(InputStream x)
    {
        if (x != null)
        {
            try
            {
                x.close();
            }
            catch (Exception e)
            {
            }
        }
    }

    /** tries to close an OutputStream if not null */

    public static final void tryClose(OutputStream x)
    {
        if (x != null)
        {
            try
            {
                x.close();
            }
            catch (Exception e)
            {
            }
        }
    }

    /** tries to close a Reader if not null */

    public static final void tryClose(Reader x)
    {
        if (x != null)
        {
            try
            {
                x.close();
            }
            catch (Exception e)
            {
            }
        }
    }

    /** tries to close a Writer if not null */

    public static final void tryClose(Writer x)
    {
        if (x != null)
        {
            try
            {
                x.close();
            }
            catch (Exception e)
            {
            }
        }
    }
    
    /** copies bytes from in to out using given buffer until EOF.  Returns number of bytes copied.  Throws Exception on IO errors */

    public static final int copy(InputStream in, OutputStream out, byte[] buffer) throws Exception
    {
        int bytesCopied = 0;

        int readSize = buffer.length;

        for (;;)
        {
            int bytesRead = in.read(buffer, 0, readSize);

            if (bytesRead <= 0)
            {
                break;
            }
            
            out.write(buffer, 0, bytesRead);

            bytesCopied += bytesRead;
        }

        return bytesCopied;
    }

    /** Copies bytes from in to out using given buffer until EOF.  Returns number of bytes copied.  Throws Exception on IO errors */

    public static final int copy(Reader in, Writer out, char[] buffer) throws Exception
    {
        int charsCopied = 0;

        int readSize = buffer.length;

        for (;;)
        {
            int charsRead = in.read(buffer, 0, readSize);

            if (charsRead <= 0)
            {
                break;
            }
            
            out.write(buffer, 0, charsRead);

            charsCopied += charsRead;
        }

        return charsCopied;
    }

    public static final int copy(InputStream in, OutputStream out) throws Exception
    {
        return copy(in, out, new byte[DEFAULTBUFFERSIZE]);
    }

    public static final int copy(Reader in, Writer out) throws Exception
    {
        return copy(in, out, new char[DEFAULTBUFFERSIZE]);
    }

    /** read the whole content of an inputstream into byte[] */

    public static final byte[] readAll(InputStream in, byte[] buffer, int size) throws Exception
    {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream(size);

        copy(in, bOut, buffer);

        return bOut.toByteArray();
    }

    public static final byte[] readAll(InputStream in, int size) throws Exception
    {
        return readAll(in, new byte[DEFAULTBUFFERSIZE], size);
    }

    public static final byte[] readAll(InputStream in) throws Exception
    {
        return readAll(in, DEFAULTBUFFERSIZE);
    }

    /** read the whole content of a Reader into String */

    public static final char[] readAll(Reader in, char[] buffer, int size) throws Exception
    {
        CharArrayWriter out = new CharArrayWriter(size);

        copy(in, out, buffer);

        return out.toCharArray();
    }

    public static final char[] readAll(Reader in, int size) throws Exception
    {
        return readAll(in, new char[DEFAULTBUFFERSIZE], size);
    }

    public static final char[] readAll(Reader in) throws Exception
    {
        return readAll(in, DEFAULTBUFFERSIZE);
    }
}
