/* 

Copyright 2003-2006 MicroNova (R)
All rights reserved.

Redistribution and use in source and binary forms, with or
without modification, are permitted provided that the following
conditions are met:

    * Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.

    * Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

    * Neither the name of MicroNova nor the names of its contributors
    may be used to endorse or promote products derived from this
    software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

*/


package com.micronova.jsp.tag;

import java.util.*;

/** synchronizes tag processing */

public class SynchronizedTag extends YuzuTag
{
    protected static final Map __lock = new HashMap();

    protected boolean _isHoldingLock;
    protected long _waitTime;
    protected Object _lockId;

    protected void init()
    {
        super.init();

        _isHoldingLock = false;
        _waitTime = 0L;
        _lockId = null;
    }

    public void setWaitTime(Object expression) throws Exception
    {
        _waitTime = ((Long)evaluateAttribute("waitTime", expression, Long.class)).longValue();
    }

    public void setLockId(Object expression) throws Exception
    {
        _lockId = evaluateAttribute("lockId", expression, Object.class);
    }

    public void doPrepare() throws Exception
    {
        Object lockId = _lockId;

        Object lockObject = null;

        Thread currentThread = Thread.currentThread();

        synchronized(__lock)
        {
            lockObject = __lock.get(lockId);

            if (lockObject == null)
            {
                __lock.put(lockId, (lockId instanceof String) ? currentThread : lockId);
            }
        }

        if (currentThread != lockObject)
        {
            if (lockObject != null)
            {
                synchronized(lockObject)
                {
                    lockObject.wait(_waitTime);
                    
                    synchronized(__lock)
                    {
                        lockObject = __lock.get(lockId);
                        
                        if (lockObject != null)
                        {
                            throw new Exception("thread lock timeout");
                        }
                        else
                        {
                            __lock.put(lockId, (lockId instanceof String) ? currentThread: lockId);
                        }
                    }
                }
            }

            _isHoldingLock = true;
        }

        super.doPrepare();
    }

    public void cleanup()
    {
        super.cleanup();

        if (_isHoldingLock)
        {
            Object lockId = _lockId;

            try
            {
                synchronized(__lock)
                {
                    Object lockObject = __lock.remove(lockId);

                    if (lockObject != null)
                    {
                        synchronized(lockObject)
                        {
                            lockObject.notify();
                        }
                    }
                }
            }
            catch (Exception e)
            {
                e.printStackTrace();
            }
        }
    }
}
