/* 

Copyright 2003-2006 MicroNova (R)
All rights reserved.

Redistribution and use in source and binary forms, with or
without modification, are permitted provided that the following
conditions are met:

    * Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.

    * Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

    * Neither the name of MicroNova nor the names of its contributors
    may be used to endorse or promote products derived from this
    software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

*/


package com.micronova.jsp.tag;

import java.util.*;
import java.util.regex.*;
import java.sql.*;
import javax.servlet.jsp.*;
import org.apache.taglibs.standard.tag.common.sql.TransactionTagSupport;
import org.apache.taglibs.standard.tag.common.sql.ResultImpl;
import com.micronova.util.*;

/** template query.  Currently works only inside a sql:transaction */

public class QueryTag extends UpdateTag
{
    private static final String DEFAULTPATTERN = "[%]\\{([^\\}]*)\\}";
    
    private static final Pattern defaultPattern = Pattern.compile(DEFAULTPATTERN);

    protected int _startRow;
    protected int _maxRows;

    protected static Pattern getDefaultPattern(Object patternSpec)
    {
        if (DEFAULTPATTERN.equals(patternSpec))
        {
            return defaultPattern;
        }
        else
        {
            return QueryTag.getDefaultPattern(patternSpec);
        }
    }
    

    public void init()
    {
        super.init();

        _pattern = DEFAULTPATTERN;
        _startRow = 0;
        _maxRows = -1;
    }

    public void setStartRow(Object expression) throws Exception
    {
        _startRow = ((Integer)evaluateAttribute("startRow", expression, Integer.class)).intValue();
    }

    public void setMaxRows(Object expression) throws Exception
    {
        _maxRows = ((Integer)evaluateAttribute("maxRows", expression, Integer.class)).intValue();
    }

    protected Object doSql(PreparedStatement preparedStatement) throws Exception
    {
        return new ResultImpl(preparedStatement.executeQuery(), _startRow, _maxRows);
    }
}
