/* 

Copyright 2003-2006 MicroNova (R)
All rights reserved.

Redistribution and use in source and binary forms, with or
without modification, are permitted provided that the following
conditions are met:

    * Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.

    * Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

    * Neither the name of MicroNova nor the names of its contributors
    may be used to endorse or promote products derived from this
    software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

*/

package com.micronova.jsp.tag;

import com.micronova.util.*;
import java.util.*;
import javax.servlet.jsp.*;
import javax.servlet.jsp.jstl.fmt.LocaleSupport;

public class MessageMap extends MapBean
{
    protected PageContext _pageContext;
    protected String _baseName;
    protected String _defaultValue;

    public MessageMap(PageContext pageContext)
    {
        super();

        _pageContext = pageContext;
        _baseName = null;
        _defaultValue = "";
    }

    public void setBaseName(String baseName)
    {
        _baseName = baseName;
    }

    public void setDefaultValue(String defaultValue)
    {
        _defaultValue = defaultValue;
    }

    public Object evaluate(String expression, Class objectClass) throws Exception
    {
        return EL.evaluateExpression(_pageContext, "resourceMapExpression", expression.replaceAll("@\\{", "\\$\\{"), objectClass);
    }

    /** ObjectSource implementation */

    public Object getObject(Object client, Object key)
    {
        PageContext pageContext = _pageContext;
        String baseName = _baseName;

        Object object = null;

        try
        {
            String keyString = key.toString();

            List partList = StringUtil.split(keyString, ':');

            int partCount = partList.size();

            if (partCount < 2)
            {
                String name = (String)evaluate(keyString, String.class);

                if (baseName != null)
                {
                    object = LocaleSupport.getLocalizedMessage(pageContext, name, baseName);
                }
                else
                {
                    object = LocaleSupport.getLocalizedMessage(pageContext, name);
                }
            }
            else
            {
                String name = (String)EL.evaluateExpression(pageContext, "resourceMapExpression", partList.get(0).toString(), String.class);

                Object[] objectList = new Object[partCount - 1];

                for (int i = partCount; --i >= 1; )
                {
                    objectList[i - 1] = evaluate(partList.get(i).toString(), Object.class);
                }

                if (baseName != null)
                {
                    object = LocaleSupport.getLocalizedMessage(pageContext, name, objectList, baseName);
                }
                else
                {
                    object = LocaleSupport.getLocalizedMessage(pageContext, name, objectList);
                   
                }
            }

            String defaultValue = _defaultValue;

            if (!("*".equals(defaultValue)))
            {
                if (object.equals("???" + keyString + "???"))
                {
                    object = defaultValue;
                }
            }
        }
        catch (Exception e)
        {
            throw new RuntimeException(e);
        }

        return object;
    }

    public Object putObject(Object client, Object key, Object value)
    {
        if ("baseName".equals(key))
        {
            setBaseName(value.toString());
        }
        else if ("defaultValue".equals(key))
        {
            setDefaultValue(value.toString());
        }

        return null;
    }
}
