/* 

Copyright 2003-2006 MicroNova (R)
All rights reserved.

Redistribution and use in source and binary forms, with or
without modification, are permitted provided that the following
conditions are met:

    * Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.

    * Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

    * Neither the name of MicroNova nor the names of its contributors
    may be used to endorse or promote products derived from this
    software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

*/

package com.micronova.jsp.tag;

import com.micronova.util.*;
import java.util.*;
import javax.mail.*;
import javax.mail.internet.*;
import javax.activation.*;

public class MailTag extends MapTag
{
    protected String _url;
    protected Properties _properties;
    protected Transport _transport;
    protected Session _session;

    public void init()
    {
        super.init();

        _url = null;
        _transport = null;
        _export = null;
        _properties = null;
        _session = null;
    }

    public Transport getTransport()
    {
        return _transport;
    }

    public Session getSession()
    {
        return _session;
    }

    public MailTag getTransportSource()
    {
        MailTag transportSource = null;

        if (_transport != null)
        {
            return this;
        }

        String url = _url;

        if (url == null)
        {
            transportSource = (MailTag)getAncestorTag("com.micronova.jsp.tag.MailTag");

            if (transportSource != null)
            {
                return transportSource.getTransportSource();
            }
        }
        else
        {
            try
            {
                Properties properties = _properties;

                if (properties == null)
                {
                    properties = new Properties();
                }

                URLName urlName = new URLName(url);

                String protocol = urlName.getProtocol();
                String host = urlName.getHost();
                int port = urlName.getPort();

                if (protocol != null)
                {
                    properties.setProperty("mail.transport.protocol", protocol);

                    if (host != null)
                    {
                        properties.setProperty("mail." + protocol + ".host", host);
                        properties.setProperty("mail.host", host);
                    }

                    if (port >= 0)
                    {
                        properties.setProperty("mail." + protocol + ".port", "" + port);
                    }
                }

                Session session = Session.getInstance(properties);

                Transport transport = session.getTransport(urlName);

                transport.connect();

                _session = session;

                _transport = transport;
                
                transportSource = this;
            }
            catch (Exception e)
            {
                e.printStackTrace();
            }
        }

        return transportSource;
    }

    public void closeTransport()
    {
        Transport transport = _transport;

        if (transport != null)
        {
            _transport = null;

            try
            {
                transport.close();
            }
            catch (Exception e)
            {
                e.printStackTrace();
            }
        }
    }

    protected void cleanup()
    {
        closeTransport();

        super.cleanup();
    }

    public void setUrl(Object expression) throws Exception
    {
        _url = (String)evaluateAttribute("url", expression, String.class);

        closeTransport();
    }

    public void setProperties(Object expression) throws Exception
    {
        NestedMap propertyMap = (NestedMap)(new NestedMap(expression)).get("__param");

        Properties properties = new Properties();

        Iterator iterator = propertyMap.entrySet().iterator();

        while (iterator.hasNext())
        {
            Map.Entry entry = (Map.Entry)iterator.next();

            properties.put(entry.getKey().toString(), entry.getValue().toString());
        }

        _properties = properties;
    }

    public Object processValue(Object tagValue) throws Exception
    {
        if (tagValue != null)
        {
            NestedMap map = (NestedMap)tagValue;

            if (!map.isEmpty())
            {
                String from = map.getString("from");

                MailTag transportSource = getTransportSource();

                Transport transport = transportSource.getTransport();
                Session session = transportSource.getSession();

                MailTransport.send(session, transport, map);
            }
        }

        return tagValue;
    }
}
