/* 

Copyright 2003-2006 MicroNova (R)
All rights reserved.

Redistribution and use in source and binary forms, with or
without modification, are permitted provided that the following
conditions are met:

    * Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.

    * Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

    * Neither the name of MicroNova nor the names of its contributors
    may be used to endorse or promote products derived from this
    software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

*/


package com.micronova.jsp.tag;

import com.micronova.util.*;
import com.micronova.util.servlet.*;
import java.util.*;
import java.util.regex.*;
import javax.servlet.*;
import javax.servlet.jsp.*;
import javax.servlet.http.*;

import javax.mail.*;
import javax.mail.internet.*;

/** mail folder */

public class MailFolderTag extends ParamTag
{
    public static final String MESSAGES = "messages";
    public static final String OPERATION = "operation";
    public static final String CONTROL = "control";

    public static final String READ = "read";
    public static final String DELETE = "delete";

    protected String _url;
    protected Folder _folder;

    protected void init()
    {
        super.init();

        _url = null;
        _folder = null;
    }

    public Folder getFolder()
    {
        Folder folder = _folder;

        if (folder != null)
        {
            return folder;
        }

        String url = _url;

        if (url == null)
        {
            MailFolderTag folderSource = (MailFolderTag)getAncestorTag("com.micronova.jsp.tag.MailFolderTag");

            if (folderSource != null)
            {
                folder = folderSource.getFolder();
            }
        }
        else
        {
            try
            {
                Session session = Session.getInstance(new Properties());
                
                folder = session.getFolder(new URLName(url));
            
                _folder = folder;
            }
            catch (Exception e)
            {
            }
        }

        return folder;
    }

    public void closeFolder()
    {
        Folder folder = _folder;

        if (folder != null)
        {
            try
            {
                folder.close(true);
            }
            catch (Exception e)
            {
                e.printStackTrace();
            }

            _folder = null;
        }
    }

    protected void cleanup()
    {
        closeFolder();

        super.cleanup();
    }

    public void setUrl(Object expression) throws Exception
    {
        _url = (String)evaluateAttribute("url", expression, String.class);

        closeFolder();
    }

    public void setOperation(Object expression) throws Exception
    {
        _map.put(OPERATION, (String)evaluateAttribute(OPERATION, expression, String.class));
    }

    public void setMessages(Object expression) throws Exception
    {
        _map.put(MESSAGES, evaluateAttribute(MESSAGES, expression, Object.class));
    }

    public void setControl(Object expression) throws Exception
    {
        _map.put(CONTROL, evaluateAttribute(CONTROL, expression, Object.class));
    }

    public static int[] mark(String specs, int min, int max)
    {
        int size = max + 1;

        boolean mark[] = new boolean[size];

        int markCount = 0;

        String[] specArray = specs.split(",");

        for (int i = 0; i < specArray.length; i ++)
        {
            String spec = specArray[i];

            int firstIndex = min;
            int lastIndex = max;

            if (!("*".equals(spec)))
            {
                int separator = spec.indexOf('-');
                
                if (separator >= 0)
                {
                    String first = spec.substring(0, separator);
                    String last = spec.substring(separator + 1);
                    
                    if (!("*".equals(first)))
                    {
                        firstIndex = Integer.parseInt(first);
                    }
                    
                    if (!("*".equals(last)))
                    {
                        lastIndex = Integer.parseInt(last);
                    }
                }
                else
                {
                    firstIndex = Integer.parseInt(spec);
                    lastIndex = firstIndex;
                }
            }

            if (firstIndex < min)
            {
                firstIndex = min;
            }

            if (lastIndex > max)
            {
                lastIndex = max;
            }
            
            for (int j = firstIndex; j <= lastIndex; j ++)
            {
                boolean current = mark[j];
                
                if (!current)
                {
                    mark[j] = true;
                    markCount ++;
                }
            }
        }

        int[] marked = new int[markCount];

        int j = 0;

        for (int i = min; i < size; i ++)
        {
            if (mark[i])
            {
                marked[j ++] = i;
            }
        }

        return marked;
    }

    public Object processValue(Object tagValue) throws Exception
    {
        Folder folder = getFolder();

        if (!folder.isOpen())
        {
            folder.open(Folder.READ_WRITE);
        }

        NestedMap map = _map;

        Map controlMap = new NestedMap(map.get(CONTROL));
        Object messagesSpec = map.get(MESSAGES);
        String operation = map.getString(OPERATION, READ);

        int[] messages = null;

        if (messagesSpec instanceof NestedMap)
        {
            messagesSpec = ((NestedMap)messagesSpec).getSubList(false);
        }

        if (messagesSpec instanceof int[])
        {
            messages = (int[])messagesSpec;
        }
        else if (messagesSpec instanceof String)
        {
            messages = mark(messagesSpec.toString(), 1, folder.getMessageCount());
        }
        else if (messagesSpec != null)
        {
            List messageList = TypeUtil.isList(messagesSpec);

            if (messageList != null)
            {
                int messageListSize = messageList.size();

                messages = new int[messageListSize];

                for (int i = 0; i < messageListSize; i ++)
                {
                    Object element = messageList.get(i);

                    if (element instanceof Message)
                    {
                        messages[i] = ((Message)element).getMessageNumber();
                    }
                    else
                    {
                        messages[i] = TypeUtil.isInteger(messageList.get(i)).intValue();
                    }
                }
            }
        }

        if (READ.equals(operation))
        {
            _map.copyFromSource(MailFolder.readMessages(folder, messages, controlMap));
        }
        else if (DELETE.equals(operation))
        {
            MailFolder.deleteMessages(folder, messages);
        }

        return tagValue;
    }
}
