/* 

Copyright 2003-2006 MicroNova (R)
All rights reserved.

Redistribution and use in source and binary forms, with or
without modification, are permitted provided that the following
conditions are met:

    * Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.

    * Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

    * Neither the name of MicroNova nor the names of its contributors
    may be used to endorse or promote products derived from this
    software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

*/


package com.micronova.jsp.tag;

import java.io.*;
import java.util.*;
import java.net.*;
import javax.net.ssl.*;
import java.security.cert.X509Certificate;
import com.micronova.util.*;

public class IncludeTag extends MapTag
{
    private static final String DEFAULTEXPORT = "${" + VALUEVAR + "." + NetUtil.RESPONSE + "." + NetUtil.CONTENT + "}";

    protected boolean _asynchronous;
    protected NestedMap _asynchronousMap;

    protected void init()
    {
        super.init();

        _export = DEFAULTEXPORT;

        _asynchronous = false;

        Map map = _map;

        map.put(NetUtil.USESTRUSTMANAGER, "true");
        map.put(NetUtil.USESHOSTNAMEVERIFIER, "true");
        map.put(NetUtil.THROWSEXCEPTION, "true");
        map.put(NetUtil.FOLLOWSREDIRECTS, "true");
        map.put(NetUtil.ALLOWSFILE, "false");
    }

    protected Object processValue(Object tagValue) throws Exception
    {
        if (_asynchronous)
        {
            NetUtil netUtil = new NetUtil(_map);

            Thread thread = new Thread(netUtil);
            thread.start();

            return thread;
        }
        else
        {
            return NetUtil.request(_map);
        }
    }

    /** sets URL */

    public void setUrl(Object expression) throws Exception
    {
        _map.put(NetUtil.URL, evaluateAttribute("url", expression, String.class));
    }

    /** allows "file" URL */

    public void setAllowsFile(Object expression) throws Exception
    {
        _map.put(NetUtil.ALLOWSFILE, evaluateAttribute("allowsFile", expression, Boolean.class));
    }

    /** sets asynchronous */

    public void setAsynchronous(Object expression) throws Exception
    {
        boolean asynchronous = ((Boolean)evaluateAttribute("asynchronous", expression, Boolean.class)).booleanValue();

        if (asynchronous)
        {
            _export = "${" + VALUEVAR + "}";
        }
        
        _asynchronous = asynchronous;
    }
}
