/* 

Copyright 2003-2006 MicroNova (R)
All rights reserved.

Redistribution and use in source and binary forms, with or
without modification, are permitted provided that the following
conditions are met:

    * Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.

    * Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

    * Neither the name of MicroNova nor the names of its contributors
    may be used to endorse or promote products derived from this
    software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

*/


package com.micronova.jsp.tag;

import java.util.*;
import com.micronova.util.*;

/** filters a string or list */

public class FilterTag extends YuzuTag
{
    protected String _include;
    protected String _apply;
    protected String _break;
    protected String _applyCodec;

    public void init()
    {
        super.init();

        _include = "true";
        _apply = null;
        _break = null;
        _applyCodec = null;
    }

    public void setInclude(Object expression) throws Exception
    {
        _include = (String)evaluateAttribute("include", expression, EL.class);
    }

    public void setApply(Object expression) throws Exception
    {
        _apply = (String)evaluateAttribute("apply", expression, EL.class);
    }

    public void setBreak(Object expression) throws Exception
    {
        _break = (String)evaluateAttribute("break", expression, EL.class);
    }

    public void setApplyCodec(Object expression) throws Exception
    {
        _applyCodec = (String)evaluateAttribute("applyCodec", expression, EL.class);
    }

    public Object processValue(Object tagValue) throws Exception
    {
        return EL.applyFilter(pageContext, tagValue, _include, _break, _apply, _applyCodec);
    }       
}
