/* 

Copyright 2003-2006 MicroNova (R)
All rights reserved.

Redistribution and use in source and binary forms, with or
without modification, are permitted provided that the following
conditions are met:

    * Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.

    * Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

    * Neither the name of MicroNova nor the names of its contributors
    may be used to endorse or promote products derived from this
    software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

*/

package com.micronova.jsp.tag;

import com.micronova.util.*;
import java.util.*;
import javax.servlet.jsp.*;
import java.lang.reflect.*;
import java.util.regex.*;

public class ELIterator extends NestedMap implements Iterator
{
    public static final String PAGECONTEXT = "pageContext";
    public static final String ENVVAR = "_";
    public static final String HASNEXTCODEC = "hasNextCodec";
    public static final String NEXTCODEC = "nextCodec";

    /** special keys */

    public static final String COLLECTION = "collection";
    public static final String NEXT = "next";
    public static final String HASNEXT = "hasNext";
    public static final String INDEX = "index";

    protected PageContext _pageContext;
    protected Iterator _iterator;
    protected int _index;

    public ELIterator(PageContext pageContext, Object source) throws Exception
    {
        super(source);

        _pageContext = pageContext;
        _iterator = null;
        _index = 0;
    }

    public boolean hasNext()
    {
        Object envVar = null;
        PageContext pageContext = _pageContext;

        try
        {
            envVar = EL.getPageAttribute(pageContext, ENVVAR);

            EL.setPageAttribute(pageContext, ENVVAR, this);

            String hasNextCodec = EL.replaceEvalEscape(getString(HASNEXTCODEC));

            Object hasNextValue = null;

            if (!TypeUtil.isEmptyString(hasNextCodec))
            {
                hasNextValue = EL.applyCodec(pageContext, hasNextCodec, this);
            }
            else
            {
                hasNextValue = getHasNext();
            }

            return TypeUtil.isTrue(hasNextValue);
        }
        catch (Exception e)
        {
            e.printStackTrace();

            throw new RuntimeException(e);
        }
        finally
        {
            if (envVar != null)
            {
                EL.setPageAttribute(pageContext, ENVVAR, envVar);
            }
        }
    }

    public Object next()
    {
        Object envVar = null;
        PageContext pageContext = _pageContext;

        try
        {
            envVar = EL.getPageAttribute(pageContext, ENVVAR);

            EL.setPageAttribute(pageContext, ENVVAR, this);

            String nextCodec = EL.replaceEvalEscape(getString(NEXTCODEC));

            Object x = null;

            if (!TypeUtil.isEmptyString(nextCodec))
            {
                x = EL.applyCodec(pageContext, nextCodec, this);
            }
            else
            {
                x = getNext();
            }

            _index ++;

            return x;
        }
        catch (Exception e)
        {
            e.printStackTrace();

            throw new RuntimeException(e);
        }
        finally
        {
            if (envVar != null)
            {
                EL.setPageAttribute(pageContext, ENVVAR, envVar);
            }
        }
    }

    public void remove()
    {
        throw new UnsupportedOperationException();
    }

    public Object getObject(Object client, Object key)
    {
        if (NEXT.equals(key))
        {
            return getNext();
        }
        else if (HASNEXT.equals(key))
        {
            return getHasNext();
        }
        else if (INDEX.equals(key))
        {
            return new Integer(_index);
        }
        else
        {
            return super.getObject(client, key);
        }
    }

    public Object putObject(Object client, Object key, Object value)
    {
        if (COLLECTION.equals(key))
        {
            _iterator = null;
        }

        return super.putObject(client, key, value);
    }

    public Iterator getIterator()
    {
        Iterator iterator = _iterator;
        
        if (iterator == null)
        {
            Object collection = get(COLLECTION);

            if (collection != null)
            {
                iterator = ((Collection)collection).iterator();
                _iterator = iterator;
            }
        }

        return iterator;
    }

    public Object getNext()
    {
        Object next = getMapObject(NEXT);

        if (next == null)
        {
            Iterator iterator = getIterator();

            if (iterator != null)
            {
                next = iterator.next();
            }
        }

        return next;
    }

    public Object getHasNext()
    {
        Object hasNext = getMapObject(HASNEXT);

        if (hasNext != null)
        {
            if (TypeUtil.isTrue(hasNext))
            {
                hasNext = Boolean.TRUE;
            }
            else
            {
                hasNext = null;
            }
        }
        else
        {
            Iterator iterator = getIterator();

            if (iterator != null)
            {
                if (iterator.hasNext())
                {
                    hasNext = Boolean.TRUE;
                }
            }
        }
 
        return hasNext;
    }
}

