/* 

Copyright 2003-2006 MicroNova (R)
All rights reserved.

Redistribution and use in source and binary forms, with or
without modification, are permitted provided that the following
conditions are met:

    * Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.

    * Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

    * Neither the name of MicroNova nor the names of its contributors
    may be used to endorse or promote products derived from this
    software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

*/


package com.micronova.util.servlet;

import javax.servlet.*;
import javax.servlet.http.*;
import java.io.*;
import java.util.*;

/** HttpServletResponse with buffered output */

class BufferedHttpServletResponse extends HttpServletResponseWrapper
{
    ByteArrayOutputStream _bOut;
    ServletOutputStream _out;
    StringWriter _writer;
    boolean _isWriterUsed;
    boolean _isOutputStreamUsed;
    int _status;

    public BufferedHttpServletResponse(HttpServletResponse response)
    {
        super(response);

        _isWriterUsed = false;
        _isOutputStreamUsed = false;
    }

    public ServletOutputStream getOutputStream() throws IOException
    {
        _isOutputStreamUsed = true;
        _bOut = new ByteArrayOutputStream();
        _out = new ServletOutputStreamWrapper(_bOut);

        return _out;
    }

    public PrintWriter getWriter() throws IOException
    {
        _isWriterUsed = true;
        _writer = new StringWriter();

        return new PrintWriter(_writer);
    }

    public int getStatus()
    {
        return _status;
    }

    public void setStatus(int status)
    {
        _status = status;
    }

    /** returns buffered content as String using given encoding */

    public String getString(String encoding) throws Exception
    {
        if (_isWriterUsed)
        {
            return _writer.toString();
        }
        else if (_isOutputStreamUsed)
        {
            return new String(_bOut.toByteArray(), encoding);
        }
        else
        {
            return null;
        }
    }

    /** returns buffered content as String */

    public String getString() throws Exception
    {
        return getString(getCharacterEncoding());
    }
}
