/* 

Copyright 2003-2006 MicroNova (R)
All rights reserved.

Redistribution and use in source and binary forms, with or
without modification, are permitted provided that the following
conditions are met:

    * Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.

    * Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

    * Neither the name of MicroNova nor the names of its contributors
    may be used to endorse or promote products derived from this
    software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

*/


package com.micronova.util.codec;

import java.util.*;
import com.micronova.util.*;
import org.w3c.dom.*;
import javax.xml.parsers.*;
import org.xml.sax.*;
import java.io.*;
import java.net.*;
import javax.xml.transform.*;
import javax.xml.transform.dom.*;
import javax.xml.transform.sax.*;
import javax.xml.transform.stream.*;

/** XML-related codecs */

public class CodecXML extends Codec
{
    /** parses document */

    public static final Object parse(Object object, Object control) throws Exception
    {
        return XMLUtil.parse(object, TypeUtil.isNestedMap(control));
    }

    /** parser with default controlMap */

    public static Object parse(Object object) throws Exception
    {
        return parse(object, null);
    }

    /** encodes XML tag characters */

    public static final Object encode(Object object) throws Exception
    {
        return encode(object, null);
    }

    /** encodes XML tag characters specified by the "spec" regex (e.g., "[&<>]" to encode &, <, > only); if "spec" is null, then all supported characters are encoded.  If "spec" is "~", then "[&<>]" is assumed. */

    public static final Object encode(Object object, Object spec) throws Exception
    {
        if (object != null)
        {
            if ("~".equals(spec))
            {
                spec = "[&<>]";
            }

            object = XMLUtil.encode(object.toString(), TypeUtil.isPattern(spec));
        }

        return object;
    }

    /** decodes XML tag characters */

    public static final Object decode(Object object) throws Exception
    {
        if (object != null)
        {
            object = XMLUtil.decode(object.toString());
        }

        return object;
    }

    /** outputs an XML object */

    public static final Object output(Object object, Object control) throws Exception
    {
        return XMLUtil.output(XMLUtil.createSource(object), new NestedMap(control));
    }

    /** outputs using default control (omit-xml-declaration=yes) */

    public static final Object output(Object object) throws Exception
    {
        return output(object, "omit-xml-declaration=yes");
    }
}

