/* 

Copyright 2003-2006 MicroNova (R)
All rights reserved.

Redistribution and use in source and binary forms, with or
without modification, are permitted provided that the following
conditions are met:

    * Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.

    * Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

    * Neither the name of MicroNova nor the names of its contributors
    may be used to endorse or promote products derived from this
    software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

*/


package com.micronova.util.codec;

import java.net.*;
import java.io.*;

import com.micronova.util.*;

public class CodecURL extends Codec
{
    /** URL-encodes using given encoding */

    public static Object encode(Object object, Object encoding) throws Exception
    {
        if (object != null)
        {
            String string = object.toString();
            
            object = java.net.URLEncoder.encode(string, encoding.toString());
        }

        return object;
    }

    /** URL-encodes using "utf-8" */

    public static Object encode(Object object) throws Exception
    {
        return encode(object, "utf-8");
    }

    /** URL-decodes using given encoding */

    public static Object decode(Object object, Object encoding) throws Exception
    {
        if (object != null)
        {
            String string = object.toString();
            
            object = java.net.URLDecoder.decode(string, encoding.toString());
        }

        return object;
    }

    /** URL-decodes using "utf-8" */

    public static Object decode(Object object) throws Exception
    {
        return decode(object, "utf-8");
    }

    /** content type from byte array */

    public static Object streamType(Object object)
    {
        if (object != null)
        {
            try
            {
                InputStream is = null;

                if (object instanceof String)
                {
                    is = new ByteArrayInputStream(StringUtil.fromBinaryString(object.toString()));
                }
                else if (object instanceof byte[])
                {
                    is = new ByteArrayInputStream((byte[])object);
                }
                else if (object instanceof InputStream)
                {
                    is = (InputStream)object;
                }
                
                if (is != null)
                {
                    String guessedType = URLConnection.guessContentTypeFromStream(is);
                    if (!object.equals(guessedType))
                    {
                        object = guessedType;
                    }
                }
            }
            catch (Exception e)
            {
                object = null;
            }
        }

        return object;
    }

    /** returns name type */

    public static Object nameType(Object object)
    {
        if (object != null)
        {
            object = URLConnection.guessContentTypeFromName(object.toString());
        }

        return object;
    }

    public static Object normalize(Object object)
    {
        URI uri = null;

        if (object != null)
        {
            URI uriObject = TypeUtil.isURI(object);

            if (uriObject != null)
            {
                uri = uriObject.normalize();
            }
        }

        return uri;
    }

    public static Object relativize(Object object, Object base)
    {
        URI uri = null;

        if (object != null)
        {
            URI uriObject = TypeUtil.isURI(object);

            if (uriObject != null)
            {
                URI uriBase = TypeUtil.isURI(base);

                if (uriBase != null)
                {
                    uri = uriBase.relativize(uriObject);
                }
            }
        }

        return uri;
    }

    public static Object resolve(Object object, Object base)
    {
        URI uri = null;

        if (object != null)
        {
            URI uriObject = TypeUtil.isURI(object);

            if (uriObject != null)
            {
                URI uriBase = TypeUtil.isURI(base);

                if (uriBase != null)
                {
                    uri = uriBase.resolve(uriObject);
                }
            }
        }

        return uri;
    }
}
