// compile with "javac -encoding UTF8"

package com.micronova.util.codec;

public class CodecJapanese
{
    public static String _normalize(String input)
    {
        StringBuffer inputBuffer = new StringBuffer(input);
        StringBuffer outputBuffer = new StringBuffer();

        int inputBufferLength = inputBuffer.length();

        char previous = 0;

        for (int i = 0; i < inputBufferLength; i ++)
        {
            char c = inputBuffer.charAt(i);

            if (c == 'ﾞ')
            {
                switch (previous)
                {
                    case 'カ': {outputBuffer.append('ガ'); break;}
                    case 'キ': {outputBuffer.append('ギ'); break;}
                    case 'ク': {outputBuffer.append('グ'); break;}
                    case 'ケ': {outputBuffer.append('ゲ'); break;}
                    case 'コ': {outputBuffer.append('ゴ'); break;}
                    case 'サ': {outputBuffer.append('ザ'); break;}
                    case 'シ': {outputBuffer.append('ジ'); break;}
                    case 'ス': {outputBuffer.append('ズ'); break;}
                    case 'セ': {outputBuffer.append('ゼ'); break;}
                    case 'ソ': {outputBuffer.append('ゾ'); break;}
                    case 'タ': {outputBuffer.append('ダ'); break;}
                    case 'チ': {outputBuffer.append('ヂ'); break;}
                    case 'ツ': {outputBuffer.append('ヅ'); break;}
                    case 'テ': {outputBuffer.append('デ'); break;}
                    case 'ト': {outputBuffer.append('ド'); break;}
                    case 'ハ': {outputBuffer.append('バ'); break;}
                    case 'ヒ': {outputBuffer.append('ビ'); break;}
                    case 'フ': {outputBuffer.append('ブ'); break;}
                    case 'ヘ': {outputBuffer.append('ベ'); break;}
                    case 'ホ': {outputBuffer.append('ボ'); break;}
                    case 'ウ': {outputBuffer.append('ヴ'); break;}

                    default: {if (previous != 0) {outputBuffer.append(previous);} outputBuffer.append(c); break;}
                }

                previous = 0;
            }
            else if (c == 'ﾟ')
            {
                switch (previous)
                {
                    case 'ハ': {outputBuffer.append('パ'); break;}
                    case 'ヒ': {outputBuffer.append('ピ'); break;}
                    case 'フ': {outputBuffer.append('プ'); break;}
                    case 'ヘ': {outputBuffer.append('ペ'); break;}
                    case 'ホ': {outputBuffer.append('ポ'); break;}

                    default: {if (previous != 0) {outputBuffer.append(previous);} outputBuffer.append(c); break;}
                }

                previous = 0;
            }
            else
            {
                if (previous != 0)
                {
                    outputBuffer.append(previous);
                    previous = 0;
                }

                switch (c)
                {
                    case '｡': {outputBuffer.append('。'); break;}
                    case '｢': {outputBuffer.append('「'); break;}
                    case '｣': {outputBuffer.append('」'); break;}
                    case '､': {outputBuffer.append('、'); break;}
                    case '･': {outputBuffer.append('・'); break;}
                    case 'ｧ': {outputBuffer.append('ァ'); break;}
                    case 'ｱ': {outputBuffer.append('ア'); break;}
                    case 'ｨ': {outputBuffer.append('ィ'); break;}
                    case 'ｲ': {outputBuffer.append('イ'); break;}
                    case 'ｩ': {outputBuffer.append('ゥ'); break;}
                    case 'ｳ': {previous = 'ウ'; break;}
                    case 'ｪ': {outputBuffer.append('ェ'); break;}
                    case 'ｴ': {outputBuffer.append('エ'); break;}
                    case 'ｫ': {outputBuffer.append('ォ'); break;}
                    case 'ｵ': {outputBuffer.append('オ'); break;}

                    case 'ｶ': {previous = 'カ'; break;}
                    case 'ｷ': {previous = 'キ'; break;}
                    case 'ｸ': {previous = 'ク'; break;}
                    case 'ｹ': {previous = 'ケ'; break;}
                    case 'ｺ': {previous = 'コ'; break;}
                    case 'ｻ': {previous = 'サ'; break;}
                    case 'ｼ': {previous = 'シ'; break;}
                    case 'ｽ': {previous = 'ス'; break;}
                    case 'ｾ': {previous = 'セ'; break;}
                    case 'ｿ': {previous = 'ソ'; break;}
                    case 'ﾀ': {previous = 'タ'; break;}
                    case 'ﾁ': {previous = 'チ'; break;}
                    case 'ｯ': {outputBuffer.append('ッ'); break;}
                    case 'ﾂ': {previous = 'ツ'; break;}
                    case 'ﾃ': {previous = 'テ'; break;}
                    case 'ﾄ': {previous = 'ト'; break;}
                    case 'ﾅ': {outputBuffer.append('ナ'); break;}
                    case 'ﾆ': {outputBuffer.append('ニ'); break;}
                    case 'ﾇ': {outputBuffer.append('ヌ'); break;}
                    case 'ﾈ': {outputBuffer.append('ネ'); break;}
                    case 'ﾉ': {outputBuffer.append('ノ'); break;}
                    case 'ﾊ': {previous = 'ハ'; break;}
                    case 'ﾋ': {previous = 'ヒ'; break;}
                    case 'ﾌ': {previous = 'フ'; break;}
                    case 'ﾍ': {previous = 'ヘ'; break;}
                    case 'ﾎ': {previous = 'ホ'; break;}
                    case 'ﾏ': {outputBuffer.append('マ'); break;}
                    case 'ﾐ': {outputBuffer.append('ミ'); break;}
                    case 'ﾑ': {outputBuffer.append('ム'); break;}
                    case 'ﾒ': {outputBuffer.append('メ'); break;}
                    case 'ﾓ': {outputBuffer.append('モ'); break;}
                    case 'ｬ': {outputBuffer.append('ャ'); break;}
                    case 'ﾔ': {outputBuffer.append('ヤ'); break;}
                    case 'ｭ': {outputBuffer.append('ュ'); break;}
                    case 'ﾕ': {outputBuffer.append('ユ'); break;}
                    case 'ｮ': {outputBuffer.append('ョ'); break;}
                    case 'ﾖ': {outputBuffer.append('ヨ'); break;}
                    case 'ﾗ': {outputBuffer.append('ラ'); break;}
                    case 'ﾘ': {outputBuffer.append('リ'); break;}
                    case 'ﾙ': {outputBuffer.append('ル'); break;}
                    case 'ﾚ': {outputBuffer.append('レ'); break;}
                    case 'ﾛ': {outputBuffer.append('ロ'); break;}
                    case 'ﾜ': {outputBuffer.append('ワ'); break;}
                    case 'ｦ': {outputBuffer.append('ヲ'); break;}
                    case 'ﾝ': {outputBuffer.append('ン'); break;}
                    case 'ヵ': {outputBuffer.append('ヵ'); break;}
                    case 'ヶ': {outputBuffer.append('ヶ'); break;}
                    case 'ﾞ': {outputBuffer.append('゛'); break;}
                    case 'ﾟ': {outputBuffer.append('゜'); break;}
                    case 'ｰ': {outputBuffer.append('ー'); break;}

                    case '！': {outputBuffer.append('!'); break;}
                    case '\'': {outputBuffer.append('\''); break;}
                    case '＃': {outputBuffer.append('#'); break;}
                    case '＄': {outputBuffer.append('$'); break;}
                    case '％': {outputBuffer.append('%'); break;}
                    case '＆': {outputBuffer.append('&'); break;}
                    case '"': {outputBuffer.append('"'); break;}
                    case '（': {outputBuffer.append('('); break;}
                    case '）': {outputBuffer.append(')'); break;}
                    case '＊': {outputBuffer.append('*'); break;}
                    case '＋': {outputBuffer.append('+'); break;}
                    case '，': {outputBuffer.append(','); break;}
                    case '－': {outputBuffer.append('-'); break;}
                    case '．': {outputBuffer.append('.'); break;}
                    case '／': {outputBuffer.append('/'); break;}
                    case '０': {outputBuffer.append('0'); break;}
                    case '１': {outputBuffer.append('1'); break;}
                    case '２': {outputBuffer.append('2'); break;}
                    case '３': {outputBuffer.append('3'); break;}
                    case '４': {outputBuffer.append('4'); break;}
                    case '５': {outputBuffer.append('5'); break;}
                    case '６': {outputBuffer.append('6'); break;}
                    case '７': {outputBuffer.append('7'); break;}
                    case '８': {outputBuffer.append('8'); break;}
                    case '９': {outputBuffer.append('9'); break;}
                    case '：': {outputBuffer.append(':'); break;}
                    case '；': {outputBuffer.append(';'); break;}
                    case '＜': {outputBuffer.append('<'); break;}
                    case '＝': {outputBuffer.append('='); break;}
                    case '＞': {outputBuffer.append('>'); break;}
                    case '？': {outputBuffer.append('?'); break;}
                    case '＠': {outputBuffer.append('@'); break;}
                    case 'Ａ': {outputBuffer.append('A'); break;}
                    case 'Ｂ': {outputBuffer.append('B'); break;}
                    case 'Ｃ': {outputBuffer.append('C'); break;}
                    case 'Ｄ': {outputBuffer.append('D'); break;}
                    case 'Ｅ': {outputBuffer.append('E'); break;}
                    case 'Ｆ': {outputBuffer.append('F'); break;}
                    case 'Ｇ': {outputBuffer.append('G'); break;}
                    case 'Ｈ': {outputBuffer.append('H'); break;}
                    case 'Ｉ': {outputBuffer.append('I'); break;}
                    case 'Ｊ': {outputBuffer.append('J'); break;}
                    case 'Ｋ': {outputBuffer.append('K'); break;}
                    case 'Ｌ': {outputBuffer.append('L'); break;}
                    case 'Ｍ': {outputBuffer.append('M'); break;}
                    case 'Ｎ': {outputBuffer.append('N'); break;}
                    case 'Ｏ': {outputBuffer.append('O'); break;}
                    case 'Ｐ': {outputBuffer.append('P'); break;}
                    case 'Ｑ': {outputBuffer.append('Q'); break;}
                    case 'Ｒ': {outputBuffer.append('R'); break;}
                    case 'Ｓ': {outputBuffer.append('S'); break;}
                    case 'Ｔ': {outputBuffer.append('T'); break;}
                    case 'Ｕ': {outputBuffer.append('U'); break;}
                    case 'Ｖ': {outputBuffer.append('V'); break;}
                    case 'Ｗ': {outputBuffer.append('W'); break;}
                    case 'Ｘ': {outputBuffer.append('X'); break;}
                    case 'Ｙ': {outputBuffer.append('Y'); break;}
                    case 'Ｚ': {outputBuffer.append('Z'); break;}
                    case '［': {outputBuffer.append('['); break;}
                    case '\\': {outputBuffer.append('\\'); break;}
                    case '］': {outputBuffer.append(']'); break;}
                    case '＾': {outputBuffer.append('^'); break;}
                    case '＿': {outputBuffer.append('_'); break;}
                    case '｀': {outputBuffer.append('`'); break;}
                    case 'ａ': {outputBuffer.append('a'); break;}
                    case 'ｂ': {outputBuffer.append('b'); break;}
                    case 'ｃ': {outputBuffer.append('c'); break;}
                    case 'ｄ': {outputBuffer.append('d'); break;}
                    case 'ｅ': {outputBuffer.append('e'); break;}
                    case 'ｆ': {outputBuffer.append('f'); break;}
                    case 'ｇ': {outputBuffer.append('g'); break;}
                    case 'ｈ': {outputBuffer.append('h'); break;}
                    case 'ｉ': {outputBuffer.append('i'); break;}
                    case 'ｊ': {outputBuffer.append('j'); break;}
                    case 'ｋ': {outputBuffer.append('k'); break;}
                    case 'ｌ': {outputBuffer.append('l'); break;}
                    case 'ｍ': {outputBuffer.append('m'); break;}
                    case 'ｎ': {outputBuffer.append('n'); break;}
                    case 'ｏ': {outputBuffer.append('o'); break;}
                    case 'ｐ': {outputBuffer.append('p'); break;}
                    case 'ｑ': {outputBuffer.append('q'); break;}
                    case 'ｒ': {outputBuffer.append('r'); break;}
                    case 'ｓ': {outputBuffer.append('s'); break;}
                    case 'ｔ': {outputBuffer.append('t'); break;}
                    case 'ｕ': {outputBuffer.append('u'); break;}
                    case 'ｖ': {outputBuffer.append('v'); break;}
                    case 'ｗ': {outputBuffer.append('w'); break;}
                    case 'ｘ': {outputBuffer.append('x'); break;}
                    case 'ｙ': {outputBuffer.append('y'); break;}
                    case 'ｚ': {outputBuffer.append('z'); break;}
                    case '｛': {outputBuffer.append('{'); break;}
                    case '｜': {outputBuffer.append('|'); break;}
                    case '｝': {outputBuffer.append('}'); break;}
                    case '~': {outputBuffer.append('~'); break;}
                    case '　': {outputBuffer.append(' '); break;}
                    default: {outputBuffer.append(c); break;}
                }
            }
        }

        if (previous != 0)
        {
            outputBuffer.append(previous);
        }

        return outputBuffer.toString();
    }


    public static Object normalize(Object object)
    {
        if (object != null)
        {
            object = _normalize(object.toString());
        }

        return object;
    }
}

