/* 

Copyright 2003-2006 MicroNova (R)
All rights reserved.

Redistribution and use in source and binary forms, with or
without modification, are permitted provided that the following
conditions are met:

    * Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.

    * Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

    * Neither the name of MicroNova nor the names of its contributors
    may be used to endorse or promote products derived from this
    software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

*/


package com.micronova.util.codec;

import java.util.*;
import java.text.*;

import com.micronova.util.*;

public class CodecFormat extends Codec
{
    public static Object date(Object object, Object patternSpec, Object localeSpec, Object timezoneSpec) throws Exception
    {
        if (object != null)
        {
            String pattern = TypeUtil.isString(patternSpec);

            Locale locale = TypeUtil.isLocale(localeSpec);
            TimeZone timezone = TypeUtil.isTimeZone(timezoneSpec);

            Date date = TypeUtil.isDate(object, pattern, locale);

            if (date != null)
            {
                SimpleDateFormat simpleDateFormat;
                    
                if (pattern == null)
                {
                    simpleDateFormat = new SimpleDateFormat();
                }
                else
                {
                    simpleDateFormat = new SimpleDateFormat(pattern, locale);
                }

                if (timezone != null)
                {
                    simpleDateFormat.setTimeZone(timezone);
                }
                
                StringBuffer buffer = new StringBuffer();
                FieldPosition fieldPosition = new FieldPosition(0);

                buffer = simpleDateFormat.format(date, buffer, fieldPosition);

                object = buffer.toString();
            }
            else
            {
                object = null;
            }
        }

        return object;
    }

    public static Object date(Object object, Object patternSpec, Object localeSpec) throws Exception
    {
        return date(object, patternSpec, localeSpec, null);
    }

    public static Object date(Object object, Object patternSpec) throws Exception
    {
        return date(object, patternSpec, null);
    }

    public static Object date(Object object) throws Exception
    {
        return date(object, null, null);
    }

    public static Object number(Object object, Object patternSpec, Object localeSpec) throws Exception
    {
        if (object != null)
        {
            String pattern = TypeUtil.isString(patternSpec);

            Locale locale = TypeUtil.isLocale(localeSpec);

            Number number = TypeUtil.isNumber(object, pattern, locale);

            if (number != null)
            {
                DecimalFormat decimalFormat;

                if (pattern == null)
                {
                    decimalFormat = new DecimalFormat();
                }
                else
                {
                    decimalFormat = new DecimalFormat(pattern, new DecimalFormatSymbols(locale));
                }
                
                StringBuffer buffer = new StringBuffer();
                FieldPosition fieldPosition = new FieldPosition(0);

                buffer = decimalFormat.format(number, buffer, fieldPosition);

                object = buffer.toString();
            }
            else
            {
                object = null;
            }
        }

        return object;
    }


    public static Object number(Object object, Object patternSpec) throws Exception
    {
        return number(object, patternSpec, null);
    }

    public static Object number(Object object) throws Exception
    {
        return number(object, null, null);
    }
}
