/* 

Copyright 2003-2006 MicroNova (R)
All rights reserved.

Redistribution and use in source and binary forms, with or
without modification, are permitted provided that the following
conditions are met:

    * Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.

    * Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

    * Neither the name of MicroNova nor the names of its contributors
    may be used to endorse or promote products derived from this
    software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

*/

package com.micronova.util.codec;

import com.micronova.util.*;
import java.util.*;
import java.lang.reflect.*;

/** calendar operations */

public class CodecCalendar extends Codec
{
    /** monthly calendar keys */

    public static final String NUMBEROFWEEKS = "numberOfWeeks";
    public static final String WEEK = "week";
    public static final String DAYINDEXSTART = "dayIndexStart";
    public static final String DAYINDEXEND = "dayIndexEnd";
    public static final String DAYINDEXTODAY = "dayIndexToday";
    public static final String WEEKINDEX = "weekIndex";
    public static final String DAYINDEX = "dayIndex";
    public static final String DATE = "date";
    public static final String TODAY = "today";
    public static final String THISWEEK = "thisWeek";
    public static final String FIRSTDAYOFMONTH = "firstDayOfMonth";
    public static final String LASTDAYOFMONTH = "lastDayOfMonth";
    public static final String NEXTMONTH = "nextMonth";
    public static final String LASTMONTH = "lastMonth";
    public static final String NEXTYEAR = "nextYear";
    public static final String LASTYEAR = "lastYear";

    private static int getFieldForName(String name) throws Exception
    {
        return Class.forName("java.util.Calendar").getField(name).getInt(null);
    }

    public static Object set(Object object, Object fieldSpec, Object valueSpec) throws Exception
    {
        if (object != null)
        {
            try
            {
                Calendar calendar = TypeUtil.isCalendar(object, null, null);

                int field = getFieldForName(fieldSpec.toString());

                int value = TypeUtil.isInteger(valueSpec).intValue();
            
                calendar.set(field, value);

                object = calendar;
            }
            catch (Exception e)
            {
                object = null;
            }
        }

        return object;
    }

    public static Object get(Object object, Object fieldSpec) throws Exception
    {
        if (object != null)
        {
            try
            {
                Calendar calendar = TypeUtil.isCalendar(object, null, null);

                int field = getFieldForName(fieldSpec.toString());

                object = new Integer(calendar.get(field));
            }
            catch (Exception e)
            {
                object = null;
            }
        }

        return object;
    }

    public static Object add(Object object, Object fieldSpec, Object valueSpec) throws Exception
    {
        if (object != null)
        {
            try
            {
                Calendar calendar = TypeUtil.isCalendar(object, null, null);

                int field = getFieldForName(fieldSpec.toString());

                int value = TypeUtil.isInteger(valueSpec).intValue();
            
                calendar.add(field, value);

                object = calendar;
            }
            catch (Exception e)
            {
                object = null;
            }
        }

        return object;
    }

    public static Object roll(Object object, Object fieldSpec, Object valueSpec) throws Exception
    {
        if (object != null)
        {
            try
            {
                Calendar calendar = TypeUtil.isCalendar(object, null, null);

                int field = getFieldForName(fieldSpec.toString());

                int value = TypeUtil.isInteger(valueSpec).intValue();
            
                calendar.roll(field, value);

                object = calendar;
            }
            catch (Exception e)
            {
                object = null;
            }
        }

        return object;
    }

    /** returns monthly calendar map structure */

    public static Object monthly(Object object) throws Exception
    {
        NestedMap monthly = null;

        if (object != null)
        {
            try
            {
                monthly = new NestedMap();

                Calendar calendar = TypeUtil.isCalendar(object, null, null);

                int firstDayOfWeek = calendar.getFirstDayOfWeek();
            
                Date today = calendar.getTime();

                int thisWeek = calendar.get(Calendar.WEEK_OF_MONTH);

                calendar.set(Calendar.DATE, 1);
                calendar.add(Calendar.MONTH, 1);
                calendar.add(Calendar.DATE, -1);
                
                Date lastDayOfMonth = calendar.getTime();

                int lastWeek = calendar.get(Calendar.WEEK_OF_MONTH);
                
                calendar.set(Calendar.DATE, 1);
            
                Date firstDayOfMonth = calendar.getTime();
                
                int firstWeek = calendar.get(Calendar.WEEK_OF_MONTH);
                
                calendar.set(Calendar.DAY_OF_WEEK, firstDayOfWeek);
                
                Date firstDayOfCalendar = calendar.getTime();
                
                int numberOfWeeks = lastWeek - firstWeek + 1;

                monthly.put(NUMBEROFWEEKS, new Integer(numberOfWeeks));
                
                for (int w = 0; w < numberOfWeeks; w ++)
                {
                    NestedMap weekMap = new NestedMap();
                    
                    weekMap.put(DAYINDEXSTART, new Integer(0));
                    weekMap.put(DAYINDEXEND, new Integer(6));
                    weekMap.put(WEEKINDEX, new Integer(w));
                    
                    for (int i = 0; i < 7; i ++)
                    {
                        Date day = calendar.getTime();
                        
                        weekMap.put("@_.*", day);
                        calendar.add(Calendar.DATE, 1);
                        
                        if (day.equals(today))
                        {
                            NestedMap specialDay = new NestedMap();
                            
                            specialDay.put(DATE, day);
                            specialDay.put(WEEKINDEX, new Integer(w));
                            specialDay.put(DAYINDEX, new Integer(i));
                            
                            monthly.put(TODAY, specialDay);
                            weekMap.put(DAYINDEXTODAY, new Integer(i));
                            
                            monthly.put(THISWEEK, weekMap);
                        }
                        
                        if (day.equals(firstDayOfMonth))
                        {
                            NestedMap specialDay = new NestedMap();
                            
                            specialDay.put(DATE, day);
                            specialDay.put(WEEKINDEX, new Integer(w));
                            specialDay.put(DAYINDEX, new Integer(i));
                            
                            monthly.put(FIRSTDAYOFMONTH, specialDay);

                            weekMap.put(DAYINDEXSTART, new Integer(i));
                        }
                        
                        if (day.equals(lastDayOfMonth))
                        {
                            NestedMap specialDay = new NestedMap();
                            
                            specialDay.put(DATE, day);
                            specialDay.put(WEEKINDEX, new Integer(w));
                            specialDay.put(DAYINDEX, new Integer(i));
                            
                            monthly.put(LASTDAYOFMONTH, specialDay);
                            
                            weekMap.put(DAYINDEXEND, new Integer(i));
                        }
                    }
                    
                    monthly.put("@" + WEEK + "._.*", weekMap);
                }
                
                calendar.setTime(today);
                
                calendar.add(Calendar.MONTH, 1);

                monthly.put(NEXTMONTH, calendar.getTime());
                
                calendar.setTime(today);

                calendar.add(Calendar.MONTH, -1);

                monthly.put(LASTMONTH, calendar.getTime());
                
                calendar.setTime(today);
            
                calendar.add(Calendar.YEAR, 1);

                monthly.put(NEXTYEAR, calendar.getTime());
                
                calendar.setTime(today);
                
                calendar.add(Calendar.YEAR, -1);

                monthly.put(LASTYEAR, calendar.getTime());

                calendar.setTime(today);
            }
            catch (Exception e)
            {
                monthly = null;
            }
        }

        return monthly;
    }
}

