/* 

Copyright 2003-2006 MicroNova (R)
All rights reserved.

Redistribution and use in source and binary forms, with or
without modification, are permitted provided that the following
conditions are met:

    * Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.

    * Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

    * Neither the name of MicroNova nor the names of its contributors
    may be used to endorse or promote products derived from this
    software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

*/


package com.micronova.util.codec;

import java.util.*;
import java.util.regex.*;

import com.micronova.util.*;

public class CodecBean extends Codec
{
    /** pattern used to remove "<?xml ....?>" */

    private static Pattern pattern;

    static
    {
        pattern = Pattern.compile("<[?][xX][mM][lL][^?]*[?]>");
    }

    /** encodes bean as XML, excluding "<?xml ...?>" **/

    public static Object encode(Object object) throws Exception
    {
        if (object != null)
        {
            String encoded = BeanUtil.encode(object);

            object = pattern.matcher(encoded).replaceFirst("");
        }

        return object;
    }

    /** decodes bean XML */

    public static Object decode(Object object) throws Exception
    {
        if (object != null)
        {
            String s = pattern.matcher(object.toString()).replaceFirst("");

            object = BeanUtil.decode(s);
        }

        return object;
    }

    /** fill object with bean property map (property-value pairs) */

    public static Object fill(Object object, Object propertyMap) throws Exception
    {
        if (object != null)
        {
            Map map = null;

            if (propertyMap instanceof Map)
            {
                map = (Map)propertyMap;
            }
            else
            {
                map = new NestedMap(propertyMap);
            }

            object = BeanUtil.fill(object, map);
        }

        return object;
    }

    /** get a bean property */

    public static Object get(Object object, Object property) throws Exception
    {
        if (object != null)
        {
            object = BeanUtil.getProperty(object, property.toString());
        }

        return object;
    }

    /** get a bean property (strict) */

    public static Object getProperty(Object object, Object property) throws Exception
    {
        if (object != null)
        {
            object = BeanUtil.getBeanProperty(object, property.toString());
        }

        return object;
    }

    /** set a bean property */

    public static Object set(Object object, Object property, Object value) throws Exception
    {
        if (object != null)
        {
            BeanUtil.setProperty(object, property.toString(), value);
        }

        return object;
    }

    /** set a bean property (strict) */

    public static Object setProperty(Object object, Object property, Object value) throws Exception
    {
        if (object != null)
        {
            BeanUtil.setBeanProperty(object, property.toString(), value);
        }

        return object;
    }

    /** get a map of all bean properties */

    public static Object getMap(Object object) throws Exception
    {
        if (object != null)
        {
            object = BeanUtil.getMap(object);
        }

        return object;
    }
}
