/* 

Copyright 2003-2006 MicroNova (R)
All rights reserved.

Redistribution and use in source and binary forms, with or
without modification, are permitted provided that the following
conditions are met:

    * Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.

    * Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

    * Neither the name of MicroNova nor the names of its contributors
    may be used to endorse or promote products derived from this
    software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

*/


/* Generated By:JavaCC: Do not edit this line. Parser.java */
package com.micronova.util.cc.html;

import java.io.*;
import java.util.*;

import javax.xml.parsers.*;
import javax.xml.transform.*;
import javax.xml.transform.dom.*;
import javax.xml.transform.stream.*;
import org.w3c.dom.*;

public class Parser implements ParserConstants {
    public final static String TYPE = "#TYPE#";
    public final static String VALUE = "#VALUE#";
    public final static String ATTRIBUTE = "#ATTRIBUTE#";

    public final static String OPENTAG = "opentag";
    public final static String SINGLETAG = "singletag";
    public final static String CLOSETAG = "closetag";
    public final static String TEXT = "text";
    public final static String COMMENT = "comment";
    public final static String SCRIPT = "script";
    public final static String STYLE = "style";
    public final static String SGML = "sgml";
    public final static String PI = "pi";

    /** parser strategies */

    public final static int STRATEGY_SINGLE = 0;
    public final static int STRATEGY_DATA = 1;
    public final static int STRATEGY_NONE = 2;

    /** gets next parsed element as Map. Given map, map[TYPE] is the type of the tag, map[VALUE] is the tag value, and map[ATTRIBUTE] is the attribute map (null if there are no attributes). */

    public Map getNext(Map map, Map attrMap, StringBuffer buffer)
    {
        try
        {
            return _getNext(map, attrMap, buffer);
        }
        catch (Exception e)
        {
            e.printStackTrace();

            return null;
        }
    }

    /** test routine */

    public static void main(String args[])
    {
        try
        {
            Parser parser = new Parser(new InputStreamReader(System.in));

            if (args.length == 0)
            {
                Map map = new HashMap();
                Map attrMap = new HashMap();
                StringBuffer buffer = new StringBuffer();

                while ((map = parser.getNext(map, attrMap,buffer)) != null)
                {
                    System.out.println("unit:" + map);
                }
            }
            else
            {
                int strategy = STRATEGY_SINGLE;

                if (args.length > 1)
                {
                    String strategyName = args[1];

                    if ("data".equals(strategyName))
                    {
                        strategy = STRATEGY_DATA;
                    }
                    else if ("none".equals(strategyName))
                    {
                        strategy = STRATEGY_NONE;
                    }
                }

                Document document = parser.buildDocument(args[0], strategy, "root", null, null);

                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                Source source = new DOMSource(document);
                Result result = new StreamResult(System.out);

                transformer.transform(source, result);
            }
        }
        catch (Exception e)
        {
            e.printStackTrace();
        }
    }

    /** Creates a DOM element with given name and attributes */

    protected Element createElement(Document document, String name, Map attribute)
    {
        Element element = document.createElement(name);

        if (attribute != null)
        {
            Iterator iterator = attribute.entrySet().iterator();

            while (iterator.hasNext())
            {
                Map.Entry entry = (Map.Entry)iterator.next();

                String attrName = (String)entry.getKey();
                String attrValue = (String)entry.getValue();

                attrName = attrName.toLowerCase();

                Attr attr = document.createAttribute(attrName);
                attr.setValue(attrValue);

                element.setAttributeNode(attr);
            }
        }

        return element;
    }

    private static void applyStrategy(List lookingAt, int strategy, int match)
    {
        for (int i = lookingAt.size(); --i > match ;)
        {
            Element element = (Element)lookingAt.get(i);

            if (strategy == STRATEGY_DATA)
            {
                List childList = new ArrayList();

                NodeList nodeList = element.getChildNodes();

                for (int j = 0; j < nodeList.getLength(); j ++)
                {
                    childList.add(nodeList.item(j));
                }

                for (int j = 0; j < childList.size(); j ++)
                {
                    Node child = (Node)childList.get(j);

                    short nodeType = child.getNodeType();

                    if (nodeType != Node.TEXT_NODE)
                    {
                        element.removeChild(child);
                        element.getParentNode().appendChild(child);
                    }
                }
            }
            else if (strategy == STRATEGY_SINGLE)
            {
                Node child;

                while ((child = element.getFirstChild()) != null)
                {
                    element.removeChild(child);
                    element.getParentNode().appendChild(child);
                }
            }
        }
    }

    public Document buildDocument(String prefix, int strategy, String rootName, Map excludeMap, Map includeMap) throws Exception
    {
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();

        Node parent = document;

        if ((rootName != null) && (!rootName.equals("")))
        {
            Element root = document.createElement(rootName);
            document.appendChild(root);
            parent = root;
        }

        List lookingAt = new ArrayList();

        Map map = new HashMap();
        Map attrMap = new HashMap();
        StringBuffer buffer = new StringBuffer();

        while ((map = getNext(map, attrMap, buffer)) != null)
        {
            String type = (String)map.get(TYPE);
            String value = (String)map.get(VALUE);
            Map attribute = (Map)map.get(ATTRIBUTE);

            String checkKey = type;

            if ((type == OPENTAG) || (type == SINGLETAG) || (type == CLOSETAG))
            {
                checkKey = value.toLowerCase();
            }

            if ((excludeMap != null) && (excludeMap.get(checkKey) != null))
            {
                continue;
            }

            if ((includeMap != null) && (includeMap.get(checkKey) == null))
            {
                continue;
            }

            if ((type == OPENTAG) || (type == SINGLETAG))
            {
                value = prefix + value.toLowerCase();

                try
                {
                    Element element = createElement(document, value, attribute);

                    parent.appendChild(element);

                    parent = element;

                    lookingAt.add(element);
                }
                catch (Exception e)
                {
                }
            }
            else if (type == CLOSETAG)
            {
                value = prefix + value.toLowerCase();

                int match = -1;
                Element matchedElement = null;

                int lookingAtSize = lookingAt.size();

                for (int i = lookingAtSize; --i >= 0 ;)
                {
                    Element element = (Element)lookingAt.get(i);

                    if (element.getTagName().equals(value))
                    {
                        match = i;
                        matchedElement = element;
                        break;
                    }
                }

                if (match >= 0)
                {
                    applyStrategy(lookingAt, strategy, match);

                    while (lookingAt.size() > match)
                    {
                        lookingAt.remove(lookingAt.size() - 1);
                    }

                    parent = matchedElement.getParentNode();
                }
            }
            else if (type == TEXT)
            {
                if (parent != document)
                {
                    Text text = document.createTextNode(value);

                    parent.appendChild(text);
                }
            }
            else if (type == COMMENT)
            {
                if (parent != document)
                {
                    Comment comment = document.createComment(value);

                    parent.appendChild(comment);
                }
            }
            else if ((type == SGML) || (type == PI))
            {
                // ignored
            }
            else
            {
                if (parent != document)
                {
                    Element element = createElement(document, type, attribute);

                    Text text = document.createTextNode(value);

                    element.appendChild(text);
                    parent.appendChild(element);
                }
            }
        }

        applyStrategy(lookingAt, strategy, -1);

        return document;
    }

  final public String SGML(StringBuffer buffer) throws ParseException {
  buffer.setLength(0);
    jj_consume_token(BEGINSGML);
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SGMLCHAR:
        ;
        break;
      default:
        jj_la1[0] = jj_gen;
        break label_1;
      }
      jj_consume_token(SGMLCHAR);
                           buffer.append(token.image);
    }
    jj_consume_token(ENDSGML);
                                                                     {if (true) return buffer.toString();}
    throw new Error("Missing return statement in function");
  }

  final public String PI(StringBuffer buffer) throws ParseException {
  buffer.setLength(0);
    jj_consume_token(BEGINPI);
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PICHAR:
        ;
        break;
      default:
        jj_la1[1] = jj_gen;
        break label_2;
      }
      jj_consume_token(PICHAR);
                       buffer.append(token.image);
    }
    jj_consume_token(ENDPI);
                                                               {if (true) return buffer.toString();}
    throw new Error("Missing return statement in function");
  }

  final public void Script(Map map, Map attrMap, StringBuffer buffer) throws ParseException {
    buffer.setLength(0);
    BeginScript(map, attrMap, buffer);
                                     buffer.setLength(0);
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SCRIPTCHAR:
        ;
        break;
      default:
        jj_la1[2] = jj_gen;
        break label_3;
      }
      jj_consume_token(SCRIPTCHAR);
                                                                          buffer.append(token.image);
    }
    jj_consume_token(ENDSCRIPT);
                                                                                                                      map.put(VALUE, buffer.toString());
  }

  final public void Style(Map map, Map attrMap, StringBuffer buffer) throws ParseException {
  buffer.setLength(0);
    BeginStyle(map, attrMap, buffer);
                                    buffer.setLength(0);
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STYLECHAR:
        ;
        break;
      default:
        jj_la1[3] = jj_gen;
        break label_4;
      }
      jj_consume_token(STYLECHAR);
                                                                        buffer.append(token.image);
    }
    jj_consume_token(ENDSTYLE);
                                                                                                                   map.put(VALUE, buffer.toString());
  }

  final public String Comment(StringBuffer buffer) throws ParseException {
  buffer.setLength(0);
    jj_consume_token(BEGINCOMMENT);
    label_5:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMENTCHAR:
        ;
        break;
      default:
        jj_la1[4] = jj_gen;
        break label_5;
      }
      jj_consume_token(COMMENTCHAR);
                                 buffer.append(token.image);
    }
    jj_consume_token(ENDCOMMENT);
                                                                              {if (true) return buffer.toString();}
    throw new Error("Missing return statement in function");
  }

  final public String DoubleQuote(StringBuffer buffer) throws ParseException {
  buffer.setLength(0);
    jj_consume_token(BEGINDOUBLEQUOTE);
    label_6:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DOUBLEQUOTEOTHER:
      case ENTITY_AElig:
      case ENTITY_Aacute:
      case ENTITY_Acirc:
      case ENTITY_Agrave:
      case ENTITY_Alpha:
      case ENTITY_Aring:
      case ENTITY_Atilde:
      case ENTITY_Auml:
      case ENTITY_Beta:
      case ENTITY_Ccedil:
      case ENTITY_Chi:
      case ENTITY_Dagger:
      case ENTITY_Delta:
      case ENTITY_ETH:
      case ENTITY_Eacute:
      case ENTITY_Ecirc:
      case ENTITY_Egrave:
      case ENTITY_Epsilon:
      case ENTITY_Eta:
      case ENTITY_Euml:
      case ENTITY_Gamma:
      case ENTITY_Iacute:
      case ENTITY_Icirc:
      case ENTITY_Igrave:
      case ENTITY_Iota:
      case ENTITY_Iuml:
      case ENTITY_Kappa:
      case ENTITY_Lambda:
      case ENTITY_Mu:
      case ENTITY_Ntilde:
      case ENTITY_Nu:
      case ENTITY_OElig:
      case ENTITY_Oacute:
      case ENTITY_Ocirc:
      case ENTITY_Ograve:
      case ENTITY_Omega:
      case ENTITY_Omicron:
      case ENTITY_Oslash:
      case ENTITY_Otilde:
      case ENTITY_Ouml:
      case ENTITY_Phi:
      case ENTITY_Pi:
      case ENTITY_Prime:
      case ENTITY_Psi:
      case ENTITY_Rho:
      case ENTITY_Scaron:
      case ENTITY_Sigma:
      case ENTITY_THORN:
      case ENTITY_Tau:
      case ENTITY_Theta:
      case ENTITY_Uacute:
      case ENTITY_Ucirc:
      case ENTITY_Ugrave:
      case ENTITY_Upsilon:
      case ENTITY_Uuml:
      case ENTITY_Xi:
      case ENTITY_Yacute:
      case ENTITY_Yuml:
      case ENTITY_Zeta:
      case ENTITY_aacute:
      case ENTITY_acirc:
      case ENTITY_acute:
      case ENTITY_aelig:
      case ENTITY_agrave:
      case ENTITY_alefsym:
      case ENTITY_alpha:
      case ENTITY_amp:
      case ENTITY_and:
      case ENTITY_ang:
      case ENTITY_aring:
      case ENTITY_asymp:
      case ENTITY_atilde:
      case ENTITY_auml:
      case ENTITY_bdquo:
      case ENTITY_beta:
      case ENTITY_brvbar:
      case ENTITY_bull:
      case ENTITY_cap:
      case ENTITY_ccedil:
      case ENTITY_cedil:
      case ENTITY_cent:
      case ENTITY_chi:
      case ENTITY_circ:
      case ENTITY_clubs:
      case ENTITY_cong:
      case ENTITY_copy:
      case ENTITY_crarr:
      case ENTITY_cup:
      case ENTITY_curren:
      case ENTITY_dArr:
      case ENTITY_dagger:
      case ENTITY_darr:
      case ENTITY_deg:
      case ENTITY_delta:
      case ENTITY_diams:
      case ENTITY_divide:
      case ENTITY_eacute:
      case ENTITY_ecirc:
      case ENTITY_egrave:
      case ENTITY_empty:
      case ENTITY_emsp:
      case ENTITY_ensp:
      case ENTITY_epsilon:
      case ENTITY_equiv:
      case ENTITY_eta:
      case ENTITY_eth:
      case ENTITY_euml:
      case ENTITY_euro:
      case ENTITY_exist:
      case ENTITY_fnof:
      case ENTITY_forall:
      case ENTITY_frac12:
      case ENTITY_frac14:
      case ENTITY_frac34:
      case ENTITY_frasl:
      case ENTITY_gamma:
      case ENTITY_ge:
      case ENTITY_gt:
      case ENTITY_hArr:
      case ENTITY_harr:
      case ENTITY_hearts:
      case ENTITY_hellip:
      case ENTITY_iacute:
      case ENTITY_icirc:
      case ENTITY_iexcl:
      case ENTITY_igrave:
      case ENTITY_image:
      case ENTITY_infin:
      case ENTITY_int:
      case ENTITY_iota:
      case ENTITY_iquest:
      case ENTITY_isin:
      case ENTITY_iuml:
      case ENTITY_kappa:
      case ENTITY_lArr:
      case ENTITY_lambda:
      case ENTITY_lang:
      case ENTITY_laquo:
      case ENTITY_larr:
      case ENTITY_lceil:
      case ENTITY_ldquo:
      case ENTITY_le:
      case ENTITY_lfloor:
      case ENTITY_lowast:
      case ENTITY_loz:
      case ENTITY_lrm:
      case ENTITY_lsaquo:
      case ENTITY_lsquo:
      case ENTITY_lt:
      case ENTITY_macr:
      case ENTITY_mdash:
      case ENTITY_micro:
      case ENTITY_middot:
      case ENTITY_minus:
      case ENTITY_mu:
      case ENTITY_nabla:
      case ENTITY_nbsp:
      case ENTITY_ndash:
      case ENTITY_ne:
      case ENTITY_ni:
      case ENTITY_not:
      case ENTITY_notin:
      case ENTITY_nsub:
      case ENTITY_ntilde:
      case ENTITY_nu:
      case ENTITY_oacute:
      case ENTITY_ocirc:
      case ENTITY_oelig:
      case ENTITY_ograve:
      case ENTITY_oline:
      case ENTITY_omega:
      case ENTITY_omicron:
      case ENTITY_oplus:
      case ENTITY_or:
      case ENTITY_ordf:
      case ENTITY_ordm:
      case ENTITY_oslash:
      case ENTITY_otilde:
      case ENTITY_otimes:
      case ENTITY_ouml:
      case ENTITY_para:
      case ENTITY_part:
      case ENTITY_permil:
      case ENTITY_perp:
      case ENTITY_phi:
      case ENTITY_pi:
      case ENTITY_piv:
      case ENTITY_plusmn:
      case ENTITY_pound:
      case ENTITY_prime:
      case ENTITY_prod:
      case ENTITY_prop:
      case ENTITY_psi:
      case ENTITY_quot:
      case ENTITY_rArr:
      case ENTITY_radic:
      case ENTITY_rang:
      case ENTITY_raquo:
      case ENTITY_rarr:
      case ENTITY_rceil:
      case ENTITY_rdquo:
      case ENTITY_real:
      case ENTITY_reg:
      case ENTITY_rfloor:
      case ENTITY_rho:
      case ENTITY_rlm:
      case ENTITY_rsaquo:
      case ENTITY_rsquo:
      case ENTITY_sbquo:
      case ENTITY_scaron:
      case ENTITY_sdot:
      case ENTITY_sect:
      case ENTITY_shy:
      case ENTITY_sigma:
      case ENTITY_sigmaf:
      case ENTITY_sim:
      case ENTITY_spades:
      case ENTITY_sub:
      case ENTITY_sube:
      case ENTITY_sum:
      case ENTITY_sup:
      case ENTITY_sup1:
      case ENTITY_sup2:
      case ENTITY_sup3:
      case ENTITY_supe:
      case ENTITY_szlig:
      case ENTITY_tau:
      case ENTITY_there4:
      case ENTITY_theta:
      case ENTITY_thetasym:
      case ENTITY_thinsp:
      case ENTITY_thorn:
      case ENTITY_tilde:
      case ENTITY_times:
      case ENTITY_trade:
      case ENTITY_uArr:
      case ENTITY_uacute:
      case ENTITY_uarr:
      case ENTITY_ucirc:
      case ENTITY_ugrave:
      case ENTITY_uml:
      case ENTITY_upsih:
      case ENTITY_upsilon:
      case ENTITY_uuml:
      case ENTITY_weierp:
      case ENTITY_xi:
      case ENTITY_yacute:
      case ENTITY_yen:
      case ENTITY_yuml:
      case ENTITY_zeta:
      case ENTITY_zwj:
      case ENTITY_zwnj:
      case ENTITY_NUMERIC:
        ;
        break;
      default:
        jj_la1[5] = jj_gen;
        break label_6;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DOUBLEQUOTEOTHER:
        jj_consume_token(DOUBLEQUOTEOTHER);
                                          buffer.append(token.image);
        break;
      case ENTITY_AElig:
      case ENTITY_Aacute:
      case ENTITY_Acirc:
      case ENTITY_Agrave:
      case ENTITY_Alpha:
      case ENTITY_Aring:
      case ENTITY_Atilde:
      case ENTITY_Auml:
      case ENTITY_Beta:
      case ENTITY_Ccedil:
      case ENTITY_Chi:
      case ENTITY_Dagger:
      case ENTITY_Delta:
      case ENTITY_ETH:
      case ENTITY_Eacute:
      case ENTITY_Ecirc:
      case ENTITY_Egrave:
      case ENTITY_Epsilon:
      case ENTITY_Eta:
      case ENTITY_Euml:
      case ENTITY_Gamma:
      case ENTITY_Iacute:
      case ENTITY_Icirc:
      case ENTITY_Igrave:
      case ENTITY_Iota:
      case ENTITY_Iuml:
      case ENTITY_Kappa:
      case ENTITY_Lambda:
      case ENTITY_Mu:
      case ENTITY_Ntilde:
      case ENTITY_Nu:
      case ENTITY_OElig:
      case ENTITY_Oacute:
      case ENTITY_Ocirc:
      case ENTITY_Ograve:
      case ENTITY_Omega:
      case ENTITY_Omicron:
      case ENTITY_Oslash:
      case ENTITY_Otilde:
      case ENTITY_Ouml:
      case ENTITY_Phi:
      case ENTITY_Pi:
      case ENTITY_Prime:
      case ENTITY_Psi:
      case ENTITY_Rho:
      case ENTITY_Scaron:
      case ENTITY_Sigma:
      case ENTITY_THORN:
      case ENTITY_Tau:
      case ENTITY_Theta:
      case ENTITY_Uacute:
      case ENTITY_Ucirc:
      case ENTITY_Ugrave:
      case ENTITY_Upsilon:
      case ENTITY_Uuml:
      case ENTITY_Xi:
      case ENTITY_Yacute:
      case ENTITY_Yuml:
      case ENTITY_Zeta:
      case ENTITY_aacute:
      case ENTITY_acirc:
      case ENTITY_acute:
      case ENTITY_aelig:
      case ENTITY_agrave:
      case ENTITY_alefsym:
      case ENTITY_alpha:
      case ENTITY_amp:
      case ENTITY_and:
      case ENTITY_ang:
      case ENTITY_aring:
      case ENTITY_asymp:
      case ENTITY_atilde:
      case ENTITY_auml:
      case ENTITY_bdquo:
      case ENTITY_beta:
      case ENTITY_brvbar:
      case ENTITY_bull:
      case ENTITY_cap:
      case ENTITY_ccedil:
      case ENTITY_cedil:
      case ENTITY_cent:
      case ENTITY_chi:
      case ENTITY_circ:
      case ENTITY_clubs:
      case ENTITY_cong:
      case ENTITY_copy:
      case ENTITY_crarr:
      case ENTITY_cup:
      case ENTITY_curren:
      case ENTITY_dArr:
      case ENTITY_dagger:
      case ENTITY_darr:
      case ENTITY_deg:
      case ENTITY_delta:
      case ENTITY_diams:
      case ENTITY_divide:
      case ENTITY_eacute:
      case ENTITY_ecirc:
      case ENTITY_egrave:
      case ENTITY_empty:
      case ENTITY_emsp:
      case ENTITY_ensp:
      case ENTITY_epsilon:
      case ENTITY_equiv:
      case ENTITY_eta:
      case ENTITY_eth:
      case ENTITY_euml:
      case ENTITY_euro:
      case ENTITY_exist:
      case ENTITY_fnof:
      case ENTITY_forall:
      case ENTITY_frac12:
      case ENTITY_frac14:
      case ENTITY_frac34:
      case ENTITY_frasl:
      case ENTITY_gamma:
      case ENTITY_ge:
      case ENTITY_gt:
      case ENTITY_hArr:
      case ENTITY_harr:
      case ENTITY_hearts:
      case ENTITY_hellip:
      case ENTITY_iacute:
      case ENTITY_icirc:
      case ENTITY_iexcl:
      case ENTITY_igrave:
      case ENTITY_image:
      case ENTITY_infin:
      case ENTITY_int:
      case ENTITY_iota:
      case ENTITY_iquest:
      case ENTITY_isin:
      case ENTITY_iuml:
      case ENTITY_kappa:
      case ENTITY_lArr:
      case ENTITY_lambda:
      case ENTITY_lang:
      case ENTITY_laquo:
      case ENTITY_larr:
      case ENTITY_lceil:
      case ENTITY_ldquo:
      case ENTITY_le:
      case ENTITY_lfloor:
      case ENTITY_lowast:
      case ENTITY_loz:
      case ENTITY_lrm:
      case ENTITY_lsaquo:
      case ENTITY_lsquo:
      case ENTITY_lt:
      case ENTITY_macr:
      case ENTITY_mdash:
      case ENTITY_micro:
      case ENTITY_middot:
      case ENTITY_minus:
      case ENTITY_mu:
      case ENTITY_nabla:
      case ENTITY_nbsp:
      case ENTITY_ndash:
      case ENTITY_ne:
      case ENTITY_ni:
      case ENTITY_not:
      case ENTITY_notin:
      case ENTITY_nsub:
      case ENTITY_ntilde:
      case ENTITY_nu:
      case ENTITY_oacute:
      case ENTITY_ocirc:
      case ENTITY_oelig:
      case ENTITY_ograve:
      case ENTITY_oline:
      case ENTITY_omega:
      case ENTITY_omicron:
      case ENTITY_oplus:
      case ENTITY_or:
      case ENTITY_ordf:
      case ENTITY_ordm:
      case ENTITY_oslash:
      case ENTITY_otilde:
      case ENTITY_otimes:
      case ENTITY_ouml:
      case ENTITY_para:
      case ENTITY_part:
      case ENTITY_permil:
      case ENTITY_perp:
      case ENTITY_phi:
      case ENTITY_pi:
      case ENTITY_piv:
      case ENTITY_plusmn:
      case ENTITY_pound:
      case ENTITY_prime:
      case ENTITY_prod:
      case ENTITY_prop:
      case ENTITY_psi:
      case ENTITY_quot:
      case ENTITY_rArr:
      case ENTITY_radic:
      case ENTITY_rang:
      case ENTITY_raquo:
      case ENTITY_rarr:
      case ENTITY_rceil:
      case ENTITY_rdquo:
      case ENTITY_real:
      case ENTITY_reg:
      case ENTITY_rfloor:
      case ENTITY_rho:
      case ENTITY_rlm:
      case ENTITY_rsaquo:
      case ENTITY_rsquo:
      case ENTITY_sbquo:
      case ENTITY_scaron:
      case ENTITY_sdot:
      case ENTITY_sect:
      case ENTITY_shy:
      case ENTITY_sigma:
      case ENTITY_sigmaf:
      case ENTITY_sim:
      case ENTITY_spades:
      case ENTITY_sub:
      case ENTITY_sube:
      case ENTITY_sum:
      case ENTITY_sup:
      case ENTITY_sup1:
      case ENTITY_sup2:
      case ENTITY_sup3:
      case ENTITY_supe:
      case ENTITY_szlig:
      case ENTITY_tau:
      case ENTITY_there4:
      case ENTITY_theta:
      case ENTITY_thetasym:
      case ENTITY_thinsp:
      case ENTITY_thorn:
      case ENTITY_tilde:
      case ENTITY_times:
      case ENTITY_trade:
      case ENTITY_uArr:
      case ENTITY_uacute:
      case ENTITY_uarr:
      case ENTITY_ucirc:
      case ENTITY_ugrave:
      case ENTITY_uml:
      case ENTITY_upsih:
      case ENTITY_upsilon:
      case ENTITY_uuml:
      case ENTITY_weierp:
      case ENTITY_xi:
      case ENTITY_yacute:
      case ENTITY_yen:
      case ENTITY_yuml:
      case ENTITY_zeta:
      case ENTITY_zwj:
      case ENTITY_zwnj:
      case ENTITY_NUMERIC:
        Entity();
                                                                                   buffer.append(token.image);
        break;
      default:
        jj_la1[6] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(ENDDOUBLEQUOTE);
                                                                                                                                    {if (true) return buffer.toString();}
    throw new Error("Missing return statement in function");
  }

  final public String SingleQuote(StringBuffer buffer) throws ParseException {
  buffer.setLength(0);
    jj_consume_token(BEGINSINGLEQUOTE);
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SINGLEQUOTEOTHER:
      case ENTITY_AElig:
      case ENTITY_Aacute:
      case ENTITY_Acirc:
      case ENTITY_Agrave:
      case ENTITY_Alpha:
      case ENTITY_Aring:
      case ENTITY_Atilde:
      case ENTITY_Auml:
      case ENTITY_Beta:
      case ENTITY_Ccedil:
      case ENTITY_Chi:
      case ENTITY_Dagger:
      case ENTITY_Delta:
      case ENTITY_ETH:
      case ENTITY_Eacute:
      case ENTITY_Ecirc:
      case ENTITY_Egrave:
      case ENTITY_Epsilon:
      case ENTITY_Eta:
      case ENTITY_Euml:
      case ENTITY_Gamma:
      case ENTITY_Iacute:
      case ENTITY_Icirc:
      case ENTITY_Igrave:
      case ENTITY_Iota:
      case ENTITY_Iuml:
      case ENTITY_Kappa:
      case ENTITY_Lambda:
      case ENTITY_Mu:
      case ENTITY_Ntilde:
      case ENTITY_Nu:
      case ENTITY_OElig:
      case ENTITY_Oacute:
      case ENTITY_Ocirc:
      case ENTITY_Ograve:
      case ENTITY_Omega:
      case ENTITY_Omicron:
      case ENTITY_Oslash:
      case ENTITY_Otilde:
      case ENTITY_Ouml:
      case ENTITY_Phi:
      case ENTITY_Pi:
      case ENTITY_Prime:
      case ENTITY_Psi:
      case ENTITY_Rho:
      case ENTITY_Scaron:
      case ENTITY_Sigma:
      case ENTITY_THORN:
      case ENTITY_Tau:
      case ENTITY_Theta:
      case ENTITY_Uacute:
      case ENTITY_Ucirc:
      case ENTITY_Ugrave:
      case ENTITY_Upsilon:
      case ENTITY_Uuml:
      case ENTITY_Xi:
      case ENTITY_Yacute:
      case ENTITY_Yuml:
      case ENTITY_Zeta:
      case ENTITY_aacute:
      case ENTITY_acirc:
      case ENTITY_acute:
      case ENTITY_aelig:
      case ENTITY_agrave:
      case ENTITY_alefsym:
      case ENTITY_alpha:
      case ENTITY_amp:
      case ENTITY_and:
      case ENTITY_ang:
      case ENTITY_aring:
      case ENTITY_asymp:
      case ENTITY_atilde:
      case ENTITY_auml:
      case ENTITY_bdquo:
      case ENTITY_beta:
      case ENTITY_brvbar:
      case ENTITY_bull:
      case ENTITY_cap:
      case ENTITY_ccedil:
      case ENTITY_cedil:
      case ENTITY_cent:
      case ENTITY_chi:
      case ENTITY_circ:
      case ENTITY_clubs:
      case ENTITY_cong:
      case ENTITY_copy:
      case ENTITY_crarr:
      case ENTITY_cup:
      case ENTITY_curren:
      case ENTITY_dArr:
      case ENTITY_dagger:
      case ENTITY_darr:
      case ENTITY_deg:
      case ENTITY_delta:
      case ENTITY_diams:
      case ENTITY_divide:
      case ENTITY_eacute:
      case ENTITY_ecirc:
      case ENTITY_egrave:
      case ENTITY_empty:
      case ENTITY_emsp:
      case ENTITY_ensp:
      case ENTITY_epsilon:
      case ENTITY_equiv:
      case ENTITY_eta:
      case ENTITY_eth:
      case ENTITY_euml:
      case ENTITY_euro:
      case ENTITY_exist:
      case ENTITY_fnof:
      case ENTITY_forall:
      case ENTITY_frac12:
      case ENTITY_frac14:
      case ENTITY_frac34:
      case ENTITY_frasl:
      case ENTITY_gamma:
      case ENTITY_ge:
      case ENTITY_gt:
      case ENTITY_hArr:
      case ENTITY_harr:
      case ENTITY_hearts:
      case ENTITY_hellip:
      case ENTITY_iacute:
      case ENTITY_icirc:
      case ENTITY_iexcl:
      case ENTITY_igrave:
      case ENTITY_image:
      case ENTITY_infin:
      case ENTITY_int:
      case ENTITY_iota:
      case ENTITY_iquest:
      case ENTITY_isin:
      case ENTITY_iuml:
      case ENTITY_kappa:
      case ENTITY_lArr:
      case ENTITY_lambda:
      case ENTITY_lang:
      case ENTITY_laquo:
      case ENTITY_larr:
      case ENTITY_lceil:
      case ENTITY_ldquo:
      case ENTITY_le:
      case ENTITY_lfloor:
      case ENTITY_lowast:
      case ENTITY_loz:
      case ENTITY_lrm:
      case ENTITY_lsaquo:
      case ENTITY_lsquo:
      case ENTITY_lt:
      case ENTITY_macr:
      case ENTITY_mdash:
      case ENTITY_micro:
      case ENTITY_middot:
      case ENTITY_minus:
      case ENTITY_mu:
      case ENTITY_nabla:
      case ENTITY_nbsp:
      case ENTITY_ndash:
      case ENTITY_ne:
      case ENTITY_ni:
      case ENTITY_not:
      case ENTITY_notin:
      case ENTITY_nsub:
      case ENTITY_ntilde:
      case ENTITY_nu:
      case ENTITY_oacute:
      case ENTITY_ocirc:
      case ENTITY_oelig:
      case ENTITY_ograve:
      case ENTITY_oline:
      case ENTITY_omega:
      case ENTITY_omicron:
      case ENTITY_oplus:
      case ENTITY_or:
      case ENTITY_ordf:
      case ENTITY_ordm:
      case ENTITY_oslash:
      case ENTITY_otilde:
      case ENTITY_otimes:
      case ENTITY_ouml:
      case ENTITY_para:
      case ENTITY_part:
      case ENTITY_permil:
      case ENTITY_perp:
      case ENTITY_phi:
      case ENTITY_pi:
      case ENTITY_piv:
      case ENTITY_plusmn:
      case ENTITY_pound:
      case ENTITY_prime:
      case ENTITY_prod:
      case ENTITY_prop:
      case ENTITY_psi:
      case ENTITY_quot:
      case ENTITY_rArr:
      case ENTITY_radic:
      case ENTITY_rang:
      case ENTITY_raquo:
      case ENTITY_rarr:
      case ENTITY_rceil:
      case ENTITY_rdquo:
      case ENTITY_real:
      case ENTITY_reg:
      case ENTITY_rfloor:
      case ENTITY_rho:
      case ENTITY_rlm:
      case ENTITY_rsaquo:
      case ENTITY_rsquo:
      case ENTITY_sbquo:
      case ENTITY_scaron:
      case ENTITY_sdot:
      case ENTITY_sect:
      case ENTITY_shy:
      case ENTITY_sigma:
      case ENTITY_sigmaf:
      case ENTITY_sim:
      case ENTITY_spades:
      case ENTITY_sub:
      case ENTITY_sube:
      case ENTITY_sum:
      case ENTITY_sup:
      case ENTITY_sup1:
      case ENTITY_sup2:
      case ENTITY_sup3:
      case ENTITY_supe:
      case ENTITY_szlig:
      case ENTITY_tau:
      case ENTITY_there4:
      case ENTITY_theta:
      case ENTITY_thetasym:
      case ENTITY_thinsp:
      case ENTITY_thorn:
      case ENTITY_tilde:
      case ENTITY_times:
      case ENTITY_trade:
      case ENTITY_uArr:
      case ENTITY_uacute:
      case ENTITY_uarr:
      case ENTITY_ucirc:
      case ENTITY_ugrave:
      case ENTITY_uml:
      case ENTITY_upsih:
      case ENTITY_upsilon:
      case ENTITY_uuml:
      case ENTITY_weierp:
      case ENTITY_xi:
      case ENTITY_yacute:
      case ENTITY_yen:
      case ENTITY_yuml:
      case ENTITY_zeta:
      case ENTITY_zwj:
      case ENTITY_zwnj:
      case ENTITY_NUMERIC:
        ;
        break;
      default:
        jj_la1[7] = jj_gen;
        break label_7;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SINGLEQUOTEOTHER:
        jj_consume_token(SINGLEQUOTEOTHER);
                                          buffer.append(token.image);
        break;
      case ENTITY_AElig:
      case ENTITY_Aacute:
      case ENTITY_Acirc:
      case ENTITY_Agrave:
      case ENTITY_Alpha:
      case ENTITY_Aring:
      case ENTITY_Atilde:
      case ENTITY_Auml:
      case ENTITY_Beta:
      case ENTITY_Ccedil:
      case ENTITY_Chi:
      case ENTITY_Dagger:
      case ENTITY_Delta:
      case ENTITY_ETH:
      case ENTITY_Eacute:
      case ENTITY_Ecirc:
      case ENTITY_Egrave:
      case ENTITY_Epsilon:
      case ENTITY_Eta:
      case ENTITY_Euml:
      case ENTITY_Gamma:
      case ENTITY_Iacute:
      case ENTITY_Icirc:
      case ENTITY_Igrave:
      case ENTITY_Iota:
      case ENTITY_Iuml:
      case ENTITY_Kappa:
      case ENTITY_Lambda:
      case ENTITY_Mu:
      case ENTITY_Ntilde:
      case ENTITY_Nu:
      case ENTITY_OElig:
      case ENTITY_Oacute:
      case ENTITY_Ocirc:
      case ENTITY_Ograve:
      case ENTITY_Omega:
      case ENTITY_Omicron:
      case ENTITY_Oslash:
      case ENTITY_Otilde:
      case ENTITY_Ouml:
      case ENTITY_Phi:
      case ENTITY_Pi:
      case ENTITY_Prime:
      case ENTITY_Psi:
      case ENTITY_Rho:
      case ENTITY_Scaron:
      case ENTITY_Sigma:
      case ENTITY_THORN:
      case ENTITY_Tau:
      case ENTITY_Theta:
      case ENTITY_Uacute:
      case ENTITY_Ucirc:
      case ENTITY_Ugrave:
      case ENTITY_Upsilon:
      case ENTITY_Uuml:
      case ENTITY_Xi:
      case ENTITY_Yacute:
      case ENTITY_Yuml:
      case ENTITY_Zeta:
      case ENTITY_aacute:
      case ENTITY_acirc:
      case ENTITY_acute:
      case ENTITY_aelig:
      case ENTITY_agrave:
      case ENTITY_alefsym:
      case ENTITY_alpha:
      case ENTITY_amp:
      case ENTITY_and:
      case ENTITY_ang:
      case ENTITY_aring:
      case ENTITY_asymp:
      case ENTITY_atilde:
      case ENTITY_auml:
      case ENTITY_bdquo:
      case ENTITY_beta:
      case ENTITY_brvbar:
      case ENTITY_bull:
      case ENTITY_cap:
      case ENTITY_ccedil:
      case ENTITY_cedil:
      case ENTITY_cent:
      case ENTITY_chi:
      case ENTITY_circ:
      case ENTITY_clubs:
      case ENTITY_cong:
      case ENTITY_copy:
      case ENTITY_crarr:
      case ENTITY_cup:
      case ENTITY_curren:
      case ENTITY_dArr:
      case ENTITY_dagger:
      case ENTITY_darr:
      case ENTITY_deg:
      case ENTITY_delta:
      case ENTITY_diams:
      case ENTITY_divide:
      case ENTITY_eacute:
      case ENTITY_ecirc:
      case ENTITY_egrave:
      case ENTITY_empty:
      case ENTITY_emsp:
      case ENTITY_ensp:
      case ENTITY_epsilon:
      case ENTITY_equiv:
      case ENTITY_eta:
      case ENTITY_eth:
      case ENTITY_euml:
      case ENTITY_euro:
      case ENTITY_exist:
      case ENTITY_fnof:
      case ENTITY_forall:
      case ENTITY_frac12:
      case ENTITY_frac14:
      case ENTITY_frac34:
      case ENTITY_frasl:
      case ENTITY_gamma:
      case ENTITY_ge:
      case ENTITY_gt:
      case ENTITY_hArr:
      case ENTITY_harr:
      case ENTITY_hearts:
      case ENTITY_hellip:
      case ENTITY_iacute:
      case ENTITY_icirc:
      case ENTITY_iexcl:
      case ENTITY_igrave:
      case ENTITY_image:
      case ENTITY_infin:
      case ENTITY_int:
      case ENTITY_iota:
      case ENTITY_iquest:
      case ENTITY_isin:
      case ENTITY_iuml:
      case ENTITY_kappa:
      case ENTITY_lArr:
      case ENTITY_lambda:
      case ENTITY_lang:
      case ENTITY_laquo:
      case ENTITY_larr:
      case ENTITY_lceil:
      case ENTITY_ldquo:
      case ENTITY_le:
      case ENTITY_lfloor:
      case ENTITY_lowast:
      case ENTITY_loz:
      case ENTITY_lrm:
      case ENTITY_lsaquo:
      case ENTITY_lsquo:
      case ENTITY_lt:
      case ENTITY_macr:
      case ENTITY_mdash:
      case ENTITY_micro:
      case ENTITY_middot:
      case ENTITY_minus:
      case ENTITY_mu:
      case ENTITY_nabla:
      case ENTITY_nbsp:
      case ENTITY_ndash:
      case ENTITY_ne:
      case ENTITY_ni:
      case ENTITY_not:
      case ENTITY_notin:
      case ENTITY_nsub:
      case ENTITY_ntilde:
      case ENTITY_nu:
      case ENTITY_oacute:
      case ENTITY_ocirc:
      case ENTITY_oelig:
      case ENTITY_ograve:
      case ENTITY_oline:
      case ENTITY_omega:
      case ENTITY_omicron:
      case ENTITY_oplus:
      case ENTITY_or:
      case ENTITY_ordf:
      case ENTITY_ordm:
      case ENTITY_oslash:
      case ENTITY_otilde:
      case ENTITY_otimes:
      case ENTITY_ouml:
      case ENTITY_para:
      case ENTITY_part:
      case ENTITY_permil:
      case ENTITY_perp:
      case ENTITY_phi:
      case ENTITY_pi:
      case ENTITY_piv:
      case ENTITY_plusmn:
      case ENTITY_pound:
      case ENTITY_prime:
      case ENTITY_prod:
      case ENTITY_prop:
      case ENTITY_psi:
      case ENTITY_quot:
      case ENTITY_rArr:
      case ENTITY_radic:
      case ENTITY_rang:
      case ENTITY_raquo:
      case ENTITY_rarr:
      case ENTITY_rceil:
      case ENTITY_rdquo:
      case ENTITY_real:
      case ENTITY_reg:
      case ENTITY_rfloor:
      case ENTITY_rho:
      case ENTITY_rlm:
      case ENTITY_rsaquo:
      case ENTITY_rsquo:
      case ENTITY_sbquo:
      case ENTITY_scaron:
      case ENTITY_sdot:
      case ENTITY_sect:
      case ENTITY_shy:
      case ENTITY_sigma:
      case ENTITY_sigmaf:
      case ENTITY_sim:
      case ENTITY_spades:
      case ENTITY_sub:
      case ENTITY_sube:
      case ENTITY_sum:
      case ENTITY_sup:
      case ENTITY_sup1:
      case ENTITY_sup2:
      case ENTITY_sup3:
      case ENTITY_supe:
      case ENTITY_szlig:
      case ENTITY_tau:
      case ENTITY_there4:
      case ENTITY_theta:
      case ENTITY_thetasym:
      case ENTITY_thinsp:
      case ENTITY_thorn:
      case ENTITY_tilde:
      case ENTITY_times:
      case ENTITY_trade:
      case ENTITY_uArr:
      case ENTITY_uacute:
      case ENTITY_uarr:
      case ENTITY_ucirc:
      case ENTITY_ugrave:
      case ENTITY_uml:
      case ENTITY_upsih:
      case ENTITY_upsilon:
      case ENTITY_uuml:
      case ENTITY_weierp:
      case ENTITY_xi:
      case ENTITY_yacute:
      case ENTITY_yen:
      case ENTITY_yuml:
      case ENTITY_zeta:
      case ENTITY_zwj:
      case ENTITY_zwnj:
      case ENTITY_NUMERIC:
        Entity();
                                                                                   buffer.append(token.image);
        break;
      default:
        jj_la1[8] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(ENDSINGLEQUOTE);
                                                                                                                                    {if (true) return buffer.toString();}
    throw new Error("Missing return statement in function");
  }

  final public String Label(StringBuffer buffer) throws ParseException {
  buffer.setLength(0);
    label_8:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TAGOTHER:
        jj_consume_token(TAGOTHER);
                             buffer.append(token.image);
        break;
      case ENTITY_AElig:
      case ENTITY_Aacute:
      case ENTITY_Acirc:
      case ENTITY_Agrave:
      case ENTITY_Alpha:
      case ENTITY_Aring:
      case ENTITY_Atilde:
      case ENTITY_Auml:
      case ENTITY_Beta:
      case ENTITY_Ccedil:
      case ENTITY_Chi:
      case ENTITY_Dagger:
      case ENTITY_Delta:
      case ENTITY_ETH:
      case ENTITY_Eacute:
      case ENTITY_Ecirc:
      case ENTITY_Egrave:
      case ENTITY_Epsilon:
      case ENTITY_Eta:
      case ENTITY_Euml:
      case ENTITY_Gamma:
      case ENTITY_Iacute:
      case ENTITY_Icirc:
      case ENTITY_Igrave:
      case ENTITY_Iota:
      case ENTITY_Iuml:
      case ENTITY_Kappa:
      case ENTITY_Lambda:
      case ENTITY_Mu:
      case ENTITY_Ntilde:
      case ENTITY_Nu:
      case ENTITY_OElig:
      case ENTITY_Oacute:
      case ENTITY_Ocirc:
      case ENTITY_Ograve:
      case ENTITY_Omega:
      case ENTITY_Omicron:
      case ENTITY_Oslash:
      case ENTITY_Otilde:
      case ENTITY_Ouml:
      case ENTITY_Phi:
      case ENTITY_Pi:
      case ENTITY_Prime:
      case ENTITY_Psi:
      case ENTITY_Rho:
      case ENTITY_Scaron:
      case ENTITY_Sigma:
      case ENTITY_THORN:
      case ENTITY_Tau:
      case ENTITY_Theta:
      case ENTITY_Uacute:
      case ENTITY_Ucirc:
      case ENTITY_Ugrave:
      case ENTITY_Upsilon:
      case ENTITY_Uuml:
      case ENTITY_Xi:
      case ENTITY_Yacute:
      case ENTITY_Yuml:
      case ENTITY_Zeta:
      case ENTITY_aacute:
      case ENTITY_acirc:
      case ENTITY_acute:
      case ENTITY_aelig:
      case ENTITY_agrave:
      case ENTITY_alefsym:
      case ENTITY_alpha:
      case ENTITY_amp:
      case ENTITY_and:
      case ENTITY_ang:
      case ENTITY_aring:
      case ENTITY_asymp:
      case ENTITY_atilde:
      case ENTITY_auml:
      case ENTITY_bdquo:
      case ENTITY_beta:
      case ENTITY_brvbar:
      case ENTITY_bull:
      case ENTITY_cap:
      case ENTITY_ccedil:
      case ENTITY_cedil:
      case ENTITY_cent:
      case ENTITY_chi:
      case ENTITY_circ:
      case ENTITY_clubs:
      case ENTITY_cong:
      case ENTITY_copy:
      case ENTITY_crarr:
      case ENTITY_cup:
      case ENTITY_curren:
      case ENTITY_dArr:
      case ENTITY_dagger:
      case ENTITY_darr:
      case ENTITY_deg:
      case ENTITY_delta:
      case ENTITY_diams:
      case ENTITY_divide:
      case ENTITY_eacute:
      case ENTITY_ecirc:
      case ENTITY_egrave:
      case ENTITY_empty:
      case ENTITY_emsp:
      case ENTITY_ensp:
      case ENTITY_epsilon:
      case ENTITY_equiv:
      case ENTITY_eta:
      case ENTITY_eth:
      case ENTITY_euml:
      case ENTITY_euro:
      case ENTITY_exist:
      case ENTITY_fnof:
      case ENTITY_forall:
      case ENTITY_frac12:
      case ENTITY_frac14:
      case ENTITY_frac34:
      case ENTITY_frasl:
      case ENTITY_gamma:
      case ENTITY_ge:
      case ENTITY_gt:
      case ENTITY_hArr:
      case ENTITY_harr:
      case ENTITY_hearts:
      case ENTITY_hellip:
      case ENTITY_iacute:
      case ENTITY_icirc:
      case ENTITY_iexcl:
      case ENTITY_igrave:
      case ENTITY_image:
      case ENTITY_infin:
      case ENTITY_int:
      case ENTITY_iota:
      case ENTITY_iquest:
      case ENTITY_isin:
      case ENTITY_iuml:
      case ENTITY_kappa:
      case ENTITY_lArr:
      case ENTITY_lambda:
      case ENTITY_lang:
      case ENTITY_laquo:
      case ENTITY_larr:
      case ENTITY_lceil:
      case ENTITY_ldquo:
      case ENTITY_le:
      case ENTITY_lfloor:
      case ENTITY_lowast:
      case ENTITY_loz:
      case ENTITY_lrm:
      case ENTITY_lsaquo:
      case ENTITY_lsquo:
      case ENTITY_lt:
      case ENTITY_macr:
      case ENTITY_mdash:
      case ENTITY_micro:
      case ENTITY_middot:
      case ENTITY_minus:
      case ENTITY_mu:
      case ENTITY_nabla:
      case ENTITY_nbsp:
      case ENTITY_ndash:
      case ENTITY_ne:
      case ENTITY_ni:
      case ENTITY_not:
      case ENTITY_notin:
      case ENTITY_nsub:
      case ENTITY_ntilde:
      case ENTITY_nu:
      case ENTITY_oacute:
      case ENTITY_ocirc:
      case ENTITY_oelig:
      case ENTITY_ograve:
      case ENTITY_oline:
      case ENTITY_omega:
      case ENTITY_omicron:
      case ENTITY_oplus:
      case ENTITY_or:
      case ENTITY_ordf:
      case ENTITY_ordm:
      case ENTITY_oslash:
      case ENTITY_otilde:
      case ENTITY_otimes:
      case ENTITY_ouml:
      case ENTITY_para:
      case ENTITY_part:
      case ENTITY_permil:
      case ENTITY_perp:
      case ENTITY_phi:
      case ENTITY_pi:
      case ENTITY_piv:
      case ENTITY_plusmn:
      case ENTITY_pound:
      case ENTITY_prime:
      case ENTITY_prod:
      case ENTITY_prop:
      case ENTITY_psi:
      case ENTITY_quot:
      case ENTITY_rArr:
      case ENTITY_radic:
      case ENTITY_rang:
      case ENTITY_raquo:
      case ENTITY_rarr:
      case ENTITY_rceil:
      case ENTITY_rdquo:
      case ENTITY_real:
      case ENTITY_reg:
      case ENTITY_rfloor:
      case ENTITY_rho:
      case ENTITY_rlm:
      case ENTITY_rsaquo:
      case ENTITY_rsquo:
      case ENTITY_sbquo:
      case ENTITY_scaron:
      case ENTITY_sdot:
      case ENTITY_sect:
      case ENTITY_shy:
      case ENTITY_sigma:
      case ENTITY_sigmaf:
      case ENTITY_sim:
      case ENTITY_spades:
      case ENTITY_sub:
      case ENTITY_sube:
      case ENTITY_sum:
      case ENTITY_sup:
      case ENTITY_sup1:
      case ENTITY_sup2:
      case ENTITY_sup3:
      case ENTITY_supe:
      case ENTITY_szlig:
      case ENTITY_tau:
      case ENTITY_there4:
      case ENTITY_theta:
      case ENTITY_thetasym:
      case ENTITY_thinsp:
      case ENTITY_thorn:
      case ENTITY_tilde:
      case ENTITY_times:
      case ENTITY_trade:
      case ENTITY_uArr:
      case ENTITY_uacute:
      case ENTITY_uarr:
      case ENTITY_ucirc:
      case ENTITY_ugrave:
      case ENTITY_uml:
      case ENTITY_upsih:
      case ENTITY_upsilon:
      case ENTITY_uuml:
      case ENTITY_weierp:
      case ENTITY_xi:
      case ENTITY_yacute:
      case ENTITY_yen:
      case ENTITY_yuml:
      case ENTITY_zeta:
      case ENTITY_zwj:
      case ENTITY_zwnj:
      case ENTITY_NUMERIC:
        Entity();
                                                                      buffer.append(token.image);
        break;
      default:
        jj_la1[9] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      if (jj_2_1(2)) {
        ;
      } else {
        break label_8;
      }
    }
                                                                                                       {if (true) return buffer.toString();}
    throw new Error("Missing return statement in function");
  }

  final public String AttrValue(StringBuffer buffer) throws ParseException {
  buffer.setLength(0);
    label_9:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EQUAL:
      case TAGOTHER:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case TAGOTHER:
          jj_consume_token(TAGOTHER);
          break;
        case EQUAL:
          jj_consume_token(EQUAL);
          break;
        default:
          jj_la1[10] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
                                         buffer.append(token.image);
        break;
      case ENTITY_AElig:
      case ENTITY_Aacute:
      case ENTITY_Acirc:
      case ENTITY_Agrave:
      case ENTITY_Alpha:
      case ENTITY_Aring:
      case ENTITY_Atilde:
      case ENTITY_Auml:
      case ENTITY_Beta:
      case ENTITY_Ccedil:
      case ENTITY_Chi:
      case ENTITY_Dagger:
      case ENTITY_Delta:
      case ENTITY_ETH:
      case ENTITY_Eacute:
      case ENTITY_Ecirc:
      case ENTITY_Egrave:
      case ENTITY_Epsilon:
      case ENTITY_Eta:
      case ENTITY_Euml:
      case ENTITY_Gamma:
      case ENTITY_Iacute:
      case ENTITY_Icirc:
      case ENTITY_Igrave:
      case ENTITY_Iota:
      case ENTITY_Iuml:
      case ENTITY_Kappa:
      case ENTITY_Lambda:
      case ENTITY_Mu:
      case ENTITY_Ntilde:
      case ENTITY_Nu:
      case ENTITY_OElig:
      case ENTITY_Oacute:
      case ENTITY_Ocirc:
      case ENTITY_Ograve:
      case ENTITY_Omega:
      case ENTITY_Omicron:
      case ENTITY_Oslash:
      case ENTITY_Otilde:
      case ENTITY_Ouml:
      case ENTITY_Phi:
      case ENTITY_Pi:
      case ENTITY_Prime:
      case ENTITY_Psi:
      case ENTITY_Rho:
      case ENTITY_Scaron:
      case ENTITY_Sigma:
      case ENTITY_THORN:
      case ENTITY_Tau:
      case ENTITY_Theta:
      case ENTITY_Uacute:
      case ENTITY_Ucirc:
      case ENTITY_Ugrave:
      case ENTITY_Upsilon:
      case ENTITY_Uuml:
      case ENTITY_Xi:
      case ENTITY_Yacute:
      case ENTITY_Yuml:
      case ENTITY_Zeta:
      case ENTITY_aacute:
      case ENTITY_acirc:
      case ENTITY_acute:
      case ENTITY_aelig:
      case ENTITY_agrave:
      case ENTITY_alefsym:
      case ENTITY_alpha:
      case ENTITY_amp:
      case ENTITY_and:
      case ENTITY_ang:
      case ENTITY_aring:
      case ENTITY_asymp:
      case ENTITY_atilde:
      case ENTITY_auml:
      case ENTITY_bdquo:
      case ENTITY_beta:
      case ENTITY_brvbar:
      case ENTITY_bull:
      case ENTITY_cap:
      case ENTITY_ccedil:
      case ENTITY_cedil:
      case ENTITY_cent:
      case ENTITY_chi:
      case ENTITY_circ:
      case ENTITY_clubs:
      case ENTITY_cong:
      case ENTITY_copy:
      case ENTITY_crarr:
      case ENTITY_cup:
      case ENTITY_curren:
      case ENTITY_dArr:
      case ENTITY_dagger:
      case ENTITY_darr:
      case ENTITY_deg:
      case ENTITY_delta:
      case ENTITY_diams:
      case ENTITY_divide:
      case ENTITY_eacute:
      case ENTITY_ecirc:
      case ENTITY_egrave:
      case ENTITY_empty:
      case ENTITY_emsp:
      case ENTITY_ensp:
      case ENTITY_epsilon:
      case ENTITY_equiv:
      case ENTITY_eta:
      case ENTITY_eth:
      case ENTITY_euml:
      case ENTITY_euro:
      case ENTITY_exist:
      case ENTITY_fnof:
      case ENTITY_forall:
      case ENTITY_frac12:
      case ENTITY_frac14:
      case ENTITY_frac34:
      case ENTITY_frasl:
      case ENTITY_gamma:
      case ENTITY_ge:
      case ENTITY_gt:
      case ENTITY_hArr:
      case ENTITY_harr:
      case ENTITY_hearts:
      case ENTITY_hellip:
      case ENTITY_iacute:
      case ENTITY_icirc:
      case ENTITY_iexcl:
      case ENTITY_igrave:
      case ENTITY_image:
      case ENTITY_infin:
      case ENTITY_int:
      case ENTITY_iota:
      case ENTITY_iquest:
      case ENTITY_isin:
      case ENTITY_iuml:
      case ENTITY_kappa:
      case ENTITY_lArr:
      case ENTITY_lambda:
      case ENTITY_lang:
      case ENTITY_laquo:
      case ENTITY_larr:
      case ENTITY_lceil:
      case ENTITY_ldquo:
      case ENTITY_le:
      case ENTITY_lfloor:
      case ENTITY_lowast:
      case ENTITY_loz:
      case ENTITY_lrm:
      case ENTITY_lsaquo:
      case ENTITY_lsquo:
      case ENTITY_lt:
      case ENTITY_macr:
      case ENTITY_mdash:
      case ENTITY_micro:
      case ENTITY_middot:
      case ENTITY_minus:
      case ENTITY_mu:
      case ENTITY_nabla:
      case ENTITY_nbsp:
      case ENTITY_ndash:
      case ENTITY_ne:
      case ENTITY_ni:
      case ENTITY_not:
      case ENTITY_notin:
      case ENTITY_nsub:
      case ENTITY_ntilde:
      case ENTITY_nu:
      case ENTITY_oacute:
      case ENTITY_ocirc:
      case ENTITY_oelig:
      case ENTITY_ograve:
      case ENTITY_oline:
      case ENTITY_omega:
      case ENTITY_omicron:
      case ENTITY_oplus:
      case ENTITY_or:
      case ENTITY_ordf:
      case ENTITY_ordm:
      case ENTITY_oslash:
      case ENTITY_otilde:
      case ENTITY_otimes:
      case ENTITY_ouml:
      case ENTITY_para:
      case ENTITY_part:
      case ENTITY_permil:
      case ENTITY_perp:
      case ENTITY_phi:
      case ENTITY_pi:
      case ENTITY_piv:
      case ENTITY_plusmn:
      case ENTITY_pound:
      case ENTITY_prime:
      case ENTITY_prod:
      case ENTITY_prop:
      case ENTITY_psi:
      case ENTITY_quot:
      case ENTITY_rArr:
      case ENTITY_radic:
      case ENTITY_rang:
      case ENTITY_raquo:
      case ENTITY_rarr:
      case ENTITY_rceil:
      case ENTITY_rdquo:
      case ENTITY_real:
      case ENTITY_reg:
      case ENTITY_rfloor:
      case ENTITY_rho:
      case ENTITY_rlm:
      case ENTITY_rsaquo:
      case ENTITY_rsquo:
      case ENTITY_sbquo:
      case ENTITY_scaron:
      case ENTITY_sdot:
      case ENTITY_sect:
      case ENTITY_shy:
      case ENTITY_sigma:
      case ENTITY_sigmaf:
      case ENTITY_sim:
      case ENTITY_spades:
      case ENTITY_sub:
      case ENTITY_sube:
      case ENTITY_sum:
      case ENTITY_sup:
      case ENTITY_sup1:
      case ENTITY_sup2:
      case ENTITY_sup3:
      case ENTITY_supe:
      case ENTITY_szlig:
      case ENTITY_tau:
      case ENTITY_there4:
      case ENTITY_theta:
      case ENTITY_thetasym:
      case ENTITY_thinsp:
      case ENTITY_thorn:
      case ENTITY_tilde:
      case ENTITY_times:
      case ENTITY_trade:
      case ENTITY_uArr:
      case ENTITY_uacute:
      case ENTITY_uarr:
      case ENTITY_ucirc:
      case ENTITY_ugrave:
      case ENTITY_uml:
      case ENTITY_upsih:
      case ENTITY_upsilon:
      case ENTITY_uuml:
      case ENTITY_weierp:
      case ENTITY_xi:
      case ENTITY_yacute:
      case ENTITY_yen:
      case ENTITY_yuml:
      case ENTITY_zeta:
      case ENTITY_zwj:
      case ENTITY_zwnj:
      case ENTITY_NUMERIC:
        Entity();
                                                                                  buffer.append(token.image);
        break;
      default:
        jj_la1[11] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      if (jj_2_2(2)) {
        ;
      } else {
        break label_9;
      }
    }
                                                                                                                   {if (true) return buffer.toString();}
    throw new Error("Missing return statement in function");
  }

  final public void Attribute(Map attrMap, StringBuffer buffer) throws ParseException {
  String name = null;
  String value = "";
    name = Label(buffer);
    if (jj_2_5(2)) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHITESPACE:
        jj_consume_token(WHITESPACE);
        break;
      default:
        jj_la1[12] = jj_gen;
        ;
      }
      jj_consume_token(EQUAL);
      if (jj_2_3(2)) {
        jj_consume_token(WHITESPACE);
      } else {
        ;
      }
      if (jj_2_4(2)) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case EQUAL:
        case TAGOTHER:
        case ENTITY_AElig:
        case ENTITY_Aacute:
        case ENTITY_Acirc:
        case ENTITY_Agrave:
        case ENTITY_Alpha:
        case ENTITY_Aring:
        case ENTITY_Atilde:
        case ENTITY_Auml:
        case ENTITY_Beta:
        case ENTITY_Ccedil:
        case ENTITY_Chi:
        case ENTITY_Dagger:
        case ENTITY_Delta:
        case ENTITY_ETH:
        case ENTITY_Eacute:
        case ENTITY_Ecirc:
        case ENTITY_Egrave:
        case ENTITY_Epsilon:
        case ENTITY_Eta:
        case ENTITY_Euml:
        case ENTITY_Gamma:
        case ENTITY_Iacute:
        case ENTITY_Icirc:
        case ENTITY_Igrave:
        case ENTITY_Iota:
        case ENTITY_Iuml:
        case ENTITY_Kappa:
        case ENTITY_Lambda:
        case ENTITY_Mu:
        case ENTITY_Ntilde:
        case ENTITY_Nu:
        case ENTITY_OElig:
        case ENTITY_Oacute:
        case ENTITY_Ocirc:
        case ENTITY_Ograve:
        case ENTITY_Omega:
        case ENTITY_Omicron:
        case ENTITY_Oslash:
        case ENTITY_Otilde:
        case ENTITY_Ouml:
        case ENTITY_Phi:
        case ENTITY_Pi:
        case ENTITY_Prime:
        case ENTITY_Psi:
        case ENTITY_Rho:
        case ENTITY_Scaron:
        case ENTITY_Sigma:
        case ENTITY_THORN:
        case ENTITY_Tau:
        case ENTITY_Theta:
        case ENTITY_Uacute:
        case ENTITY_Ucirc:
        case ENTITY_Ugrave:
        case ENTITY_Upsilon:
        case ENTITY_Uuml:
        case ENTITY_Xi:
        case ENTITY_Yacute:
        case ENTITY_Yuml:
        case ENTITY_Zeta:
        case ENTITY_aacute:
        case ENTITY_acirc:
        case ENTITY_acute:
        case ENTITY_aelig:
        case ENTITY_agrave:
        case ENTITY_alefsym:
        case ENTITY_alpha:
        case ENTITY_amp:
        case ENTITY_and:
        case ENTITY_ang:
        case ENTITY_aring:
        case ENTITY_asymp:
        case ENTITY_atilde:
        case ENTITY_auml:
        case ENTITY_bdquo:
        case ENTITY_beta:
        case ENTITY_brvbar:
        case ENTITY_bull:
        case ENTITY_cap:
        case ENTITY_ccedil:
        case ENTITY_cedil:
        case ENTITY_cent:
        case ENTITY_chi:
        case ENTITY_circ:
        case ENTITY_clubs:
        case ENTITY_cong:
        case ENTITY_copy:
        case ENTITY_crarr:
        case ENTITY_cup:
        case ENTITY_curren:
        case ENTITY_dArr:
        case ENTITY_dagger:
        case ENTITY_darr:
        case ENTITY_deg:
        case ENTITY_delta:
        case ENTITY_diams:
        case ENTITY_divide:
        case ENTITY_eacute:
        case ENTITY_ecirc:
        case ENTITY_egrave:
        case ENTITY_empty:
        case ENTITY_emsp:
        case ENTITY_ensp:
        case ENTITY_epsilon:
        case ENTITY_equiv:
        case ENTITY_eta:
        case ENTITY_eth:
        case ENTITY_euml:
        case ENTITY_euro:
        case ENTITY_exist:
        case ENTITY_fnof:
        case ENTITY_forall:
        case ENTITY_frac12:
        case ENTITY_frac14:
        case ENTITY_frac34:
        case ENTITY_frasl:
        case ENTITY_gamma:
        case ENTITY_ge:
        case ENTITY_gt:
        case ENTITY_hArr:
        case ENTITY_harr:
        case ENTITY_hearts:
        case ENTITY_hellip:
        case ENTITY_iacute:
        case ENTITY_icirc:
        case ENTITY_iexcl:
        case ENTITY_igrave:
        case ENTITY_image:
        case ENTITY_infin:
        case ENTITY_int:
        case ENTITY_iota:
        case ENTITY_iquest:
        case ENTITY_isin:
        case ENTITY_iuml:
        case ENTITY_kappa:
        case ENTITY_lArr:
        case ENTITY_lambda:
        case ENTITY_lang:
        case ENTITY_laquo:
        case ENTITY_larr:
        case ENTITY_lceil:
        case ENTITY_ldquo:
        case ENTITY_le:
        case ENTITY_lfloor:
        case ENTITY_lowast:
        case ENTITY_loz:
        case ENTITY_lrm:
        case ENTITY_lsaquo:
        case ENTITY_lsquo:
        case ENTITY_lt:
        case ENTITY_macr:
        case ENTITY_mdash:
        case ENTITY_micro:
        case ENTITY_middot:
        case ENTITY_minus:
        case ENTITY_mu:
        case ENTITY_nabla:
        case ENTITY_nbsp:
        case ENTITY_ndash:
        case ENTITY_ne:
        case ENTITY_ni:
        case ENTITY_not:
        case ENTITY_notin:
        case ENTITY_nsub:
        case ENTITY_ntilde:
        case ENTITY_nu:
        case ENTITY_oacute:
        case ENTITY_ocirc:
        case ENTITY_oelig:
        case ENTITY_ograve:
        case ENTITY_oline:
        case ENTITY_omega:
        case ENTITY_omicron:
        case ENTITY_oplus:
        case ENTITY_or:
        case ENTITY_ordf:
        case ENTITY_ordm:
        case ENTITY_oslash:
        case ENTITY_otilde:
        case ENTITY_otimes:
        case ENTITY_ouml:
        case ENTITY_para:
        case ENTITY_part:
        case ENTITY_permil:
        case ENTITY_perp:
        case ENTITY_phi:
        case ENTITY_pi:
        case ENTITY_piv:
        case ENTITY_plusmn:
        case ENTITY_pound:
        case ENTITY_prime:
        case ENTITY_prod:
        case ENTITY_prop:
        case ENTITY_psi:
        case ENTITY_quot:
        case ENTITY_rArr:
        case ENTITY_radic:
        case ENTITY_rang:
        case ENTITY_raquo:
        case ENTITY_rarr:
        case ENTITY_rceil:
        case ENTITY_rdquo:
        case ENTITY_real:
        case ENTITY_reg:
        case ENTITY_rfloor:
        case ENTITY_rho:
        case ENTITY_rlm:
        case ENTITY_rsaquo:
        case ENTITY_rsquo:
        case ENTITY_sbquo:
        case ENTITY_scaron:
        case ENTITY_sdot:
        case ENTITY_sect:
        case ENTITY_shy:
        case ENTITY_sigma:
        case ENTITY_sigmaf:
        case ENTITY_sim:
        case ENTITY_spades:
        case ENTITY_sub:
        case ENTITY_sube:
        case ENTITY_sum:
        case ENTITY_sup:
        case ENTITY_sup1:
        case ENTITY_sup2:
        case ENTITY_sup3:
        case ENTITY_supe:
        case ENTITY_szlig:
        case ENTITY_tau:
        case ENTITY_there4:
        case ENTITY_theta:
        case ENTITY_thetasym:
        case ENTITY_thinsp:
        case ENTITY_thorn:
        case ENTITY_tilde:
        case ENTITY_times:
        case ENTITY_trade:
        case ENTITY_uArr:
        case ENTITY_uacute:
        case ENTITY_uarr:
        case ENTITY_ucirc:
        case ENTITY_ugrave:
        case ENTITY_uml:
        case ENTITY_upsih:
        case ENTITY_upsilon:
        case ENTITY_uuml:
        case ENTITY_weierp:
        case ENTITY_xi:
        case ENTITY_yacute:
        case ENTITY_yen:
        case ENTITY_yuml:
        case ENTITY_zeta:
        case ENTITY_zwj:
        case ENTITY_zwnj:
        case ENTITY_NUMERIC:
          value = AttrValue(buffer);
          break;
        case BEGINDOUBLEQUOTE:
          value = DoubleQuote(buffer);
          break;
        case BEGINSINGLEQUOTE:
          value = SingleQuote(buffer);
          break;
        default:
          jj_la1[13] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } else {
        ;
      }
    } else {
      ;
    }
                                                                                                                                                                                             attrMap.put(name, value);
  }

  final public void AttrDecl(Map attrMap, StringBuffer buffer) throws ParseException {
  attrMap.clear();
    Attribute(attrMap, buffer);
    label_10:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHITESPACE:
      case TAGOTHER:
      case ENTITY_AElig:
      case ENTITY_Aacute:
      case ENTITY_Acirc:
      case ENTITY_Agrave:
      case ENTITY_Alpha:
      case ENTITY_Aring:
      case ENTITY_Atilde:
      case ENTITY_Auml:
      case ENTITY_Beta:
      case ENTITY_Ccedil:
      case ENTITY_Chi:
      case ENTITY_Dagger:
      case ENTITY_Delta:
      case ENTITY_ETH:
      case ENTITY_Eacute:
      case ENTITY_Ecirc:
      case ENTITY_Egrave:
      case ENTITY_Epsilon:
      case ENTITY_Eta:
      case ENTITY_Euml:
      case ENTITY_Gamma:
      case ENTITY_Iacute:
      case ENTITY_Icirc:
      case ENTITY_Igrave:
      case ENTITY_Iota:
      case ENTITY_Iuml:
      case ENTITY_Kappa:
      case ENTITY_Lambda:
      case ENTITY_Mu:
      case ENTITY_Ntilde:
      case ENTITY_Nu:
      case ENTITY_OElig:
      case ENTITY_Oacute:
      case ENTITY_Ocirc:
      case ENTITY_Ograve:
      case ENTITY_Omega:
      case ENTITY_Omicron:
      case ENTITY_Oslash:
      case ENTITY_Otilde:
      case ENTITY_Ouml:
      case ENTITY_Phi:
      case ENTITY_Pi:
      case ENTITY_Prime:
      case ENTITY_Psi:
      case ENTITY_Rho:
      case ENTITY_Scaron:
      case ENTITY_Sigma:
      case ENTITY_THORN:
      case ENTITY_Tau:
      case ENTITY_Theta:
      case ENTITY_Uacute:
      case ENTITY_Ucirc:
      case ENTITY_Ugrave:
      case ENTITY_Upsilon:
      case ENTITY_Uuml:
      case ENTITY_Xi:
      case ENTITY_Yacute:
      case ENTITY_Yuml:
      case ENTITY_Zeta:
      case ENTITY_aacute:
      case ENTITY_acirc:
      case ENTITY_acute:
      case ENTITY_aelig:
      case ENTITY_agrave:
      case ENTITY_alefsym:
      case ENTITY_alpha:
      case ENTITY_amp:
      case ENTITY_and:
      case ENTITY_ang:
      case ENTITY_aring:
      case ENTITY_asymp:
      case ENTITY_atilde:
      case ENTITY_auml:
      case ENTITY_bdquo:
      case ENTITY_beta:
      case ENTITY_brvbar:
      case ENTITY_bull:
      case ENTITY_cap:
      case ENTITY_ccedil:
      case ENTITY_cedil:
      case ENTITY_cent:
      case ENTITY_chi:
      case ENTITY_circ:
      case ENTITY_clubs:
      case ENTITY_cong:
      case ENTITY_copy:
      case ENTITY_crarr:
      case ENTITY_cup:
      case ENTITY_curren:
      case ENTITY_dArr:
      case ENTITY_dagger:
      case ENTITY_darr:
      case ENTITY_deg:
      case ENTITY_delta:
      case ENTITY_diams:
      case ENTITY_divide:
      case ENTITY_eacute:
      case ENTITY_ecirc:
      case ENTITY_egrave:
      case ENTITY_empty:
      case ENTITY_emsp:
      case ENTITY_ensp:
      case ENTITY_epsilon:
      case ENTITY_equiv:
      case ENTITY_eta:
      case ENTITY_eth:
      case ENTITY_euml:
      case ENTITY_euro:
      case ENTITY_exist:
      case ENTITY_fnof:
      case ENTITY_forall:
      case ENTITY_frac12:
      case ENTITY_frac14:
      case ENTITY_frac34:
      case ENTITY_frasl:
      case ENTITY_gamma:
      case ENTITY_ge:
      case ENTITY_gt:
      case ENTITY_hArr:
      case ENTITY_harr:
      case ENTITY_hearts:
      case ENTITY_hellip:
      case ENTITY_iacute:
      case ENTITY_icirc:
      case ENTITY_iexcl:
      case ENTITY_igrave:
      case ENTITY_image:
      case ENTITY_infin:
      case ENTITY_int:
      case ENTITY_iota:
      case ENTITY_iquest:
      case ENTITY_isin:
      case ENTITY_iuml:
      case ENTITY_kappa:
      case ENTITY_lArr:
      case ENTITY_lambda:
      case ENTITY_lang:
      case ENTITY_laquo:
      case ENTITY_larr:
      case ENTITY_lceil:
      case ENTITY_ldquo:
      case ENTITY_le:
      case ENTITY_lfloor:
      case ENTITY_lowast:
      case ENTITY_loz:
      case ENTITY_lrm:
      case ENTITY_lsaquo:
      case ENTITY_lsquo:
      case ENTITY_lt:
      case ENTITY_macr:
      case ENTITY_mdash:
      case ENTITY_micro:
      case ENTITY_middot:
      case ENTITY_minus:
      case ENTITY_mu:
      case ENTITY_nabla:
      case ENTITY_nbsp:
      case ENTITY_ndash:
      case ENTITY_ne:
      case ENTITY_ni:
      case ENTITY_not:
      case ENTITY_notin:
      case ENTITY_nsub:
      case ENTITY_ntilde:
      case ENTITY_nu:
      case ENTITY_oacute:
      case ENTITY_ocirc:
      case ENTITY_oelig:
      case ENTITY_ograve:
      case ENTITY_oline:
      case ENTITY_omega:
      case ENTITY_omicron:
      case ENTITY_oplus:
      case ENTITY_or:
      case ENTITY_ordf:
      case ENTITY_ordm:
      case ENTITY_oslash:
      case ENTITY_otilde:
      case ENTITY_otimes:
      case ENTITY_ouml:
      case ENTITY_para:
      case ENTITY_part:
      case ENTITY_permil:
      case ENTITY_perp:
      case ENTITY_phi:
      case ENTITY_pi:
      case ENTITY_piv:
      case ENTITY_plusmn:
      case ENTITY_pound:
      case ENTITY_prime:
      case ENTITY_prod:
      case ENTITY_prop:
      case ENTITY_psi:
      case ENTITY_quot:
      case ENTITY_rArr:
      case ENTITY_radic:
      case ENTITY_rang:
      case ENTITY_raquo:
      case ENTITY_rarr:
      case ENTITY_rceil:
      case ENTITY_rdquo:
      case ENTITY_real:
      case ENTITY_reg:
      case ENTITY_rfloor:
      case ENTITY_rho:
      case ENTITY_rlm:
      case ENTITY_rsaquo:
      case ENTITY_rsquo:
      case ENTITY_sbquo:
      case ENTITY_scaron:
      case ENTITY_sdot:
      case ENTITY_sect:
      case ENTITY_shy:
      case ENTITY_sigma:
      case ENTITY_sigmaf:
      case ENTITY_sim:
      case ENTITY_spades:
      case ENTITY_sub:
      case ENTITY_sube:
      case ENTITY_sum:
      case ENTITY_sup:
      case ENTITY_sup1:
      case ENTITY_sup2:
      case ENTITY_sup3:
      case ENTITY_supe:
      case ENTITY_szlig:
      case ENTITY_tau:
      case ENTITY_there4:
      case ENTITY_theta:
      case ENTITY_thetasym:
      case ENTITY_thinsp:
      case ENTITY_thorn:
      case ENTITY_tilde:
      case ENTITY_times:
      case ENTITY_trade:
      case ENTITY_uArr:
      case ENTITY_uacute:
      case ENTITY_uarr:
      case ENTITY_ucirc:
      case ENTITY_ugrave:
      case ENTITY_uml:
      case ENTITY_upsih:
      case ENTITY_upsilon:
      case ENTITY_uuml:
      case ENTITY_weierp:
      case ENTITY_xi:
      case ENTITY_yacute:
      case ENTITY_yen:
      case ENTITY_yuml:
      case ENTITY_zeta:
      case ENTITY_zwj:
      case ENTITY_zwnj:
      case ENTITY_NUMERIC:
        ;
        break;
      default:
        jj_la1[14] = jj_gen;
        break label_10;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHITESPACE:
        jj_consume_token(WHITESPACE);
        break;
      default:
        jj_la1[15] = jj_gen;
        ;
      }
      Attribute(attrMap, buffer);
    }
  }

  final public void Tag(Map map, Map attrMap, StringBuffer buffer) throws ParseException {
  String s;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BEGINTAG:
      jj_consume_token(BEGINTAG);
               map.put(TYPE, OPENTAG);
      break;
    case BEGINCLOSETAG:
      jj_consume_token(BEGINCLOSETAG);
                                                           map.put(TYPE, CLOSETAG);
      break;
    default:
      jj_la1[16] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WHITESPACE:
      jj_consume_token(WHITESPACE);
      break;
    default:
      jj_la1[17] = jj_gen;
      ;
    }
    s = Label(buffer);
                                                                                                                       map.put(VALUE, s);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WHITESPACE:
      jj_consume_token(WHITESPACE);
      break;
    default:
      jj_la1[18] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TAGOTHER:
    case ENTITY_AElig:
    case ENTITY_Aacute:
    case ENTITY_Acirc:
    case ENTITY_Agrave:
    case ENTITY_Alpha:
    case ENTITY_Aring:
    case ENTITY_Atilde:
    case ENTITY_Auml:
    case ENTITY_Beta:
    case ENTITY_Ccedil:
    case ENTITY_Chi:
    case ENTITY_Dagger:
    case ENTITY_Delta:
    case ENTITY_ETH:
    case ENTITY_Eacute:
    case ENTITY_Ecirc:
    case ENTITY_Egrave:
    case ENTITY_Epsilon:
    case ENTITY_Eta:
    case ENTITY_Euml:
    case ENTITY_Gamma:
    case ENTITY_Iacute:
    case ENTITY_Icirc:
    case ENTITY_Igrave:
    case ENTITY_Iota:
    case ENTITY_Iuml:
    case ENTITY_Kappa:
    case ENTITY_Lambda:
    case ENTITY_Mu:
    case ENTITY_Ntilde:
    case ENTITY_Nu:
    case ENTITY_OElig:
    case ENTITY_Oacute:
    case ENTITY_Ocirc:
    case ENTITY_Ograve:
    case ENTITY_Omega:
    case ENTITY_Omicron:
    case ENTITY_Oslash:
    case ENTITY_Otilde:
    case ENTITY_Ouml:
    case ENTITY_Phi:
    case ENTITY_Pi:
    case ENTITY_Prime:
    case ENTITY_Psi:
    case ENTITY_Rho:
    case ENTITY_Scaron:
    case ENTITY_Sigma:
    case ENTITY_THORN:
    case ENTITY_Tau:
    case ENTITY_Theta:
    case ENTITY_Uacute:
    case ENTITY_Ucirc:
    case ENTITY_Ugrave:
    case ENTITY_Upsilon:
    case ENTITY_Uuml:
    case ENTITY_Xi:
    case ENTITY_Yacute:
    case ENTITY_Yuml:
    case ENTITY_Zeta:
    case ENTITY_aacute:
    case ENTITY_acirc:
    case ENTITY_acute:
    case ENTITY_aelig:
    case ENTITY_agrave:
    case ENTITY_alefsym:
    case ENTITY_alpha:
    case ENTITY_amp:
    case ENTITY_and:
    case ENTITY_ang:
    case ENTITY_aring:
    case ENTITY_asymp:
    case ENTITY_atilde:
    case ENTITY_auml:
    case ENTITY_bdquo:
    case ENTITY_beta:
    case ENTITY_brvbar:
    case ENTITY_bull:
    case ENTITY_cap:
    case ENTITY_ccedil:
    case ENTITY_cedil:
    case ENTITY_cent:
    case ENTITY_chi:
    case ENTITY_circ:
    case ENTITY_clubs:
    case ENTITY_cong:
    case ENTITY_copy:
    case ENTITY_crarr:
    case ENTITY_cup:
    case ENTITY_curren:
    case ENTITY_dArr:
    case ENTITY_dagger:
    case ENTITY_darr:
    case ENTITY_deg:
    case ENTITY_delta:
    case ENTITY_diams:
    case ENTITY_divide:
    case ENTITY_eacute:
    case ENTITY_ecirc:
    case ENTITY_egrave:
    case ENTITY_empty:
    case ENTITY_emsp:
    case ENTITY_ensp:
    case ENTITY_epsilon:
    case ENTITY_equiv:
    case ENTITY_eta:
    case ENTITY_eth:
    case ENTITY_euml:
    case ENTITY_euro:
    case ENTITY_exist:
    case ENTITY_fnof:
    case ENTITY_forall:
    case ENTITY_frac12:
    case ENTITY_frac14:
    case ENTITY_frac34:
    case ENTITY_frasl:
    case ENTITY_gamma:
    case ENTITY_ge:
    case ENTITY_gt:
    case ENTITY_hArr:
    case ENTITY_harr:
    case ENTITY_hearts:
    case ENTITY_hellip:
    case ENTITY_iacute:
    case ENTITY_icirc:
    case ENTITY_iexcl:
    case ENTITY_igrave:
    case ENTITY_image:
    case ENTITY_infin:
    case ENTITY_int:
    case ENTITY_iota:
    case ENTITY_iquest:
    case ENTITY_isin:
    case ENTITY_iuml:
    case ENTITY_kappa:
    case ENTITY_lArr:
    case ENTITY_lambda:
    case ENTITY_lang:
    case ENTITY_laquo:
    case ENTITY_larr:
    case ENTITY_lceil:
    case ENTITY_ldquo:
    case ENTITY_le:
    case ENTITY_lfloor:
    case ENTITY_lowast:
    case ENTITY_loz:
    case ENTITY_lrm:
    case ENTITY_lsaquo:
    case ENTITY_lsquo:
    case ENTITY_lt:
    case ENTITY_macr:
    case ENTITY_mdash:
    case ENTITY_micro:
    case ENTITY_middot:
    case ENTITY_minus:
    case ENTITY_mu:
    case ENTITY_nabla:
    case ENTITY_nbsp:
    case ENTITY_ndash:
    case ENTITY_ne:
    case ENTITY_ni:
    case ENTITY_not:
    case ENTITY_notin:
    case ENTITY_nsub:
    case ENTITY_ntilde:
    case ENTITY_nu:
    case ENTITY_oacute:
    case ENTITY_ocirc:
    case ENTITY_oelig:
    case ENTITY_ograve:
    case ENTITY_oline:
    case ENTITY_omega:
    case ENTITY_omicron:
    case ENTITY_oplus:
    case ENTITY_or:
    case ENTITY_ordf:
    case ENTITY_ordm:
    case ENTITY_oslash:
    case ENTITY_otilde:
    case ENTITY_otimes:
    case ENTITY_ouml:
    case ENTITY_para:
    case ENTITY_part:
    case ENTITY_permil:
    case ENTITY_perp:
    case ENTITY_phi:
    case ENTITY_pi:
    case ENTITY_piv:
    case ENTITY_plusmn:
    case ENTITY_pound:
    case ENTITY_prime:
    case ENTITY_prod:
    case ENTITY_prop:
    case ENTITY_psi:
    case ENTITY_quot:
    case ENTITY_rArr:
    case ENTITY_radic:
    case ENTITY_rang:
    case ENTITY_raquo:
    case ENTITY_rarr:
    case ENTITY_rceil:
    case ENTITY_rdquo:
    case ENTITY_real:
    case ENTITY_reg:
    case ENTITY_rfloor:
    case ENTITY_rho:
    case ENTITY_rlm:
    case ENTITY_rsaquo:
    case ENTITY_rsquo:
    case ENTITY_sbquo:
    case ENTITY_scaron:
    case ENTITY_sdot:
    case ENTITY_sect:
    case ENTITY_shy:
    case ENTITY_sigma:
    case ENTITY_sigmaf:
    case ENTITY_sim:
    case ENTITY_spades:
    case ENTITY_sub:
    case ENTITY_sube:
    case ENTITY_sum:
    case ENTITY_sup:
    case ENTITY_sup1:
    case ENTITY_sup2:
    case ENTITY_sup3:
    case ENTITY_supe:
    case ENTITY_szlig:
    case ENTITY_tau:
    case ENTITY_there4:
    case ENTITY_theta:
    case ENTITY_thetasym:
    case ENTITY_thinsp:
    case ENTITY_thorn:
    case ENTITY_tilde:
    case ENTITY_times:
    case ENTITY_trade:
    case ENTITY_uArr:
    case ENTITY_uacute:
    case ENTITY_uarr:
    case ENTITY_ucirc:
    case ENTITY_ugrave:
    case ENTITY_uml:
    case ENTITY_upsih:
    case ENTITY_upsilon:
    case ENTITY_uuml:
    case ENTITY_weierp:
    case ENTITY_xi:
    case ENTITY_yacute:
    case ENTITY_yen:
    case ENTITY_yuml:
    case ENTITY_zeta:
    case ENTITY_zwj:
    case ENTITY_zwnj:
    case ENTITY_NUMERIC:
      AttrDecl(attrMap, buffer);
                                                                                                                                                                                       map.put(ATTRIBUTE, attrMap);
      break;
    default:
      jj_la1[19] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ENDTAG:
      jj_consume_token(ENDTAG);
      break;
    case ENDSINGLETAG:
      jj_consume_token(ENDSINGLETAG);
                                                                                                                                                                                                                                                   map.put(TYPE, SINGLETAG);
      break;
    default:
      jj_la1[20] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void BeginScript(Map map, Map attrMap, StringBuffer buffer) throws ParseException {
  String s;
    jj_consume_token(BEGINSCRIPT);
                 map.put(TYPE, SCRIPT);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WHITESPACE:
      jj_consume_token(WHITESPACE);
      break;
    default:
      jj_la1[21] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TAGOTHER:
    case ENTITY_AElig:
    case ENTITY_Aacute:
    case ENTITY_Acirc:
    case ENTITY_Agrave:
    case ENTITY_Alpha:
    case ENTITY_Aring:
    case ENTITY_Atilde:
    case ENTITY_Auml:
    case ENTITY_Beta:
    case ENTITY_Ccedil:
    case ENTITY_Chi:
    case ENTITY_Dagger:
    case ENTITY_Delta:
    case ENTITY_ETH:
    case ENTITY_Eacute:
    case ENTITY_Ecirc:
    case ENTITY_Egrave:
    case ENTITY_Epsilon:
    case ENTITY_Eta:
    case ENTITY_Euml:
    case ENTITY_Gamma:
    case ENTITY_Iacute:
    case ENTITY_Icirc:
    case ENTITY_Igrave:
    case ENTITY_Iota:
    case ENTITY_Iuml:
    case ENTITY_Kappa:
    case ENTITY_Lambda:
    case ENTITY_Mu:
    case ENTITY_Ntilde:
    case ENTITY_Nu:
    case ENTITY_OElig:
    case ENTITY_Oacute:
    case ENTITY_Ocirc:
    case ENTITY_Ograve:
    case ENTITY_Omega:
    case ENTITY_Omicron:
    case ENTITY_Oslash:
    case ENTITY_Otilde:
    case ENTITY_Ouml:
    case ENTITY_Phi:
    case ENTITY_Pi:
    case ENTITY_Prime:
    case ENTITY_Psi:
    case ENTITY_Rho:
    case ENTITY_Scaron:
    case ENTITY_Sigma:
    case ENTITY_THORN:
    case ENTITY_Tau:
    case ENTITY_Theta:
    case ENTITY_Uacute:
    case ENTITY_Ucirc:
    case ENTITY_Ugrave:
    case ENTITY_Upsilon:
    case ENTITY_Uuml:
    case ENTITY_Xi:
    case ENTITY_Yacute:
    case ENTITY_Yuml:
    case ENTITY_Zeta:
    case ENTITY_aacute:
    case ENTITY_acirc:
    case ENTITY_acute:
    case ENTITY_aelig:
    case ENTITY_agrave:
    case ENTITY_alefsym:
    case ENTITY_alpha:
    case ENTITY_amp:
    case ENTITY_and:
    case ENTITY_ang:
    case ENTITY_aring:
    case ENTITY_asymp:
    case ENTITY_atilde:
    case ENTITY_auml:
    case ENTITY_bdquo:
    case ENTITY_beta:
    case ENTITY_brvbar:
    case ENTITY_bull:
    case ENTITY_cap:
    case ENTITY_ccedil:
    case ENTITY_cedil:
    case ENTITY_cent:
    case ENTITY_chi:
    case ENTITY_circ:
    case ENTITY_clubs:
    case ENTITY_cong:
    case ENTITY_copy:
    case ENTITY_crarr:
    case ENTITY_cup:
    case ENTITY_curren:
    case ENTITY_dArr:
    case ENTITY_dagger:
    case ENTITY_darr:
    case ENTITY_deg:
    case ENTITY_delta:
    case ENTITY_diams:
    case ENTITY_divide:
    case ENTITY_eacute:
    case ENTITY_ecirc:
    case ENTITY_egrave:
    case ENTITY_empty:
    case ENTITY_emsp:
    case ENTITY_ensp:
    case ENTITY_epsilon:
    case ENTITY_equiv:
    case ENTITY_eta:
    case ENTITY_eth:
    case ENTITY_euml:
    case ENTITY_euro:
    case ENTITY_exist:
    case ENTITY_fnof:
    case ENTITY_forall:
    case ENTITY_frac12:
    case ENTITY_frac14:
    case ENTITY_frac34:
    case ENTITY_frasl:
    case ENTITY_gamma:
    case ENTITY_ge:
    case ENTITY_gt:
    case ENTITY_hArr:
    case ENTITY_harr:
    case ENTITY_hearts:
    case ENTITY_hellip:
    case ENTITY_iacute:
    case ENTITY_icirc:
    case ENTITY_iexcl:
    case ENTITY_igrave:
    case ENTITY_image:
    case ENTITY_infin:
    case ENTITY_int:
    case ENTITY_iota:
    case ENTITY_iquest:
    case ENTITY_isin:
    case ENTITY_iuml:
    case ENTITY_kappa:
    case ENTITY_lArr:
    case ENTITY_lambda:
    case ENTITY_lang:
    case ENTITY_laquo:
    case ENTITY_larr:
    case ENTITY_lceil:
    case ENTITY_ldquo:
    case ENTITY_le:
    case ENTITY_lfloor:
    case ENTITY_lowast:
    case ENTITY_loz:
    case ENTITY_lrm:
    case ENTITY_lsaquo:
    case ENTITY_lsquo:
    case ENTITY_lt:
    case ENTITY_macr:
    case ENTITY_mdash:
    case ENTITY_micro:
    case ENTITY_middot:
    case ENTITY_minus:
    case ENTITY_mu:
    case ENTITY_nabla:
    case ENTITY_nbsp:
    case ENTITY_ndash:
    case ENTITY_ne:
    case ENTITY_ni:
    case ENTITY_not:
    case ENTITY_notin:
    case ENTITY_nsub:
    case ENTITY_ntilde:
    case ENTITY_nu:
    case ENTITY_oacute:
    case ENTITY_ocirc:
    case ENTITY_oelig:
    case ENTITY_ograve:
    case ENTITY_oline:
    case ENTITY_omega:
    case ENTITY_omicron:
    case ENTITY_oplus:
    case ENTITY_or:
    case ENTITY_ordf:
    case ENTITY_ordm:
    case ENTITY_oslash:
    case ENTITY_otilde:
    case ENTITY_otimes:
    case ENTITY_ouml:
    case ENTITY_para:
    case ENTITY_part:
    case ENTITY_permil:
    case ENTITY_perp:
    case ENTITY_phi:
    case ENTITY_pi:
    case ENTITY_piv:
    case ENTITY_plusmn:
    case ENTITY_pound:
    case ENTITY_prime:
    case ENTITY_prod:
    case ENTITY_prop:
    case ENTITY_psi:
    case ENTITY_quot:
    case ENTITY_rArr:
    case ENTITY_radic:
    case ENTITY_rang:
    case ENTITY_raquo:
    case ENTITY_rarr:
    case ENTITY_rceil:
    case ENTITY_rdquo:
    case ENTITY_real:
    case ENTITY_reg:
    case ENTITY_rfloor:
    case ENTITY_rho:
    case ENTITY_rlm:
    case ENTITY_rsaquo:
    case ENTITY_rsquo:
    case ENTITY_sbquo:
    case ENTITY_scaron:
    case ENTITY_sdot:
    case ENTITY_sect:
    case ENTITY_shy:
    case ENTITY_sigma:
    case ENTITY_sigmaf:
    case ENTITY_sim:
    case ENTITY_spades:
    case ENTITY_sub:
    case ENTITY_sube:
    case ENTITY_sum:
    case ENTITY_sup:
    case ENTITY_sup1:
    case ENTITY_sup2:
    case ENTITY_sup3:
    case ENTITY_supe:
    case ENTITY_szlig:
    case ENTITY_tau:
    case ENTITY_there4:
    case ENTITY_theta:
    case ENTITY_thetasym:
    case ENTITY_thinsp:
    case ENTITY_thorn:
    case ENTITY_tilde:
    case ENTITY_times:
    case ENTITY_trade:
    case ENTITY_uArr:
    case ENTITY_uacute:
    case ENTITY_uarr:
    case ENTITY_ucirc:
    case ENTITY_ugrave:
    case ENTITY_uml:
    case ENTITY_upsih:
    case ENTITY_upsilon:
    case ENTITY_uuml:
    case ENTITY_weierp:
    case ENTITY_xi:
    case ENTITY_yacute:
    case ENTITY_yen:
    case ENTITY_yuml:
    case ENTITY_zeta:
    case ENTITY_zwj:
    case ENTITY_zwnj:
    case ENTITY_NUMERIC:
      AttrDecl(attrMap, buffer);
                                                                                     map.put(ATTRIBUTE, attrMap);
      break;
    default:
      jj_la1[22] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ENDTAG:
      jj_consume_token(ENDTAG);
      break;
    case ENDSINGLETAG:
      jj_consume_token(ENDSINGLETAG);
      break;
    default:
      jj_la1[23] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void BeginStyle(Map map, Map attrMap, StringBuffer buffer) throws ParseException {
  String s;
    jj_consume_token(BEGINSTYLE);
                map.put(TYPE, SCRIPT);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WHITESPACE:
      jj_consume_token(WHITESPACE);
      break;
    default:
      jj_la1[24] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TAGOTHER:
    case ENTITY_AElig:
    case ENTITY_Aacute:
    case ENTITY_Acirc:
    case ENTITY_Agrave:
    case ENTITY_Alpha:
    case ENTITY_Aring:
    case ENTITY_Atilde:
    case ENTITY_Auml:
    case ENTITY_Beta:
    case ENTITY_Ccedil:
    case ENTITY_Chi:
    case ENTITY_Dagger:
    case ENTITY_Delta:
    case ENTITY_ETH:
    case ENTITY_Eacute:
    case ENTITY_Ecirc:
    case ENTITY_Egrave:
    case ENTITY_Epsilon:
    case ENTITY_Eta:
    case ENTITY_Euml:
    case ENTITY_Gamma:
    case ENTITY_Iacute:
    case ENTITY_Icirc:
    case ENTITY_Igrave:
    case ENTITY_Iota:
    case ENTITY_Iuml:
    case ENTITY_Kappa:
    case ENTITY_Lambda:
    case ENTITY_Mu:
    case ENTITY_Ntilde:
    case ENTITY_Nu:
    case ENTITY_OElig:
    case ENTITY_Oacute:
    case ENTITY_Ocirc:
    case ENTITY_Ograve:
    case ENTITY_Omega:
    case ENTITY_Omicron:
    case ENTITY_Oslash:
    case ENTITY_Otilde:
    case ENTITY_Ouml:
    case ENTITY_Phi:
    case ENTITY_Pi:
    case ENTITY_Prime:
    case ENTITY_Psi:
    case ENTITY_Rho:
    case ENTITY_Scaron:
    case ENTITY_Sigma:
    case ENTITY_THORN:
    case ENTITY_Tau:
    case ENTITY_Theta:
    case ENTITY_Uacute:
    case ENTITY_Ucirc:
    case ENTITY_Ugrave:
    case ENTITY_Upsilon:
    case ENTITY_Uuml:
    case ENTITY_Xi:
    case ENTITY_Yacute:
    case ENTITY_Yuml:
    case ENTITY_Zeta:
    case ENTITY_aacute:
    case ENTITY_acirc:
    case ENTITY_acute:
    case ENTITY_aelig:
    case ENTITY_agrave:
    case ENTITY_alefsym:
    case ENTITY_alpha:
    case ENTITY_amp:
    case ENTITY_and:
    case ENTITY_ang:
    case ENTITY_aring:
    case ENTITY_asymp:
    case ENTITY_atilde:
    case ENTITY_auml:
    case ENTITY_bdquo:
    case ENTITY_beta:
    case ENTITY_brvbar:
    case ENTITY_bull:
    case ENTITY_cap:
    case ENTITY_ccedil:
    case ENTITY_cedil:
    case ENTITY_cent:
    case ENTITY_chi:
    case ENTITY_circ:
    case ENTITY_clubs:
    case ENTITY_cong:
    case ENTITY_copy:
    case ENTITY_crarr:
    case ENTITY_cup:
    case ENTITY_curren:
    case ENTITY_dArr:
    case ENTITY_dagger:
    case ENTITY_darr:
    case ENTITY_deg:
    case ENTITY_delta:
    case ENTITY_diams:
    case ENTITY_divide:
    case ENTITY_eacute:
    case ENTITY_ecirc:
    case ENTITY_egrave:
    case ENTITY_empty:
    case ENTITY_emsp:
    case ENTITY_ensp:
    case ENTITY_epsilon:
    case ENTITY_equiv:
    case ENTITY_eta:
    case ENTITY_eth:
    case ENTITY_euml:
    case ENTITY_euro:
    case ENTITY_exist:
    case ENTITY_fnof:
    case ENTITY_forall:
    case ENTITY_frac12:
    case ENTITY_frac14:
    case ENTITY_frac34:
    case ENTITY_frasl:
    case ENTITY_gamma:
    case ENTITY_ge:
    case ENTITY_gt:
    case ENTITY_hArr:
    case ENTITY_harr:
    case ENTITY_hearts:
    case ENTITY_hellip:
    case ENTITY_iacute:
    case ENTITY_icirc:
    case ENTITY_iexcl:
    case ENTITY_igrave:
    case ENTITY_image:
    case ENTITY_infin:
    case ENTITY_int:
    case ENTITY_iota:
    case ENTITY_iquest:
    case ENTITY_isin:
    case ENTITY_iuml:
    case ENTITY_kappa:
    case ENTITY_lArr:
    case ENTITY_lambda:
    case ENTITY_lang:
    case ENTITY_laquo:
    case ENTITY_larr:
    case ENTITY_lceil:
    case ENTITY_ldquo:
    case ENTITY_le:
    case ENTITY_lfloor:
    case ENTITY_lowast:
    case ENTITY_loz:
    case ENTITY_lrm:
    case ENTITY_lsaquo:
    case ENTITY_lsquo:
    case ENTITY_lt:
    case ENTITY_macr:
    case ENTITY_mdash:
    case ENTITY_micro:
    case ENTITY_middot:
    case ENTITY_minus:
    case ENTITY_mu:
    case ENTITY_nabla:
    case ENTITY_nbsp:
    case ENTITY_ndash:
    case ENTITY_ne:
    case ENTITY_ni:
    case ENTITY_not:
    case ENTITY_notin:
    case ENTITY_nsub:
    case ENTITY_ntilde:
    case ENTITY_nu:
    case ENTITY_oacute:
    case ENTITY_ocirc:
    case ENTITY_oelig:
    case ENTITY_ograve:
    case ENTITY_oline:
    case ENTITY_omega:
    case ENTITY_omicron:
    case ENTITY_oplus:
    case ENTITY_or:
    case ENTITY_ordf:
    case ENTITY_ordm:
    case ENTITY_oslash:
    case ENTITY_otilde:
    case ENTITY_otimes:
    case ENTITY_ouml:
    case ENTITY_para:
    case ENTITY_part:
    case ENTITY_permil:
    case ENTITY_perp:
    case ENTITY_phi:
    case ENTITY_pi:
    case ENTITY_piv:
    case ENTITY_plusmn:
    case ENTITY_pound:
    case ENTITY_prime:
    case ENTITY_prod:
    case ENTITY_prop:
    case ENTITY_psi:
    case ENTITY_quot:
    case ENTITY_rArr:
    case ENTITY_radic:
    case ENTITY_rang:
    case ENTITY_raquo:
    case ENTITY_rarr:
    case ENTITY_rceil:
    case ENTITY_rdquo:
    case ENTITY_real:
    case ENTITY_reg:
    case ENTITY_rfloor:
    case ENTITY_rho:
    case ENTITY_rlm:
    case ENTITY_rsaquo:
    case ENTITY_rsquo:
    case ENTITY_sbquo:
    case ENTITY_scaron:
    case ENTITY_sdot:
    case ENTITY_sect:
    case ENTITY_shy:
    case ENTITY_sigma:
    case ENTITY_sigmaf:
    case ENTITY_sim:
    case ENTITY_spades:
    case ENTITY_sub:
    case ENTITY_sube:
    case ENTITY_sum:
    case ENTITY_sup:
    case ENTITY_sup1:
    case ENTITY_sup2:
    case ENTITY_sup3:
    case ENTITY_supe:
    case ENTITY_szlig:
    case ENTITY_tau:
    case ENTITY_there4:
    case ENTITY_theta:
    case ENTITY_thetasym:
    case ENTITY_thinsp:
    case ENTITY_thorn:
    case ENTITY_tilde:
    case ENTITY_times:
    case ENTITY_trade:
    case ENTITY_uArr:
    case ENTITY_uacute:
    case ENTITY_uarr:
    case ENTITY_ucirc:
    case ENTITY_ugrave:
    case ENTITY_uml:
    case ENTITY_upsih:
    case ENTITY_upsilon:
    case ENTITY_uuml:
    case ENTITY_weierp:
    case ENTITY_xi:
    case ENTITY_yacute:
    case ENTITY_yen:
    case ENTITY_yuml:
    case ENTITY_zeta:
    case ENTITY_zwj:
    case ENTITY_zwnj:
    case ENTITY_NUMERIC:
      AttrDecl(attrMap, buffer);
                                                                                    map.put(ATTRIBUTE, attrMap);
      break;
    default:
      jj_la1[25] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ENDTAG:
      jj_consume_token(ENDTAG);
      break;
    case ENDSINGLETAG:
      jj_consume_token(ENDSINGLETAG);
      break;
    default:
      jj_la1[26] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public String Text(StringBuffer buffer) throws ParseException {
  buffer.setLength(0);
    label_11:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OTHER:
        jj_consume_token(OTHER);
             buffer.append(token.image);
        break;
      case ENTITY_AElig:
      case ENTITY_Aacute:
      case ENTITY_Acirc:
      case ENTITY_Agrave:
      case ENTITY_Alpha:
      case ENTITY_Aring:
      case ENTITY_Atilde:
      case ENTITY_Auml:
      case ENTITY_Beta:
      case ENTITY_Ccedil:
      case ENTITY_Chi:
      case ENTITY_Dagger:
      case ENTITY_Delta:
      case ENTITY_ETH:
      case ENTITY_Eacute:
      case ENTITY_Ecirc:
      case ENTITY_Egrave:
      case ENTITY_Epsilon:
      case ENTITY_Eta:
      case ENTITY_Euml:
      case ENTITY_Gamma:
      case ENTITY_Iacute:
      case ENTITY_Icirc:
      case ENTITY_Igrave:
      case ENTITY_Iota:
      case ENTITY_Iuml:
      case ENTITY_Kappa:
      case ENTITY_Lambda:
      case ENTITY_Mu:
      case ENTITY_Ntilde:
      case ENTITY_Nu:
      case ENTITY_OElig:
      case ENTITY_Oacute:
      case ENTITY_Ocirc:
      case ENTITY_Ograve:
      case ENTITY_Omega:
      case ENTITY_Omicron:
      case ENTITY_Oslash:
      case ENTITY_Otilde:
      case ENTITY_Ouml:
      case ENTITY_Phi:
      case ENTITY_Pi:
      case ENTITY_Prime:
      case ENTITY_Psi:
      case ENTITY_Rho:
      case ENTITY_Scaron:
      case ENTITY_Sigma:
      case ENTITY_THORN:
      case ENTITY_Tau:
      case ENTITY_Theta:
      case ENTITY_Uacute:
      case ENTITY_Ucirc:
      case ENTITY_Ugrave:
      case ENTITY_Upsilon:
      case ENTITY_Uuml:
      case ENTITY_Xi:
      case ENTITY_Yacute:
      case ENTITY_Yuml:
      case ENTITY_Zeta:
      case ENTITY_aacute:
      case ENTITY_acirc:
      case ENTITY_acute:
      case ENTITY_aelig:
      case ENTITY_agrave:
      case ENTITY_alefsym:
      case ENTITY_alpha:
      case ENTITY_amp:
      case ENTITY_and:
      case ENTITY_ang:
      case ENTITY_aring:
      case ENTITY_asymp:
      case ENTITY_atilde:
      case ENTITY_auml:
      case ENTITY_bdquo:
      case ENTITY_beta:
      case ENTITY_brvbar:
      case ENTITY_bull:
      case ENTITY_cap:
      case ENTITY_ccedil:
      case ENTITY_cedil:
      case ENTITY_cent:
      case ENTITY_chi:
      case ENTITY_circ:
      case ENTITY_clubs:
      case ENTITY_cong:
      case ENTITY_copy:
      case ENTITY_crarr:
      case ENTITY_cup:
      case ENTITY_curren:
      case ENTITY_dArr:
      case ENTITY_dagger:
      case ENTITY_darr:
      case ENTITY_deg:
      case ENTITY_delta:
      case ENTITY_diams:
      case ENTITY_divide:
      case ENTITY_eacute:
      case ENTITY_ecirc:
      case ENTITY_egrave:
      case ENTITY_empty:
      case ENTITY_emsp:
      case ENTITY_ensp:
      case ENTITY_epsilon:
      case ENTITY_equiv:
      case ENTITY_eta:
      case ENTITY_eth:
      case ENTITY_euml:
      case ENTITY_euro:
      case ENTITY_exist:
      case ENTITY_fnof:
      case ENTITY_forall:
      case ENTITY_frac12:
      case ENTITY_frac14:
      case ENTITY_frac34:
      case ENTITY_frasl:
      case ENTITY_gamma:
      case ENTITY_ge:
      case ENTITY_gt:
      case ENTITY_hArr:
      case ENTITY_harr:
      case ENTITY_hearts:
      case ENTITY_hellip:
      case ENTITY_iacute:
      case ENTITY_icirc:
      case ENTITY_iexcl:
      case ENTITY_igrave:
      case ENTITY_image:
      case ENTITY_infin:
      case ENTITY_int:
      case ENTITY_iota:
      case ENTITY_iquest:
      case ENTITY_isin:
      case ENTITY_iuml:
      case ENTITY_kappa:
      case ENTITY_lArr:
      case ENTITY_lambda:
      case ENTITY_lang:
      case ENTITY_laquo:
      case ENTITY_larr:
      case ENTITY_lceil:
      case ENTITY_ldquo:
      case ENTITY_le:
      case ENTITY_lfloor:
      case ENTITY_lowast:
      case ENTITY_loz:
      case ENTITY_lrm:
      case ENTITY_lsaquo:
      case ENTITY_lsquo:
      case ENTITY_lt:
      case ENTITY_macr:
      case ENTITY_mdash:
      case ENTITY_micro:
      case ENTITY_middot:
      case ENTITY_minus:
      case ENTITY_mu:
      case ENTITY_nabla:
      case ENTITY_nbsp:
      case ENTITY_ndash:
      case ENTITY_ne:
      case ENTITY_ni:
      case ENTITY_not:
      case ENTITY_notin:
      case ENTITY_nsub:
      case ENTITY_ntilde:
      case ENTITY_nu:
      case ENTITY_oacute:
      case ENTITY_ocirc:
      case ENTITY_oelig:
      case ENTITY_ograve:
      case ENTITY_oline:
      case ENTITY_omega:
      case ENTITY_omicron:
      case ENTITY_oplus:
      case ENTITY_or:
      case ENTITY_ordf:
      case ENTITY_ordm:
      case ENTITY_oslash:
      case ENTITY_otilde:
      case ENTITY_otimes:
      case ENTITY_ouml:
      case ENTITY_para:
      case ENTITY_part:
      case ENTITY_permil:
      case ENTITY_perp:
      case ENTITY_phi:
      case ENTITY_pi:
      case ENTITY_piv:
      case ENTITY_plusmn:
      case ENTITY_pound:
      case ENTITY_prime:
      case ENTITY_prod:
      case ENTITY_prop:
      case ENTITY_psi:
      case ENTITY_quot:
      case ENTITY_rArr:
      case ENTITY_radic:
      case ENTITY_rang:
      case ENTITY_raquo:
      case ENTITY_rarr:
      case ENTITY_rceil:
      case ENTITY_rdquo:
      case ENTITY_real:
      case ENTITY_reg:
      case ENTITY_rfloor:
      case ENTITY_rho:
      case ENTITY_rlm:
      case ENTITY_rsaquo:
      case ENTITY_rsquo:
      case ENTITY_sbquo:
      case ENTITY_scaron:
      case ENTITY_sdot:
      case ENTITY_sect:
      case ENTITY_shy:
      case ENTITY_sigma:
      case ENTITY_sigmaf:
      case ENTITY_sim:
      case ENTITY_spades:
      case ENTITY_sub:
      case ENTITY_sube:
      case ENTITY_sum:
      case ENTITY_sup:
      case ENTITY_sup1:
      case ENTITY_sup2:
      case ENTITY_sup3:
      case ENTITY_supe:
      case ENTITY_szlig:
      case ENTITY_tau:
      case ENTITY_there4:
      case ENTITY_theta:
      case ENTITY_thetasym:
      case ENTITY_thinsp:
      case ENTITY_thorn:
      case ENTITY_tilde:
      case ENTITY_times:
      case ENTITY_trade:
      case ENTITY_uArr:
      case ENTITY_uacute:
      case ENTITY_uarr:
      case ENTITY_ucirc:
      case ENTITY_ugrave:
      case ENTITY_uml:
      case ENTITY_upsih:
      case ENTITY_upsilon:
      case ENTITY_uuml:
      case ENTITY_weierp:
      case ENTITY_xi:
      case ENTITY_yacute:
      case ENTITY_yen:
      case ENTITY_yuml:
      case ENTITY_zeta:
      case ENTITY_zwj:
      case ENTITY_zwnj:
      case ENTITY_NUMERIC:
        Entity();
                                                      buffer.append(token.image);
        break;
      default:
        jj_la1[27] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OTHER:
      case ENTITY_AElig:
      case ENTITY_Aacute:
      case ENTITY_Acirc:
      case ENTITY_Agrave:
      case ENTITY_Alpha:
      case ENTITY_Aring:
      case ENTITY_Atilde:
      case ENTITY_Auml:
      case ENTITY_Beta:
      case ENTITY_Ccedil:
      case ENTITY_Chi:
      case ENTITY_Dagger:
      case ENTITY_Delta:
      case ENTITY_ETH:
      case ENTITY_Eacute:
      case ENTITY_Ecirc:
      case ENTITY_Egrave:
      case ENTITY_Epsilon:
      case ENTITY_Eta:
      case ENTITY_Euml:
      case ENTITY_Gamma:
      case ENTITY_Iacute:
      case ENTITY_Icirc:
      case ENTITY_Igrave:
      case ENTITY_Iota:
      case ENTITY_Iuml:
      case ENTITY_Kappa:
      case ENTITY_Lambda:
      case ENTITY_Mu:
      case ENTITY_Ntilde:
      case ENTITY_Nu:
      case ENTITY_OElig:
      case ENTITY_Oacute:
      case ENTITY_Ocirc:
      case ENTITY_Ograve:
      case ENTITY_Omega:
      case ENTITY_Omicron:
      case ENTITY_Oslash:
      case ENTITY_Otilde:
      case ENTITY_Ouml:
      case ENTITY_Phi:
      case ENTITY_Pi:
      case ENTITY_Prime:
      case ENTITY_Psi:
      case ENTITY_Rho:
      case ENTITY_Scaron:
      case ENTITY_Sigma:
      case ENTITY_THORN:
      case ENTITY_Tau:
      case ENTITY_Theta:
      case ENTITY_Uacute:
      case ENTITY_Ucirc:
      case ENTITY_Ugrave:
      case ENTITY_Upsilon:
      case ENTITY_Uuml:
      case ENTITY_Xi:
      case ENTITY_Yacute:
      case ENTITY_Yuml:
      case ENTITY_Zeta:
      case ENTITY_aacute:
      case ENTITY_acirc:
      case ENTITY_acute:
      case ENTITY_aelig:
      case ENTITY_agrave:
      case ENTITY_alefsym:
      case ENTITY_alpha:
      case ENTITY_amp:
      case ENTITY_and:
      case ENTITY_ang:
      case ENTITY_aring:
      case ENTITY_asymp:
      case ENTITY_atilde:
      case ENTITY_auml:
      case ENTITY_bdquo:
      case ENTITY_beta:
      case ENTITY_brvbar:
      case ENTITY_bull:
      case ENTITY_cap:
      case ENTITY_ccedil:
      case ENTITY_cedil:
      case ENTITY_cent:
      case ENTITY_chi:
      case ENTITY_circ:
      case ENTITY_clubs:
      case ENTITY_cong:
      case ENTITY_copy:
      case ENTITY_crarr:
      case ENTITY_cup:
      case ENTITY_curren:
      case ENTITY_dArr:
      case ENTITY_dagger:
      case ENTITY_darr:
      case ENTITY_deg:
      case ENTITY_delta:
      case ENTITY_diams:
      case ENTITY_divide:
      case ENTITY_eacute:
      case ENTITY_ecirc:
      case ENTITY_egrave:
      case ENTITY_empty:
      case ENTITY_emsp:
      case ENTITY_ensp:
      case ENTITY_epsilon:
      case ENTITY_equiv:
      case ENTITY_eta:
      case ENTITY_eth:
      case ENTITY_euml:
      case ENTITY_euro:
      case ENTITY_exist:
      case ENTITY_fnof:
      case ENTITY_forall:
      case ENTITY_frac12:
      case ENTITY_frac14:
      case ENTITY_frac34:
      case ENTITY_frasl:
      case ENTITY_gamma:
      case ENTITY_ge:
      case ENTITY_gt:
      case ENTITY_hArr:
      case ENTITY_harr:
      case ENTITY_hearts:
      case ENTITY_hellip:
      case ENTITY_iacute:
      case ENTITY_icirc:
      case ENTITY_iexcl:
      case ENTITY_igrave:
      case ENTITY_image:
      case ENTITY_infin:
      case ENTITY_int:
      case ENTITY_iota:
      case ENTITY_iquest:
      case ENTITY_isin:
      case ENTITY_iuml:
      case ENTITY_kappa:
      case ENTITY_lArr:
      case ENTITY_lambda:
      case ENTITY_lang:
      case ENTITY_laquo:
      case ENTITY_larr:
      case ENTITY_lceil:
      case ENTITY_ldquo:
      case ENTITY_le:
      case ENTITY_lfloor:
      case ENTITY_lowast:
      case ENTITY_loz:
      case ENTITY_lrm:
      case ENTITY_lsaquo:
      case ENTITY_lsquo:
      case ENTITY_lt:
      case ENTITY_macr:
      case ENTITY_mdash:
      case ENTITY_micro:
      case ENTITY_middot:
      case ENTITY_minus:
      case ENTITY_mu:
      case ENTITY_nabla:
      case ENTITY_nbsp:
      case ENTITY_ndash:
      case ENTITY_ne:
      case ENTITY_ni:
      case ENTITY_not:
      case ENTITY_notin:
      case ENTITY_nsub:
      case ENTITY_ntilde:
      case ENTITY_nu:
      case ENTITY_oacute:
      case ENTITY_ocirc:
      case ENTITY_oelig:
      case ENTITY_ograve:
      case ENTITY_oline:
      case ENTITY_omega:
      case ENTITY_omicron:
      case ENTITY_oplus:
      case ENTITY_or:
      case ENTITY_ordf:
      case ENTITY_ordm:
      case ENTITY_oslash:
      case ENTITY_otilde:
      case ENTITY_otimes:
      case ENTITY_ouml:
      case ENTITY_para:
      case ENTITY_part:
      case ENTITY_permil:
      case ENTITY_perp:
      case ENTITY_phi:
      case ENTITY_pi:
      case ENTITY_piv:
      case ENTITY_plusmn:
      case ENTITY_pound:
      case ENTITY_prime:
      case ENTITY_prod:
      case ENTITY_prop:
      case ENTITY_psi:
      case ENTITY_quot:
      case ENTITY_rArr:
      case ENTITY_radic:
      case ENTITY_rang:
      case ENTITY_raquo:
      case ENTITY_rarr:
      case ENTITY_rceil:
      case ENTITY_rdquo:
      case ENTITY_real:
      case ENTITY_reg:
      case ENTITY_rfloor:
      case ENTITY_rho:
      case ENTITY_rlm:
      case ENTITY_rsaquo:
      case ENTITY_rsquo:
      case ENTITY_sbquo:
      case ENTITY_scaron:
      case ENTITY_sdot:
      case ENTITY_sect:
      case ENTITY_shy:
      case ENTITY_sigma:
      case ENTITY_sigmaf:
      case ENTITY_sim:
      case ENTITY_spades:
      case ENTITY_sub:
      case ENTITY_sube:
      case ENTITY_sum:
      case ENTITY_sup:
      case ENTITY_sup1:
      case ENTITY_sup2:
      case ENTITY_sup3:
      case ENTITY_supe:
      case ENTITY_szlig:
      case ENTITY_tau:
      case ENTITY_there4:
      case ENTITY_theta:
      case ENTITY_thetasym:
      case ENTITY_thinsp:
      case ENTITY_thorn:
      case ENTITY_tilde:
      case ENTITY_times:
      case ENTITY_trade:
      case ENTITY_uArr:
      case ENTITY_uacute:
      case ENTITY_uarr:
      case ENTITY_ucirc:
      case ENTITY_ugrave:
      case ENTITY_uml:
      case ENTITY_upsih:
      case ENTITY_upsilon:
      case ENTITY_uuml:
      case ENTITY_weierp:
      case ENTITY_xi:
      case ENTITY_yacute:
      case ENTITY_yen:
      case ENTITY_yuml:
      case ENTITY_zeta:
      case ENTITY_zwj:
      case ENTITY_zwnj:
      case ENTITY_NUMERIC:
        ;
        break;
      default:
        jj_la1[28] = jj_gen;
        break label_11;
      }
    }
                                                                                      {if (true) return buffer.toString();}
    throw new Error("Missing return statement in function");
  }

  final public Map _getNext(Map map, Map attrMap, StringBuffer buffer) throws ParseException {
  String s;
  map.put(ATTRIBUTE, null);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BEGINTAG:
    case BEGINCLOSETAG:
      Tag(map, attrMap, buffer);
                             {if (true) return map;}
      break;
    case OTHER:
    case ENTITY_AElig:
    case ENTITY_Aacute:
    case ENTITY_Acirc:
    case ENTITY_Agrave:
    case ENTITY_Alpha:
    case ENTITY_Aring:
    case ENTITY_Atilde:
    case ENTITY_Auml:
    case ENTITY_Beta:
    case ENTITY_Ccedil:
    case ENTITY_Chi:
    case ENTITY_Dagger:
    case ENTITY_Delta:
    case ENTITY_ETH:
    case ENTITY_Eacute:
    case ENTITY_Ecirc:
    case ENTITY_Egrave:
    case ENTITY_Epsilon:
    case ENTITY_Eta:
    case ENTITY_Euml:
    case ENTITY_Gamma:
    case ENTITY_Iacute:
    case ENTITY_Icirc:
    case ENTITY_Igrave:
    case ENTITY_Iota:
    case ENTITY_Iuml:
    case ENTITY_Kappa:
    case ENTITY_Lambda:
    case ENTITY_Mu:
    case ENTITY_Ntilde:
    case ENTITY_Nu:
    case ENTITY_OElig:
    case ENTITY_Oacute:
    case ENTITY_Ocirc:
    case ENTITY_Ograve:
    case ENTITY_Omega:
    case ENTITY_Omicron:
    case ENTITY_Oslash:
    case ENTITY_Otilde:
    case ENTITY_Ouml:
    case ENTITY_Phi:
    case ENTITY_Pi:
    case ENTITY_Prime:
    case ENTITY_Psi:
    case ENTITY_Rho:
    case ENTITY_Scaron:
    case ENTITY_Sigma:
    case ENTITY_THORN:
    case ENTITY_Tau:
    case ENTITY_Theta:
    case ENTITY_Uacute:
    case ENTITY_Ucirc:
    case ENTITY_Ugrave:
    case ENTITY_Upsilon:
    case ENTITY_Uuml:
    case ENTITY_Xi:
    case ENTITY_Yacute:
    case ENTITY_Yuml:
    case ENTITY_Zeta:
    case ENTITY_aacute:
    case ENTITY_acirc:
    case ENTITY_acute:
    case ENTITY_aelig:
    case ENTITY_agrave:
    case ENTITY_alefsym:
    case ENTITY_alpha:
    case ENTITY_amp:
    case ENTITY_and:
    case ENTITY_ang:
    case ENTITY_aring:
    case ENTITY_asymp:
    case ENTITY_atilde:
    case ENTITY_auml:
    case ENTITY_bdquo:
    case ENTITY_beta:
    case ENTITY_brvbar:
    case ENTITY_bull:
    case ENTITY_cap:
    case ENTITY_ccedil:
    case ENTITY_cedil:
    case ENTITY_cent:
    case ENTITY_chi:
    case ENTITY_circ:
    case ENTITY_clubs:
    case ENTITY_cong:
    case ENTITY_copy:
    case ENTITY_crarr:
    case ENTITY_cup:
    case ENTITY_curren:
    case ENTITY_dArr:
    case ENTITY_dagger:
    case ENTITY_darr:
    case ENTITY_deg:
    case ENTITY_delta:
    case ENTITY_diams:
    case ENTITY_divide:
    case ENTITY_eacute:
    case ENTITY_ecirc:
    case ENTITY_egrave:
    case ENTITY_empty:
    case ENTITY_emsp:
    case ENTITY_ensp:
    case ENTITY_epsilon:
    case ENTITY_equiv:
    case ENTITY_eta:
    case ENTITY_eth:
    case ENTITY_euml:
    case ENTITY_euro:
    case ENTITY_exist:
    case ENTITY_fnof:
    case ENTITY_forall:
    case ENTITY_frac12:
    case ENTITY_frac14:
    case ENTITY_frac34:
    case ENTITY_frasl:
    case ENTITY_gamma:
    case ENTITY_ge:
    case ENTITY_gt:
    case ENTITY_hArr:
    case ENTITY_harr:
    case ENTITY_hearts:
    case ENTITY_hellip:
    case ENTITY_iacute:
    case ENTITY_icirc:
    case ENTITY_iexcl:
    case ENTITY_igrave:
    case ENTITY_image:
    case ENTITY_infin:
    case ENTITY_int:
    case ENTITY_iota:
    case ENTITY_iquest:
    case ENTITY_isin:
    case ENTITY_iuml:
    case ENTITY_kappa:
    case ENTITY_lArr:
    case ENTITY_lambda:
    case ENTITY_lang:
    case ENTITY_laquo:
    case ENTITY_larr:
    case ENTITY_lceil:
    case ENTITY_ldquo:
    case ENTITY_le:
    case ENTITY_lfloor:
    case ENTITY_lowast:
    case ENTITY_loz:
    case ENTITY_lrm:
    case ENTITY_lsaquo:
    case ENTITY_lsquo:
    case ENTITY_lt:
    case ENTITY_macr:
    case ENTITY_mdash:
    case ENTITY_micro:
    case ENTITY_middot:
    case ENTITY_minus:
    case ENTITY_mu:
    case ENTITY_nabla:
    case ENTITY_nbsp:
    case ENTITY_ndash:
    case ENTITY_ne:
    case ENTITY_ni:
    case ENTITY_not:
    case ENTITY_notin:
    case ENTITY_nsub:
    case ENTITY_ntilde:
    case ENTITY_nu:
    case ENTITY_oacute:
    case ENTITY_ocirc:
    case ENTITY_oelig:
    case ENTITY_ograve:
    case ENTITY_oline:
    case ENTITY_omega:
    case ENTITY_omicron:
    case ENTITY_oplus:
    case ENTITY_or:
    case ENTITY_ordf:
    case ENTITY_ordm:
    case ENTITY_oslash:
    case ENTITY_otilde:
    case ENTITY_otimes:
    case ENTITY_ouml:
    case ENTITY_para:
    case ENTITY_part:
    case ENTITY_permil:
    case ENTITY_perp:
    case ENTITY_phi:
    case ENTITY_pi:
    case ENTITY_piv:
    case ENTITY_plusmn:
    case ENTITY_pound:
    case ENTITY_prime:
    case ENTITY_prod:
    case ENTITY_prop:
    case ENTITY_psi:
    case ENTITY_quot:
    case ENTITY_rArr:
    case ENTITY_radic:
    case ENTITY_rang:
    case ENTITY_raquo:
    case ENTITY_rarr:
    case ENTITY_rceil:
    case ENTITY_rdquo:
    case ENTITY_real:
    case ENTITY_reg:
    case ENTITY_rfloor:
    case ENTITY_rho:
    case ENTITY_rlm:
    case ENTITY_rsaquo:
    case ENTITY_rsquo:
    case ENTITY_sbquo:
    case ENTITY_scaron:
    case ENTITY_sdot:
    case ENTITY_sect:
    case ENTITY_shy:
    case ENTITY_sigma:
    case ENTITY_sigmaf:
    case ENTITY_sim:
    case ENTITY_spades:
    case ENTITY_sub:
    case ENTITY_sube:
    case ENTITY_sum:
    case ENTITY_sup:
    case ENTITY_sup1:
    case ENTITY_sup2:
    case ENTITY_sup3:
    case ENTITY_supe:
    case ENTITY_szlig:
    case ENTITY_tau:
    case ENTITY_there4:
    case ENTITY_theta:
    case ENTITY_thetasym:
    case ENTITY_thinsp:
    case ENTITY_thorn:
    case ENTITY_tilde:
    case ENTITY_times:
    case ENTITY_trade:
    case ENTITY_uArr:
    case ENTITY_uacute:
    case ENTITY_uarr:
    case ENTITY_ucirc:
    case ENTITY_ugrave:
    case ENTITY_uml:
    case ENTITY_upsih:
    case ENTITY_upsilon:
    case ENTITY_uuml:
    case ENTITY_weierp:
    case ENTITY_xi:
    case ENTITY_yacute:
    case ENTITY_yen:
    case ENTITY_yuml:
    case ENTITY_zeta:
    case ENTITY_zwj:
    case ENTITY_zwnj:
    case ENTITY_NUMERIC:
      s = Text(buffer);
                  map.put(TYPE, TEXT); map.put(VALUE, s); {if (true) return map;}
      break;
    case BEGINCOMMENT:
      s = Comment(buffer);
                     map.put(TYPE, COMMENT); map.put(VALUE, s); {if (true) return map;}
      break;
    case BEGINSCRIPT:
      Script(map, attrMap, buffer);
                                {if (true) return map;}
      break;
    case BEGINSTYLE:
      Style(map, attrMap, buffer);
                               {if (true) return map;}
      break;
    case BEGINSGML:
      s = SGML(buffer);
                  map.put(TYPE, SGML); map.put(VALUE, s); {if (true) return map;}
      break;
    case BEGINPI:
      s = PI(buffer);
                map.put(TYPE, PI); map.put(VALUE, s); {if (true) return map;}
      break;
    case 0:
      jj_consume_token(0);
         {if (true) return null;}
      break;
    default:
      jj_la1[29] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public void Entity() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ENTITY_AElig:
      jj_consume_token(ENTITY_AElig);
      break;
    case ENTITY_Aacute:
      jj_consume_token(ENTITY_Aacute);
      break;
    case ENTITY_Acirc:
      jj_consume_token(ENTITY_Acirc);
      break;
    case ENTITY_Agrave:
      jj_consume_token(ENTITY_Agrave);
      break;
    case ENTITY_Alpha:
      jj_consume_token(ENTITY_Alpha);
      break;
    case ENTITY_Aring:
      jj_consume_token(ENTITY_Aring);
      break;
    case ENTITY_Atilde:
      jj_consume_token(ENTITY_Atilde);
      break;
    case ENTITY_Auml:
      jj_consume_token(ENTITY_Auml);
      break;
    case ENTITY_Beta:
      jj_consume_token(ENTITY_Beta);
      break;
    case ENTITY_Ccedil:
      jj_consume_token(ENTITY_Ccedil);
      break;
    case ENTITY_Chi:
      jj_consume_token(ENTITY_Chi);
      break;
    case ENTITY_Dagger:
      jj_consume_token(ENTITY_Dagger);
      break;
    case ENTITY_Delta:
      jj_consume_token(ENTITY_Delta);
      break;
    case ENTITY_ETH:
      jj_consume_token(ENTITY_ETH);
      break;
    case ENTITY_Eacute:
      jj_consume_token(ENTITY_Eacute);
      break;
    case ENTITY_Ecirc:
      jj_consume_token(ENTITY_Ecirc);
      break;
    case ENTITY_Egrave:
      jj_consume_token(ENTITY_Egrave);
      break;
    case ENTITY_Epsilon:
      jj_consume_token(ENTITY_Epsilon);
      break;
    case ENTITY_Eta:
      jj_consume_token(ENTITY_Eta);
      break;
    case ENTITY_Euml:
      jj_consume_token(ENTITY_Euml);
      break;
    case ENTITY_Gamma:
      jj_consume_token(ENTITY_Gamma);
      break;
    case ENTITY_Iacute:
      jj_consume_token(ENTITY_Iacute);
      break;
    case ENTITY_Icirc:
      jj_consume_token(ENTITY_Icirc);
      break;
    case ENTITY_Igrave:
      jj_consume_token(ENTITY_Igrave);
      break;
    case ENTITY_Iota:
      jj_consume_token(ENTITY_Iota);
      break;
    case ENTITY_Iuml:
      jj_consume_token(ENTITY_Iuml);
      break;
    case ENTITY_Kappa:
      jj_consume_token(ENTITY_Kappa);
      break;
    case ENTITY_Lambda:
      jj_consume_token(ENTITY_Lambda);
      break;
    case ENTITY_Mu:
      jj_consume_token(ENTITY_Mu);
      break;
    case ENTITY_Ntilde:
      jj_consume_token(ENTITY_Ntilde);
      break;
    case ENTITY_Nu:
      jj_consume_token(ENTITY_Nu);
      break;
    case ENTITY_OElig:
      jj_consume_token(ENTITY_OElig);
      break;
    case ENTITY_Oacute:
      jj_consume_token(ENTITY_Oacute);
      break;
    case ENTITY_Ocirc:
      jj_consume_token(ENTITY_Ocirc);
      break;
    case ENTITY_Ograve:
      jj_consume_token(ENTITY_Ograve);
      break;
    case ENTITY_Omega:
      jj_consume_token(ENTITY_Omega);
      break;
    case ENTITY_Omicron:
      jj_consume_token(ENTITY_Omicron);
      break;
    case ENTITY_Oslash:
      jj_consume_token(ENTITY_Oslash);
      break;
    case ENTITY_Otilde:
      jj_consume_token(ENTITY_Otilde);
      break;
    case ENTITY_Ouml:
      jj_consume_token(ENTITY_Ouml);
      break;
    case ENTITY_Phi:
      jj_consume_token(ENTITY_Phi);
      break;
    case ENTITY_Pi:
      jj_consume_token(ENTITY_Pi);
      break;
    case ENTITY_Prime:
      jj_consume_token(ENTITY_Prime);
      break;
    case ENTITY_Psi:
      jj_consume_token(ENTITY_Psi);
      break;
    case ENTITY_Rho:
      jj_consume_token(ENTITY_Rho);
      break;
    case ENTITY_Scaron:
      jj_consume_token(ENTITY_Scaron);
      break;
    case ENTITY_Sigma:
      jj_consume_token(ENTITY_Sigma);
      break;
    case ENTITY_THORN:
      jj_consume_token(ENTITY_THORN);
      break;
    case ENTITY_Tau:
      jj_consume_token(ENTITY_Tau);
      break;
    case ENTITY_Theta:
      jj_consume_token(ENTITY_Theta);
      break;
    case ENTITY_Uacute:
      jj_consume_token(ENTITY_Uacute);
      break;
    case ENTITY_Ucirc:
      jj_consume_token(ENTITY_Ucirc);
      break;
    case ENTITY_Ugrave:
      jj_consume_token(ENTITY_Ugrave);
      break;
    case ENTITY_Upsilon:
      jj_consume_token(ENTITY_Upsilon);
      break;
    case ENTITY_Uuml:
      jj_consume_token(ENTITY_Uuml);
      break;
    case ENTITY_Xi:
      jj_consume_token(ENTITY_Xi);
      break;
    case ENTITY_Yacute:
      jj_consume_token(ENTITY_Yacute);
      break;
    case ENTITY_Yuml:
      jj_consume_token(ENTITY_Yuml);
      break;
    case ENTITY_Zeta:
      jj_consume_token(ENTITY_Zeta);
      break;
    case ENTITY_aacute:
      jj_consume_token(ENTITY_aacute);
      break;
    case ENTITY_acirc:
      jj_consume_token(ENTITY_acirc);
      break;
    case ENTITY_acute:
      jj_consume_token(ENTITY_acute);
      break;
    case ENTITY_aelig:
      jj_consume_token(ENTITY_aelig);
      break;
    case ENTITY_agrave:
      jj_consume_token(ENTITY_agrave);
      break;
    case ENTITY_alefsym:
      jj_consume_token(ENTITY_alefsym);
      break;
    case ENTITY_alpha:
      jj_consume_token(ENTITY_alpha);
      break;
    case ENTITY_amp:
      jj_consume_token(ENTITY_amp);
      break;
    case ENTITY_and:
      jj_consume_token(ENTITY_and);
      break;
    case ENTITY_ang:
      jj_consume_token(ENTITY_ang);
      break;
    case ENTITY_aring:
      jj_consume_token(ENTITY_aring);
      break;
    case ENTITY_asymp:
      jj_consume_token(ENTITY_asymp);
      break;
    case ENTITY_atilde:
      jj_consume_token(ENTITY_atilde);
      break;
    case ENTITY_auml:
      jj_consume_token(ENTITY_auml);
      break;
    case ENTITY_bdquo:
      jj_consume_token(ENTITY_bdquo);
      break;
    case ENTITY_beta:
      jj_consume_token(ENTITY_beta);
      break;
    case ENTITY_brvbar:
      jj_consume_token(ENTITY_brvbar);
      break;
    case ENTITY_bull:
      jj_consume_token(ENTITY_bull);
      break;
    case ENTITY_cap:
      jj_consume_token(ENTITY_cap);
      break;
    case ENTITY_ccedil:
      jj_consume_token(ENTITY_ccedil);
      break;
    case ENTITY_cedil:
      jj_consume_token(ENTITY_cedil);
      break;
    case ENTITY_cent:
      jj_consume_token(ENTITY_cent);
      break;
    case ENTITY_chi:
      jj_consume_token(ENTITY_chi);
      break;
    case ENTITY_circ:
      jj_consume_token(ENTITY_circ);
      break;
    case ENTITY_clubs:
      jj_consume_token(ENTITY_clubs);
      break;
    case ENTITY_cong:
      jj_consume_token(ENTITY_cong);
      break;
    case ENTITY_copy:
      jj_consume_token(ENTITY_copy);
      break;
    case ENTITY_crarr:
      jj_consume_token(ENTITY_crarr);
      break;
    case ENTITY_cup:
      jj_consume_token(ENTITY_cup);
      break;
    case ENTITY_curren:
      jj_consume_token(ENTITY_curren);
      break;
    case ENTITY_dArr:
      jj_consume_token(ENTITY_dArr);
      break;
    case ENTITY_dagger:
      jj_consume_token(ENTITY_dagger);
      break;
    case ENTITY_darr:
      jj_consume_token(ENTITY_darr);
      break;
    case ENTITY_deg:
      jj_consume_token(ENTITY_deg);
      break;
    case ENTITY_delta:
      jj_consume_token(ENTITY_delta);
      break;
    case ENTITY_diams:
      jj_consume_token(ENTITY_diams);
      break;
    case ENTITY_divide:
      jj_consume_token(ENTITY_divide);
      break;
    case ENTITY_eacute:
      jj_consume_token(ENTITY_eacute);
      break;
    case ENTITY_ecirc:
      jj_consume_token(ENTITY_ecirc);
      break;
    case ENTITY_egrave:
      jj_consume_token(ENTITY_egrave);
      break;
    case ENTITY_empty:
      jj_consume_token(ENTITY_empty);
      break;
    case ENTITY_emsp:
      jj_consume_token(ENTITY_emsp);
      break;
    case ENTITY_ensp:
      jj_consume_token(ENTITY_ensp);
      break;
    case ENTITY_epsilon:
      jj_consume_token(ENTITY_epsilon);
      break;
    case ENTITY_equiv:
      jj_consume_token(ENTITY_equiv);
      break;
    case ENTITY_eta:
      jj_consume_token(ENTITY_eta);
      break;
    case ENTITY_eth:
      jj_consume_token(ENTITY_eth);
      break;
    case ENTITY_euml:
      jj_consume_token(ENTITY_euml);
      break;
    case ENTITY_euro:
      jj_consume_token(ENTITY_euro);
      break;
    case ENTITY_exist:
      jj_consume_token(ENTITY_exist);
      break;
    case ENTITY_fnof:
      jj_consume_token(ENTITY_fnof);
      break;
    case ENTITY_forall:
      jj_consume_token(ENTITY_forall);
      break;
    case ENTITY_frac12:
      jj_consume_token(ENTITY_frac12);
      break;
    case ENTITY_frac14:
      jj_consume_token(ENTITY_frac14);
      break;
    case ENTITY_frac34:
      jj_consume_token(ENTITY_frac34);
      break;
    case ENTITY_frasl:
      jj_consume_token(ENTITY_frasl);
      break;
    case ENTITY_gamma:
      jj_consume_token(ENTITY_gamma);
      break;
    case ENTITY_ge:
      jj_consume_token(ENTITY_ge);
      break;
    case ENTITY_gt:
      jj_consume_token(ENTITY_gt);
      break;
    case ENTITY_hArr:
      jj_consume_token(ENTITY_hArr);
      break;
    case ENTITY_harr:
      jj_consume_token(ENTITY_harr);
      break;
    case ENTITY_hearts:
      jj_consume_token(ENTITY_hearts);
      break;
    case ENTITY_hellip:
      jj_consume_token(ENTITY_hellip);
      break;
    case ENTITY_iacute:
      jj_consume_token(ENTITY_iacute);
      break;
    case ENTITY_icirc:
      jj_consume_token(ENTITY_icirc);
      break;
    case ENTITY_iexcl:
      jj_consume_token(ENTITY_iexcl);
      break;
    case ENTITY_igrave:
      jj_consume_token(ENTITY_igrave);
      break;
    case ENTITY_image:
      jj_consume_token(ENTITY_image);
      break;
    case ENTITY_infin:
      jj_consume_token(ENTITY_infin);
      break;
    case ENTITY_int:
      jj_consume_token(ENTITY_int);
      break;
    case ENTITY_iota:
      jj_consume_token(ENTITY_iota);
      break;
    case ENTITY_iquest:
      jj_consume_token(ENTITY_iquest);
      break;
    case ENTITY_isin:
      jj_consume_token(ENTITY_isin);
      break;
    case ENTITY_iuml:
      jj_consume_token(ENTITY_iuml);
      break;
    case ENTITY_kappa:
      jj_consume_token(ENTITY_kappa);
      break;
    case ENTITY_lArr:
      jj_consume_token(ENTITY_lArr);
      break;
    case ENTITY_lambda:
      jj_consume_token(ENTITY_lambda);
      break;
    case ENTITY_lang:
      jj_consume_token(ENTITY_lang);
      break;
    case ENTITY_laquo:
      jj_consume_token(ENTITY_laquo);
      break;
    case ENTITY_larr:
      jj_consume_token(ENTITY_larr);
      break;
    case ENTITY_lceil:
      jj_consume_token(ENTITY_lceil);
      break;
    case ENTITY_ldquo:
      jj_consume_token(ENTITY_ldquo);
      break;
    case ENTITY_le:
      jj_consume_token(ENTITY_le);
      break;
    case ENTITY_lfloor:
      jj_consume_token(ENTITY_lfloor);
      break;
    case ENTITY_lowast:
      jj_consume_token(ENTITY_lowast);
      break;
    case ENTITY_loz:
      jj_consume_token(ENTITY_loz);
      break;
    case ENTITY_lrm:
      jj_consume_token(ENTITY_lrm);
      break;
    case ENTITY_lsaquo:
      jj_consume_token(ENTITY_lsaquo);
      break;
    case ENTITY_lsquo:
      jj_consume_token(ENTITY_lsquo);
      break;
    case ENTITY_lt:
      jj_consume_token(ENTITY_lt);
      break;
    case ENTITY_macr:
      jj_consume_token(ENTITY_macr);
      break;
    case ENTITY_mdash:
      jj_consume_token(ENTITY_mdash);
      break;
    case ENTITY_micro:
      jj_consume_token(ENTITY_micro);
      break;
    case ENTITY_middot:
      jj_consume_token(ENTITY_middot);
      break;
    case ENTITY_minus:
      jj_consume_token(ENTITY_minus);
      break;
    case ENTITY_mu:
      jj_consume_token(ENTITY_mu);
      break;
    case ENTITY_nabla:
      jj_consume_token(ENTITY_nabla);
      break;
    case ENTITY_nbsp:
      jj_consume_token(ENTITY_nbsp);
      break;
    case ENTITY_ndash:
      jj_consume_token(ENTITY_ndash);
      break;
    case ENTITY_ne:
      jj_consume_token(ENTITY_ne);
      break;
    case ENTITY_ni:
      jj_consume_token(ENTITY_ni);
      break;
    case ENTITY_not:
      jj_consume_token(ENTITY_not);
      break;
    case ENTITY_notin:
      jj_consume_token(ENTITY_notin);
      break;
    case ENTITY_nsub:
      jj_consume_token(ENTITY_nsub);
      break;
    case ENTITY_ntilde:
      jj_consume_token(ENTITY_ntilde);
      break;
    case ENTITY_nu:
      jj_consume_token(ENTITY_nu);
      break;
    case ENTITY_oacute:
      jj_consume_token(ENTITY_oacute);
      break;
    case ENTITY_ocirc:
      jj_consume_token(ENTITY_ocirc);
      break;
    case ENTITY_oelig:
      jj_consume_token(ENTITY_oelig);
      break;
    case ENTITY_ograve:
      jj_consume_token(ENTITY_ograve);
      break;
    case ENTITY_oline:
      jj_consume_token(ENTITY_oline);
      break;
    case ENTITY_omega:
      jj_consume_token(ENTITY_omega);
      break;
    case ENTITY_omicron:
      jj_consume_token(ENTITY_omicron);
      break;
    case ENTITY_oplus:
      jj_consume_token(ENTITY_oplus);
      break;
    case ENTITY_or:
      jj_consume_token(ENTITY_or);
      break;
    case ENTITY_ordf:
      jj_consume_token(ENTITY_ordf);
      break;
    case ENTITY_ordm:
      jj_consume_token(ENTITY_ordm);
      break;
    case ENTITY_oslash:
      jj_consume_token(ENTITY_oslash);
      break;
    case ENTITY_otilde:
      jj_consume_token(ENTITY_otilde);
      break;
    case ENTITY_otimes:
      jj_consume_token(ENTITY_otimes);
      break;
    case ENTITY_ouml:
      jj_consume_token(ENTITY_ouml);
      break;
    case ENTITY_para:
      jj_consume_token(ENTITY_para);
      break;
    case ENTITY_part:
      jj_consume_token(ENTITY_part);
      break;
    case ENTITY_permil:
      jj_consume_token(ENTITY_permil);
      break;
    case ENTITY_perp:
      jj_consume_token(ENTITY_perp);
      break;
    case ENTITY_phi:
      jj_consume_token(ENTITY_phi);
      break;
    case ENTITY_pi:
      jj_consume_token(ENTITY_pi);
      break;
    case ENTITY_piv:
      jj_consume_token(ENTITY_piv);
      break;
    case ENTITY_plusmn:
      jj_consume_token(ENTITY_plusmn);
      break;
    case ENTITY_pound:
      jj_consume_token(ENTITY_pound);
      break;
    case ENTITY_prime:
      jj_consume_token(ENTITY_prime);
      break;
    case ENTITY_prod:
      jj_consume_token(ENTITY_prod);
      break;
    case ENTITY_prop:
      jj_consume_token(ENTITY_prop);
      break;
    case ENTITY_psi:
      jj_consume_token(ENTITY_psi);
      break;
    case ENTITY_quot:
      jj_consume_token(ENTITY_quot);
      break;
    case ENTITY_rArr:
      jj_consume_token(ENTITY_rArr);
      break;
    case ENTITY_radic:
      jj_consume_token(ENTITY_radic);
      break;
    case ENTITY_rang:
      jj_consume_token(ENTITY_rang);
      break;
    case ENTITY_raquo:
      jj_consume_token(ENTITY_raquo);
      break;
    case ENTITY_rarr:
      jj_consume_token(ENTITY_rarr);
      break;
    case ENTITY_rceil:
      jj_consume_token(ENTITY_rceil);
      break;
    case ENTITY_rdquo:
      jj_consume_token(ENTITY_rdquo);
      break;
    case ENTITY_real:
      jj_consume_token(ENTITY_real);
      break;
    case ENTITY_reg:
      jj_consume_token(ENTITY_reg);
      break;
    case ENTITY_rfloor:
      jj_consume_token(ENTITY_rfloor);
      break;
    case ENTITY_rho:
      jj_consume_token(ENTITY_rho);
      break;
    case ENTITY_rlm:
      jj_consume_token(ENTITY_rlm);
      break;
    case ENTITY_rsaquo:
      jj_consume_token(ENTITY_rsaquo);
      break;
    case ENTITY_rsquo:
      jj_consume_token(ENTITY_rsquo);
      break;
    case ENTITY_sbquo:
      jj_consume_token(ENTITY_sbquo);
      break;
    case ENTITY_scaron:
      jj_consume_token(ENTITY_scaron);
      break;
    case ENTITY_sdot:
      jj_consume_token(ENTITY_sdot);
      break;
    case ENTITY_sect:
      jj_consume_token(ENTITY_sect);
      break;
    case ENTITY_shy:
      jj_consume_token(ENTITY_shy);
      break;
    case ENTITY_sigma:
      jj_consume_token(ENTITY_sigma);
      break;
    case ENTITY_sigmaf:
      jj_consume_token(ENTITY_sigmaf);
      break;
    case ENTITY_sim:
      jj_consume_token(ENTITY_sim);
      break;
    case ENTITY_spades:
      jj_consume_token(ENTITY_spades);
      break;
    case ENTITY_sub:
      jj_consume_token(ENTITY_sub);
      break;
    case ENTITY_sube:
      jj_consume_token(ENTITY_sube);
      break;
    case ENTITY_sum:
      jj_consume_token(ENTITY_sum);
      break;
    case ENTITY_sup:
      jj_consume_token(ENTITY_sup);
      break;
    case ENTITY_sup1:
      jj_consume_token(ENTITY_sup1);
      break;
    case ENTITY_sup2:
      jj_consume_token(ENTITY_sup2);
      break;
    case ENTITY_sup3:
      jj_consume_token(ENTITY_sup3);
      break;
    case ENTITY_supe:
      jj_consume_token(ENTITY_supe);
      break;
    case ENTITY_szlig:
      jj_consume_token(ENTITY_szlig);
      break;
    case ENTITY_tau:
      jj_consume_token(ENTITY_tau);
      break;
    case ENTITY_there4:
      jj_consume_token(ENTITY_there4);
      break;
    case ENTITY_theta:
      jj_consume_token(ENTITY_theta);
      break;
    case ENTITY_thetasym:
      jj_consume_token(ENTITY_thetasym);
      break;
    case ENTITY_thinsp:
      jj_consume_token(ENTITY_thinsp);
      break;
    case ENTITY_thorn:
      jj_consume_token(ENTITY_thorn);
      break;
    case ENTITY_tilde:
      jj_consume_token(ENTITY_tilde);
      break;
    case ENTITY_times:
      jj_consume_token(ENTITY_times);
      break;
    case ENTITY_trade:
      jj_consume_token(ENTITY_trade);
      break;
    case ENTITY_uArr:
      jj_consume_token(ENTITY_uArr);
      break;
    case ENTITY_uacute:
      jj_consume_token(ENTITY_uacute);
      break;
    case ENTITY_uarr:
      jj_consume_token(ENTITY_uarr);
      break;
    case ENTITY_ucirc:
      jj_consume_token(ENTITY_ucirc);
      break;
    case ENTITY_ugrave:
      jj_consume_token(ENTITY_ugrave);
      break;
    case ENTITY_uml:
      jj_consume_token(ENTITY_uml);
      break;
    case ENTITY_upsih:
      jj_consume_token(ENTITY_upsih);
      break;
    case ENTITY_upsilon:
      jj_consume_token(ENTITY_upsilon);
      break;
    case ENTITY_uuml:
      jj_consume_token(ENTITY_uuml);
      break;
    case ENTITY_weierp:
      jj_consume_token(ENTITY_weierp);
      break;
    case ENTITY_xi:
      jj_consume_token(ENTITY_xi);
      break;
    case ENTITY_yacute:
      jj_consume_token(ENTITY_yacute);
      break;
    case ENTITY_yen:
      jj_consume_token(ENTITY_yen);
      break;
    case ENTITY_yuml:
      jj_consume_token(ENTITY_yuml);
      break;
    case ENTITY_zeta:
      jj_consume_token(ENTITY_zeta);
      break;
    case ENTITY_zwj:
      jj_consume_token(ENTITY_zwj);
      break;
    case ENTITY_zwnj:
      jj_consume_token(ENTITY_zwnj);
      break;
    case ENTITY_NUMERIC:
      jj_consume_token(ENTITY_NUMERIC);
      break;
    default:
      jj_la1[30] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }

  }

  final private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  final private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  final private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  final private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  final private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  final private boolean jj_3R_22() {
    if (jj_scan_token(BEGINSINGLEQUOTE)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_24()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(ENDSINGLEQUOTE)) return true;
    return false;
  }

  final private boolean jj_3_5() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(21)) jj_scanpos = xsp;
    if (jj_scan_token(EQUAL)) return true;
    xsp = jj_scanpos;
    if (jj_3_3()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_4()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_18() {
    if (jj_3R_22()) return true;
    return false;
  }

  final private boolean jj_3R_21() {
    if (jj_scan_token(BEGINDOUBLEQUOTE)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_23()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(ENDDOUBLEQUOTE)) return true;
    return false;
  }

  final private boolean jj_3R_15() {
    if (jj_3R_19()) return true;
    return false;
  }

  final private boolean jj_3_3() {
    if (jj_scan_token(WHITESPACE)) return true;
    return false;
  }

  final private boolean jj_3R_16() {
    if (jj_3R_20()) return true;
    return false;
  }

  final private boolean jj_3R_14() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(27)) {
    jj_scanpos = xsp;
    if (jj_scan_token(24)) return true;
    }
    return false;
  }

  final private boolean jj_3R_19() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(32)) {
    jj_scanpos = xsp;
    if (jj_scan_token(33)) {
    jj_scanpos = xsp;
    if (jj_scan_token(34)) {
    jj_scanpos = xsp;
    if (jj_scan_token(35)) {
    jj_scanpos = xsp;
    if (jj_scan_token(36)) {
    jj_scanpos = xsp;
    if (jj_scan_token(37)) {
    jj_scanpos = xsp;
    if (jj_scan_token(38)) {
    jj_scanpos = xsp;
    if (jj_scan_token(39)) {
    jj_scanpos = xsp;
    if (jj_scan_token(40)) {
    jj_scanpos = xsp;
    if (jj_scan_token(41)) {
    jj_scanpos = xsp;
    if (jj_scan_token(42)) {
    jj_scanpos = xsp;
    if (jj_scan_token(43)) {
    jj_scanpos = xsp;
    if (jj_scan_token(44)) {
    jj_scanpos = xsp;
    if (jj_scan_token(45)) {
    jj_scanpos = xsp;
    if (jj_scan_token(46)) {
    jj_scanpos = xsp;
    if (jj_scan_token(47)) {
    jj_scanpos = xsp;
    if (jj_scan_token(48)) {
    jj_scanpos = xsp;
    if (jj_scan_token(49)) {
    jj_scanpos = xsp;
    if (jj_scan_token(50)) {
    jj_scanpos = xsp;
    if (jj_scan_token(51)) {
    jj_scanpos = xsp;
    if (jj_scan_token(52)) {
    jj_scanpos = xsp;
    if (jj_scan_token(53)) {
    jj_scanpos = xsp;
    if (jj_scan_token(54)) {
    jj_scanpos = xsp;
    if (jj_scan_token(55)) {
    jj_scanpos = xsp;
    if (jj_scan_token(56)) {
    jj_scanpos = xsp;
    if (jj_scan_token(57)) {
    jj_scanpos = xsp;
    if (jj_scan_token(58)) {
    jj_scanpos = xsp;
    if (jj_scan_token(59)) {
    jj_scanpos = xsp;
    if (jj_scan_token(60)) {
    jj_scanpos = xsp;
    if (jj_scan_token(61)) {
    jj_scanpos = xsp;
    if (jj_scan_token(62)) {
    jj_scanpos = xsp;
    if (jj_scan_token(63)) {
    jj_scanpos = xsp;
    if (jj_scan_token(64)) {
    jj_scanpos = xsp;
    if (jj_scan_token(65)) {
    jj_scanpos = xsp;
    if (jj_scan_token(66)) {
    jj_scanpos = xsp;
    if (jj_scan_token(67)) {
    jj_scanpos = xsp;
    if (jj_scan_token(68)) {
    jj_scanpos = xsp;
    if (jj_scan_token(69)) {
    jj_scanpos = xsp;
    if (jj_scan_token(70)) {
    jj_scanpos = xsp;
    if (jj_scan_token(71)) {
    jj_scanpos = xsp;
    if (jj_scan_token(72)) {
    jj_scanpos = xsp;
    if (jj_scan_token(73)) {
    jj_scanpos = xsp;
    if (jj_scan_token(74)) {
    jj_scanpos = xsp;
    if (jj_scan_token(75)) {
    jj_scanpos = xsp;
    if (jj_scan_token(76)) {
    jj_scanpos = xsp;
    if (jj_scan_token(77)) {
    jj_scanpos = xsp;
    if (jj_scan_token(78)) {
    jj_scanpos = xsp;
    if (jj_scan_token(79)) {
    jj_scanpos = xsp;
    if (jj_scan_token(80)) {
    jj_scanpos = xsp;
    if (jj_scan_token(81)) {
    jj_scanpos = xsp;
    if (jj_scan_token(82)) {
    jj_scanpos = xsp;
    if (jj_scan_token(83)) {
    jj_scanpos = xsp;
    if (jj_scan_token(84)) {
    jj_scanpos = xsp;
    if (jj_scan_token(85)) {
    jj_scanpos = xsp;
    if (jj_scan_token(86)) {
    jj_scanpos = xsp;
    if (jj_scan_token(87)) {
    jj_scanpos = xsp;
    if (jj_scan_token(88)) {
    jj_scanpos = xsp;
    if (jj_scan_token(89)) {
    jj_scanpos = xsp;
    if (jj_scan_token(90)) {
    jj_scanpos = xsp;
    if (jj_scan_token(91)) {
    jj_scanpos = xsp;
    if (jj_scan_token(92)) {
    jj_scanpos = xsp;
    if (jj_scan_token(93)) {
    jj_scanpos = xsp;
    if (jj_scan_token(94)) {
    jj_scanpos = xsp;
    if (jj_scan_token(95)) {
    jj_scanpos = xsp;
    if (jj_scan_token(96)) {
    jj_scanpos = xsp;
    if (jj_scan_token(97)) {
    jj_scanpos = xsp;
    if (jj_scan_token(98)) {
    jj_scanpos = xsp;
    if (jj_scan_token(99)) {
    jj_scanpos = xsp;
    if (jj_scan_token(100)) {
    jj_scanpos = xsp;
    if (jj_scan_token(101)) {
    jj_scanpos = xsp;
    if (jj_scan_token(102)) {
    jj_scanpos = xsp;
    if (jj_scan_token(103)) {
    jj_scanpos = xsp;
    if (jj_scan_token(104)) {
    jj_scanpos = xsp;
    if (jj_scan_token(105)) {
    jj_scanpos = xsp;
    if (jj_scan_token(106)) {
    jj_scanpos = xsp;
    if (jj_scan_token(107)) {
    jj_scanpos = xsp;
    if (jj_scan_token(108)) {
    jj_scanpos = xsp;
    if (jj_scan_token(109)) {
    jj_scanpos = xsp;
    if (jj_scan_token(110)) {
    jj_scanpos = xsp;
    if (jj_scan_token(111)) {
    jj_scanpos = xsp;
    if (jj_scan_token(112)) {
    jj_scanpos = xsp;
    if (jj_scan_token(113)) {
    jj_scanpos = xsp;
    if (jj_scan_token(114)) {
    jj_scanpos = xsp;
    if (jj_scan_token(115)) {
    jj_scanpos = xsp;
    if (jj_scan_token(116)) {
    jj_scanpos = xsp;
    if (jj_scan_token(117)) {
    jj_scanpos = xsp;
    if (jj_scan_token(118)) {
    jj_scanpos = xsp;
    if (jj_scan_token(119)) {
    jj_scanpos = xsp;
    if (jj_scan_token(120)) {
    jj_scanpos = xsp;
    if (jj_scan_token(121)) {
    jj_scanpos = xsp;
    if (jj_scan_token(122)) {
    jj_scanpos = xsp;
    if (jj_scan_token(123)) {
    jj_scanpos = xsp;
    if (jj_scan_token(124)) {
    jj_scanpos = xsp;
    if (jj_scan_token(125)) {
    jj_scanpos = xsp;
    if (jj_scan_token(126)) {
    jj_scanpos = xsp;
    if (jj_scan_token(127)) {
    jj_scanpos = xsp;
    if (jj_scan_token(128)) {
    jj_scanpos = xsp;
    if (jj_scan_token(129)) {
    jj_scanpos = xsp;
    if (jj_scan_token(130)) {
    jj_scanpos = xsp;
    if (jj_scan_token(131)) {
    jj_scanpos = xsp;
    if (jj_scan_token(132)) {
    jj_scanpos = xsp;
    if (jj_scan_token(133)) {
    jj_scanpos = xsp;
    if (jj_scan_token(134)) {
    jj_scanpos = xsp;
    if (jj_scan_token(135)) {
    jj_scanpos = xsp;
    if (jj_scan_token(136)) {
    jj_scanpos = xsp;
    if (jj_scan_token(137)) {
    jj_scanpos = xsp;
    if (jj_scan_token(138)) {
    jj_scanpos = xsp;
    if (jj_scan_token(139)) {
    jj_scanpos = xsp;
    if (jj_scan_token(140)) {
    jj_scanpos = xsp;
    if (jj_scan_token(141)) {
    jj_scanpos = xsp;
    if (jj_scan_token(142)) {
    jj_scanpos = xsp;
    if (jj_scan_token(143)) {
    jj_scanpos = xsp;
    if (jj_scan_token(144)) {
    jj_scanpos = xsp;
    if (jj_scan_token(145)) {
    jj_scanpos = xsp;
    if (jj_scan_token(146)) {
    jj_scanpos = xsp;
    if (jj_scan_token(147)) {
    jj_scanpos = xsp;
    if (jj_scan_token(148)) {
    jj_scanpos = xsp;
    if (jj_scan_token(149)) {
    jj_scanpos = xsp;
    if (jj_scan_token(150)) {
    jj_scanpos = xsp;
    if (jj_scan_token(151)) {
    jj_scanpos = xsp;
    if (jj_scan_token(152)) {
    jj_scanpos = xsp;
    if (jj_scan_token(153)) {
    jj_scanpos = xsp;
    if (jj_scan_token(154)) {
    jj_scanpos = xsp;
    if (jj_scan_token(155)) {
    jj_scanpos = xsp;
    if (jj_scan_token(156)) {
    jj_scanpos = xsp;
    if (jj_scan_token(157)) {
    jj_scanpos = xsp;
    if (jj_scan_token(158)) {
    jj_scanpos = xsp;
    if (jj_scan_token(159)) {
    jj_scanpos = xsp;
    if (jj_scan_token(160)) {
    jj_scanpos = xsp;
    if (jj_scan_token(161)) {
    jj_scanpos = xsp;
    if (jj_scan_token(162)) {
    jj_scanpos = xsp;
    if (jj_scan_token(163)) {
    jj_scanpos = xsp;
    if (jj_scan_token(164)) {
    jj_scanpos = xsp;
    if (jj_scan_token(165)) {
    jj_scanpos = xsp;
    if (jj_scan_token(166)) {
    jj_scanpos = xsp;
    if (jj_scan_token(167)) {
    jj_scanpos = xsp;
    if (jj_scan_token(168)) {
    jj_scanpos = xsp;
    if (jj_scan_token(169)) {
    jj_scanpos = xsp;
    if (jj_scan_token(170)) {
    jj_scanpos = xsp;
    if (jj_scan_token(171)) {
    jj_scanpos = xsp;
    if (jj_scan_token(172)) {
    jj_scanpos = xsp;
    if (jj_scan_token(173)) {
    jj_scanpos = xsp;
    if (jj_scan_token(174)) {
    jj_scanpos = xsp;
    if (jj_scan_token(175)) {
    jj_scanpos = xsp;
    if (jj_scan_token(176)) {
    jj_scanpos = xsp;
    if (jj_scan_token(177)) {
    jj_scanpos = xsp;
    if (jj_scan_token(178)) {
    jj_scanpos = xsp;
    if (jj_scan_token(179)) {
    jj_scanpos = xsp;
    if (jj_scan_token(180)) {
    jj_scanpos = xsp;
    if (jj_scan_token(181)) {
    jj_scanpos = xsp;
    if (jj_scan_token(182)) {
    jj_scanpos = xsp;
    if (jj_scan_token(183)) {
    jj_scanpos = xsp;
    if (jj_scan_token(184)) {
    jj_scanpos = xsp;
    if (jj_scan_token(185)) {
    jj_scanpos = xsp;
    if (jj_scan_token(186)) {
    jj_scanpos = xsp;
    if (jj_scan_token(187)) {
    jj_scanpos = xsp;
    if (jj_scan_token(188)) {
    jj_scanpos = xsp;
    if (jj_scan_token(189)) {
    jj_scanpos = xsp;
    if (jj_scan_token(190)) {
    jj_scanpos = xsp;
    if (jj_scan_token(191)) {
    jj_scanpos = xsp;
    if (jj_scan_token(192)) {
    jj_scanpos = xsp;
    if (jj_scan_token(193)) {
    jj_scanpos = xsp;
    if (jj_scan_token(194)) {
    jj_scanpos = xsp;
    if (jj_scan_token(195)) {
    jj_scanpos = xsp;
    if (jj_scan_token(196)) {
    jj_scanpos = xsp;
    if (jj_scan_token(197)) {
    jj_scanpos = xsp;
    if (jj_scan_token(198)) {
    jj_scanpos = xsp;
    if (jj_scan_token(199)) {
    jj_scanpos = xsp;
    if (jj_scan_token(200)) {
    jj_scanpos = xsp;
    if (jj_scan_token(201)) {
    jj_scanpos = xsp;
    if (jj_scan_token(202)) {
    jj_scanpos = xsp;
    if (jj_scan_token(203)) {
    jj_scanpos = xsp;
    if (jj_scan_token(204)) {
    jj_scanpos = xsp;
    if (jj_scan_token(205)) {
    jj_scanpos = xsp;
    if (jj_scan_token(206)) {
    jj_scanpos = xsp;
    if (jj_scan_token(207)) {
    jj_scanpos = xsp;
    if (jj_scan_token(208)) {
    jj_scanpos = xsp;
    if (jj_scan_token(209)) {
    jj_scanpos = xsp;
    if (jj_scan_token(210)) {
    jj_scanpos = xsp;
    if (jj_scan_token(211)) {
    jj_scanpos = xsp;
    if (jj_scan_token(212)) {
    jj_scanpos = xsp;
    if (jj_scan_token(213)) {
    jj_scanpos = xsp;
    if (jj_scan_token(214)) {
    jj_scanpos = xsp;
    if (jj_scan_token(215)) {
    jj_scanpos = xsp;
    if (jj_scan_token(216)) {
    jj_scanpos = xsp;
    if (jj_scan_token(217)) {
    jj_scanpos = xsp;
    if (jj_scan_token(218)) {
    jj_scanpos = xsp;
    if (jj_scan_token(219)) {
    jj_scanpos = xsp;
    if (jj_scan_token(220)) {
    jj_scanpos = xsp;
    if (jj_scan_token(221)) {
    jj_scanpos = xsp;
    if (jj_scan_token(222)) {
    jj_scanpos = xsp;
    if (jj_scan_token(223)) {
    jj_scanpos = xsp;
    if (jj_scan_token(224)) {
    jj_scanpos = xsp;
    if (jj_scan_token(225)) {
    jj_scanpos = xsp;
    if (jj_scan_token(226)) {
    jj_scanpos = xsp;
    if (jj_scan_token(227)) {
    jj_scanpos = xsp;
    if (jj_scan_token(228)) {
    jj_scanpos = xsp;
    if (jj_scan_token(229)) {
    jj_scanpos = xsp;
    if (jj_scan_token(230)) {
    jj_scanpos = xsp;
    if (jj_scan_token(231)) {
    jj_scanpos = xsp;
    if (jj_scan_token(232)) {
    jj_scanpos = xsp;
    if (jj_scan_token(233)) {
    jj_scanpos = xsp;
    if (jj_scan_token(234)) {
    jj_scanpos = xsp;
    if (jj_scan_token(235)) {
    jj_scanpos = xsp;
    if (jj_scan_token(236)) {
    jj_scanpos = xsp;
    if (jj_scan_token(237)) {
    jj_scanpos = xsp;
    if (jj_scan_token(238)) {
    jj_scanpos = xsp;
    if (jj_scan_token(239)) {
    jj_scanpos = xsp;
    if (jj_scan_token(240)) {
    jj_scanpos = xsp;
    if (jj_scan_token(241)) {
    jj_scanpos = xsp;
    if (jj_scan_token(242)) {
    jj_scanpos = xsp;
    if (jj_scan_token(243)) {
    jj_scanpos = xsp;
    if (jj_scan_token(244)) {
    jj_scanpos = xsp;
    if (jj_scan_token(245)) {
    jj_scanpos = xsp;
    if (jj_scan_token(246)) {
    jj_scanpos = xsp;
    if (jj_scan_token(247)) {
    jj_scanpos = xsp;
    if (jj_scan_token(248)) {
    jj_scanpos = xsp;
    if (jj_scan_token(249)) {
    jj_scanpos = xsp;
    if (jj_scan_token(250)) {
    jj_scanpos = xsp;
    if (jj_scan_token(251)) {
    jj_scanpos = xsp;
    if (jj_scan_token(252)) {
    jj_scanpos = xsp;
    if (jj_scan_token(253)) {
    jj_scanpos = xsp;
    if (jj_scan_token(254)) {
    jj_scanpos = xsp;
    if (jj_scan_token(255)) {
    jj_scanpos = xsp;
    if (jj_scan_token(256)) {
    jj_scanpos = xsp;
    if (jj_scan_token(257)) {
    jj_scanpos = xsp;
    if (jj_scan_token(258)) {
    jj_scanpos = xsp;
    if (jj_scan_token(259)) {
    jj_scanpos = xsp;
    if (jj_scan_token(260)) {
    jj_scanpos = xsp;
    if (jj_scan_token(261)) {
    jj_scanpos = xsp;
    if (jj_scan_token(262)) {
    jj_scanpos = xsp;
    if (jj_scan_token(263)) {
    jj_scanpos = xsp;
    if (jj_scan_token(264)) {
    jj_scanpos = xsp;
    if (jj_scan_token(265)) {
    jj_scanpos = xsp;
    if (jj_scan_token(266)) {
    jj_scanpos = xsp;
    if (jj_scan_token(267)) {
    jj_scanpos = xsp;
    if (jj_scan_token(268)) {
    jj_scanpos = xsp;
    if (jj_scan_token(269)) {
    jj_scanpos = xsp;
    if (jj_scan_token(270)) {
    jj_scanpos = xsp;
    if (jj_scan_token(271)) {
    jj_scanpos = xsp;
    if (jj_scan_token(272)) {
    jj_scanpos = xsp;
    if (jj_scan_token(273)) {
    jj_scanpos = xsp;
    if (jj_scan_token(274)) {
    jj_scanpos = xsp;
    if (jj_scan_token(275)) {
    jj_scanpos = xsp;
    if (jj_scan_token(276)) {
    jj_scanpos = xsp;
    if (jj_scan_token(277)) {
    jj_scanpos = xsp;
    if (jj_scan_token(278)) {
    jj_scanpos = xsp;
    if (jj_scan_token(279)) {
    jj_scanpos = xsp;
    if (jj_scan_token(280)) {
    jj_scanpos = xsp;
    if (jj_scan_token(281)) {
    jj_scanpos = xsp;
    if (jj_scan_token(282)) {
    jj_scanpos = xsp;
    if (jj_scan_token(283)) {
    jj_scanpos = xsp;
    if (jj_scan_token(284)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_28() {
    if (jj_3R_19()) return true;
    return false;
  }

  final private boolean jj_3R_12() {
    if (jj_scan_token(TAGOTHER)) return true;
    return false;
  }

  final private boolean jj_3R_27() {
    if (jj_scan_token(SINGLEQUOTEOTHER)) return true;
    return false;
  }

  final private boolean jj_3R_24() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_27()) {
    jj_scanpos = xsp;
    if (jj_3R_28()) return true;
    }
    return false;
  }

  final private boolean jj_3R_13() {
    if (jj_3R_19()) return true;
    return false;
  }

  final private boolean jj_3_4() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_16()) {
    jj_scanpos = xsp;
    if (jj_3R_17()) {
    jj_scanpos = xsp;
    if (jj_3R_18()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3_2() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_14()) {
    jj_scanpos = xsp;
    if (jj_3R_15()) return true;
    }
    return false;
  }

  final private boolean jj_3R_26() {
    if (jj_3R_19()) return true;
    return false;
  }

  final private boolean jj_3R_20() {
    Token xsp;
    if (jj_3_2()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_2()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_25() {
    if (jj_scan_token(DOUBLEQUOTEOTHER)) return true;
    return false;
  }

  final private boolean jj_3R_23() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_25()) {
    jj_scanpos = xsp;
    if (jj_3R_26()) return true;
    }
    return false;
  }

  final private boolean jj_3R_17() {
    if (jj_3R_21()) return true;
    return false;
  }

  final private boolean jj_3_1() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_12()) {
    jj_scanpos = xsp;
    if (jj_3R_13()) return true;
    }
    return false;
  }

  public ParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  public Token token, jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  public boolean lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[31];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static private int[] jj_la1_4;
  static private int[] jj_la1_5;
  static private int[] jj_la1_6;
  static private int[] jj_la1_7;
  static private int[] jj_la1_8;
  static {
      jj_la1_0();
      jj_la1_1();
      jj_la1_2();
      jj_la1_3();
      jj_la1_4();
      jj_la1_5();
      jj_la1_6();
      jj_la1_7();
      jj_la1_8();
   }
   private static void jj_la1_0() {
      jj_la1_0 = new int[] {0x1000,0x4000,0x10000,0x40000,0x100000,0x20000000,0x20000000,0x80000000,0x80000000,0x8000000,0x9000000,0x9000000,0x200000,0xf000000,0x8200000,0x200000,0x18,0x200000,0x200000,0x8000000,0xc00000,0x200000,0x8000000,0xc00000,0x200000,0x8000000,0xc00000,0x400,0x400,0x7f9,0x0,};
   }
   private static void jj_la1_1() {
      jj_la1_1 = new int[] {0x0,0x0,0x0,0x0,0x0,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0x0,0xffffffff,0x0,0xffffffff,0xffffffff,0x0,0x0,0x0,0x0,0xffffffff,0x0,0x0,0xffffffff,0x0,0x0,0xffffffff,0x0,0xffffffff,0xffffffff,0xffffffff,0xffffffff,};
   }
   private static void jj_la1_2() {
      jj_la1_2 = new int[] {0x0,0x0,0x0,0x0,0x0,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0x0,0xffffffff,0x0,0xffffffff,0xffffffff,0x0,0x0,0x0,0x0,0xffffffff,0x0,0x0,0xffffffff,0x0,0x0,0xffffffff,0x0,0xffffffff,0xffffffff,0xffffffff,0xffffffff,};
   }
   private static void jj_la1_3() {
      jj_la1_3 = new int[] {0x0,0x0,0x0,0x0,0x0,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0x0,0xffffffff,0x0,0xffffffff,0xffffffff,0x0,0x0,0x0,0x0,0xffffffff,0x0,0x0,0xffffffff,0x0,0x0,0xffffffff,0x0,0xffffffff,0xffffffff,0xffffffff,0xffffffff,};
   }
   private static void jj_la1_4() {
      jj_la1_4 = new int[] {0x0,0x0,0x0,0x0,0x0,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0x0,0xffffffff,0x0,0xffffffff,0xffffffff,0x0,0x0,0x0,0x0,0xffffffff,0x0,0x0,0xffffffff,0x0,0x0,0xffffffff,0x0,0xffffffff,0xffffffff,0xffffffff,0xffffffff,};
   }
   private static void jj_la1_5() {
      jj_la1_5 = new int[] {0x0,0x0,0x0,0x0,0x0,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0x0,0xffffffff,0x0,0xffffffff,0xffffffff,0x0,0x0,0x0,0x0,0xffffffff,0x0,0x0,0xffffffff,0x0,0x0,0xffffffff,0x0,0xffffffff,0xffffffff,0xffffffff,0xffffffff,};
   }
   private static void jj_la1_6() {
      jj_la1_6 = new int[] {0x0,0x0,0x0,0x0,0x0,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0x0,0xffffffff,0x0,0xffffffff,0xffffffff,0x0,0x0,0x0,0x0,0xffffffff,0x0,0x0,0xffffffff,0x0,0x0,0xffffffff,0x0,0xffffffff,0xffffffff,0xffffffff,0xffffffff,};
   }
   private static void jj_la1_7() {
      jj_la1_7 = new int[] {0x0,0x0,0x0,0x0,0x0,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0x0,0xffffffff,0x0,0xffffffff,0xffffffff,0x0,0x0,0x0,0x0,0xffffffff,0x0,0x0,0xffffffff,0x0,0x0,0xffffffff,0x0,0xffffffff,0xffffffff,0xffffffff,0xffffffff,};
   }
   private static void jj_la1_8() {
      jj_la1_8 = new int[] {0x0,0x0,0x0,0x0,0x0,0x1fffffff,0x1fffffff,0x1fffffff,0x1fffffff,0x1fffffff,0x0,0x1fffffff,0x0,0x1fffffff,0x1fffffff,0x0,0x0,0x0,0x0,0x1fffffff,0x0,0x0,0x1fffffff,0x0,0x0,0x1fffffff,0x0,0x1fffffff,0x1fffffff,0x1fffffff,0x1fffffff,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[5];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  public Parser(java.io.InputStream stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new ParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 31; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.InputStream stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 31; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public Parser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new ParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 31; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 31; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public Parser(ParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 31; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(ParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 31; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  final private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      boolean exists = false;
      for (java.util.Enumeration e = jj_expentries.elements(); e.hasMoreElements();) {
        int[] oldentry = (int[])(e.nextElement());
        if (oldentry.length == jj_expentry.length) {
          exists = true;
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              exists = false;
              break;
            }
          }
          if (exists) break;
        }
      }
      if (!exists) jj_expentries.addElement(jj_expentry);
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[285];
    for (int i = 0; i < 285; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 31; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
          if ((jj_la1_4[i] & (1<<j)) != 0) {
            la1tokens[128+j] = true;
          }
          if ((jj_la1_5[i] & (1<<j)) != 0) {
            la1tokens[160+j] = true;
          }
          if ((jj_la1_6[i] & (1<<j)) != 0) {
            la1tokens[192+j] = true;
          }
          if ((jj_la1_7[i] & (1<<j)) != 0) {
            la1tokens[224+j] = true;
          }
          if ((jj_la1_8[i] & (1<<j)) != 0) {
            la1tokens[256+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 285; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

  final private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 5; i++) {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
          }
        }
        p = p.next;
      } while (p != null);
    }
    jj_rescan = false;
  }

  final private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
