/* 

Copyright 2003-2006 MicroNova (R)
All rights reserved.

Redistribution and use in source and binary forms, with or
without modification, are permitted provided that the following
conditions are met:

    * Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.

    * Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

    * Neither the name of MicroNova nor the names of its contributors
    may be used to endorse or promote products derived from this
    software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

*/


package com.micronova.util;

import java.util.*;

public class TimedCache extends Cache
{
    protected long _lifespan;

    public TimedCache(int initialCapacity, float loadFactor, boolean accessOrder, int maxSize, long lifespan)
    {
        super(initialCapacity, loadFactor, accessOrder, maxSize);
        
        _lifespan = lifespan;
    }

    public Object put(Object key, Object value)
    {
        TimedCacheEntry entry = new TimedCacheEntry(value);

        TimedCacheEntry previous = (TimedCacheEntry)super.put(key, entry);

        if (previous == null)
        {
            return null;
        }
        else
        {
            return previous.getObject();
        }
    }

    public Object get(Object key)
    {
        TimedCacheEntry entry = (TimedCacheEntry)super.get(key);

        Object value = null;

        if (entry != null)
        {
            if (entry.getTimestamp() > System.currentTimeMillis() - _lifespan)
            {
                value = entry.getObject();
            }
            else
            {
                remove(key);
            }
            
        }

        return value;
    }
}
