/* 

Copyright 2003-2006 MicroNova (R)
All rights reserved.

Redistribution and use in source and binary forms, with or
without modification, are permitted provided that the following
conditions are met:

    * Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.

    * Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

    * Neither the name of MicroNova nor the names of its contributors
    may be used to endorse or promote products derived from this
    software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

*/


package com.micronova.util;

import java.util.regex.*;
import java.util.*;

/** Recursive template evaluator */

public class Template
{
    /** Escapes '$' in replacement to avoid group substitution */

    public static String escapeGroup(String x)
    {
        StringBuffer in = new StringBuffer(x);
        StringBuffer out = new StringBuffer();

        boolean isEscaped = false;

        for (int i = 0; i < in.length(); i ++)
        {
            char c = in.charAt(i);

            if (c == '$')
            {
                out.append("\\$");
            }
            else if (c == '\\')
            {
                out.append("\\\\");
            }
            else
            {
                out.append(c);
            }
        }

        return out.toString();
    }

    /** Renders a Template */

    public static Object render(String template, Pattern pattern, int groupIndex, ObjectSource objectSource, Object objectSourceClient, boolean isRecursive, boolean allowGroup) throws Exception
    {
        int templateLength = template.length();

        StringBuffer output = new StringBuffer();

        Matcher matcher = pattern.matcher(template);

        while (matcher.find())
        {
            String group = matcher.group(groupIndex);

            Object replacement = objectSource.getObject(objectSourceClient, group);

            if (replacement != null)
            {
                if (isRecursive)
                {
                    replacement = render(replacement.toString(), pattern, groupIndex, objectSource, objectSourceClient, isRecursive, allowGroup);
                }
            }

            // full match returns object as-is

            if ((matcher.start() == 0) && (matcher.end() == templateLength))
            {
                return replacement;
            }

            if (replacement != null)
            {
                if (!allowGroup)
                {
                    replacement = escapeGroup(replacement.toString());
                }
            }
            else
            {
                replacement = "";
            }

            matcher.appendReplacement(output, (String)replacement);
        }

        matcher.appendTail(output);

        return output.toString();
    }
}
