/* 

Copyright 2003-2006 MicroNova (R)
All rights reserved.

Redistribution and use in source and binary forms, with or
without modification, are permitted provided that the following
conditions are met:

    * Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.

    * Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

    * Neither the name of MicroNova nor the names of its contributors
    may be used to endorse or promote products derived from this
    software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

*/


package com.micronova.util;

import java.util.*;

/** Sparse list implemented using TreeMap */

public class SparseList extends AbstractList implements SparseObject
{
    protected TreeMap treeMap;
    protected int _size;

    public SparseList()
    {
        super();

        treeMap = new TreeMap();
        _size = 0;
    }

    public Object get(int index)
    {
        Integer integerIndex = new Integer(index);

        SortedMap tailMap = treeMap.tailMap(integerIndex);

        if ((tailMap != null) && (!tailMap.isEmpty()))
        {
            Object firstKey = tailMap.firstKey();

            if (integerIndex.equals(firstKey))
            {
                return tailMap.get(firstKey);
            }
        }

        return null;
    }

    public int size()
    {
        return _size;
    }

    public Object set(int index, Object element)
    {
        Object previous = get(index);

        treeMap.put(new Integer(index), element);

        if (index >= _size)
        {
            _size = index + 1;
        }

        return previous;
    }

    public void add(int index, Object element)
    {
        SortedMap tailMap = treeMap.tailMap(new Integer(index));

        if ((tailMap != null) && (!tailMap.isEmpty()))
        {
            ArrayList keyList = new ArrayList();
            ArrayList valueList = new ArrayList();

            Iterator iterator = tailMap.entrySet().iterator();

            while (iterator.hasNext())
            {
                Map.Entry entry = (Map.Entry)iterator.next();
                
                keyList.add(entry.getKey());
                valueList.add(entry.getValue());
            }

            for (int i = keyList.size(); --i >=0;)
            {
                Integer key = (Integer)keyList.get(i);
                
                treeMap.remove(key);
                
                treeMap.put(new Integer(key.intValue() + 1), valueList.get(i));
            }

            _size ++;
        }

        set(index, element);
    }

    public Object remove(int index)
    {
        Object currentValue = get(index);

        int size = _size;

        if (index == size - 1)
        {
            treeMap.remove(new Integer(index));
            _size = size - 1;
        }
        else if (index < size)
        {
            SortedMap tailMap = treeMap.tailMap(new Integer(index + 1));

            if ((tailMap != null) && (!tailMap.isEmpty()))
            {
                ArrayList keyList = new ArrayList();
                ArrayList valueList = new ArrayList();
                
                Iterator iterator = tailMap.entrySet().iterator();
                
                while (iterator.hasNext())
                {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    
                    keyList.add(entry.getKey());
                    valueList.add(entry.getValue());
                }

                for (int i = 0; i < keyList.size(); i ++)
                {
                    Integer key = (Integer)keyList.get(i);
                    
                    treeMap.remove(key);
                    
                    treeMap.put(new Integer(key.intValue() - 1), valueList.get(i));
                }
            }

            _size = size - 1;
        }

        return currentValue;
    }

    /** actual size */

    public int getActualSize()
    {
        return treeMap.size();
    }
}
