/* 

Copyright 2003-2006 MicroNova (R)
All rights reserved.

Redistribution and use in source and binary forms, with or
without modification, are permitted provided that the following
conditions are met:

    * Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.

    * Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

    * Neither the name of MicroNova nor the names of its contributors
    may be used to endorse or promote products derived from this
    software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

*/

package com.micronova.util;

import java.util.*;
import java.beans.*;
import java.lang.reflect.*;

/** delegated map */

public class MapBean extends HashMap implements ObjectSource, ObjectTarget
{
    protected static final Object REMOVE = new Object();

    protected ObjectSource _objectSource;
    protected ObjectTarget _ObjectTarget;

    protected void init()
    {
        _objectSource = this;
        _ObjectTarget = this;
    }

    public MapBean()
    {
        super();

        init();
    }

    public MapBean(Object source)
    {
        super((Map)source);

        init();
    }

    public void setObjectSource(ObjectSource objectSource)
    {
        _objectSource = objectSource;
    }

    public ObjectSource getObjectSource()
    {
        return _objectSource;
    }

    public void setObjectTarget(ObjectTarget ObjectTarget)
    {
        _ObjectTarget = ObjectTarget;
    }

    public ObjectTarget getObjectTarget()
    {
        return _ObjectTarget;
    }

    public Object getMapObject(Object key)
    {
        return super.get(key);
    }

    public Object putMapObject(Object key, Object value)
    {
        if (value == REMOVE)
        {
            return super.remove(key);
        }
        else
        {
            return super.put(key, value);
        }
    }

    public Object putObject(Object objectSource, Object key, Object value)
    {
        return putMapObject(key, value);
    }

    public Object getObject(Object objectSource, Object key)
    {
        return getMapObject(key);
    }

    public Object get(Object key)
    {
        return _objectSource.getObject(this, key);
    }

    public Object get(Object key, Object defaultValue)
    {
        Object value = get(key);

        if (value == null)
        {
            return defaultValue;
        }
        else
        {
            return value;
        }
    }

    public Object put(Object key, Object value)
    {
        return _ObjectTarget.putObject(this, key, value);
    }

    public Object remove(Object key)
    {
        return put(key, REMOVE);
    }

    public String getString(Object key)
    {
        return (String)get(key);
    }

    public String getString(Object key, Object defaultValue)
    {
        return (String)get(key, defaultValue);
    }

    public int getInt(Object key, int defaultValue)
    {
        Integer value = TypeUtil.isInteger(get(key));

        if (value != null)
        {
            return value.intValue();
        }
        else
        {
            return defaultValue;
        }
    }

    public long getLong(Object key, long defaultValue)
    {
        Long value = TypeUtil.isLong(get(key));

        if (value != null)
        {
            return value.longValue();
        }
        else
        {
            return defaultValue;
        }
    }

    public double getDouble(Object key, double defaultValue)
    {
        Double value = TypeUtil.isDouble(get(key));

        if (value != null)
        {
            return value.doubleValue();
        }
        else
        {
            return defaultValue;
        }
    }

    public float getFloat(Object key, float defaultValue)
    {
        Float value = TypeUtil.isFloat(get(key));

        if (value != null)
        {
            return value.floatValue();
        }
        else
        {
            return defaultValue;
        }
    }

    public boolean getBoolean(Object key, boolean defaultValue)
    {
        Boolean value = TypeUtil.isBoolean(get(key));

        if (value != null)
        {
            return value.booleanValue();
        }
        else
        {
            return defaultValue;
        }
    }
}
