/* 

Copyright 2003-2006 MicroNova (R)
All rights reserved.

Redistribution and use in source and binary forms, with or
without modification, are permitted provided that the following
conditions are met:

    * Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.

    * Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

    * Neither the name of MicroNova nor the names of its contributors
    may be used to endorse or promote products derived from this
    software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

*/


package com.micronova.jsp.tag;

import java.util.*;
import java.util.regex.*;
import java.sql.*;
import javax.sql.*;
import javax.naming.*;
import javax.servlet.jsp.*;
import javax.servlet.jsp.jstl.core.Config;
import org.apache.taglibs.standard.tag.common.sql.TransactionTagSupport;
import org.apache.taglibs.standard.tag.common.sql.ResultImpl;
import com.micronova.util.*;

/** templated update statement **/

public class UpdateTag extends EvalTag
{
    protected Object _dataSource;
    protected List _nameList;
    protected StringBuffer _buffer;

    protected void init()
    {
        super.init();

        _pattern = EL.DEFAULTPATTERNQUERY;
        _dataSource = null;
        _export = null;

        _nameList = null;

        if (_buffer == null)
        {
            _buffer = new StringBuffer();
        }
    }

    protected Object doSql(PreparedStatement preparedStatement) throws Exception
    {
        return new Integer(preparedStatement.executeUpdate());
    }

    protected TransactionTagSupport getTransactionTagSupport()
    {
        return (TransactionTagSupport)getAncestorTag("org.apache.taglibs.standard.tag.common.sql.TransactionTagSupport");
    }

    protected Connection getConnection(Object spec) throws Exception
    {
        Connection connection = null;

        if (spec == null)
        {
            spec = getConfiguration(Config.SQL_DATA_SOURCE, null);
        }

        if (spec instanceof DataSource)
        {
            connection = ((DataSource)spec).getConnection();
        }
        else
        {
            String specString = (String)spec;

            if (specString.startsWith("jdbc:"))
            {
                List parts = StringUtil.split(specString, ',');
                
                int partsLength = parts.size();

                String jdbcURL = parts.get(0).toString();
                String driverClassName = parts.get(1).toString();

                String user = null;
                String password = null;

                if (partsLength >= 3)
                {
                    user = parts.get(2).toString();
                }

                if (partsLength >= 4)
                {
                    password = parts.get(3).toString();
                }

                Class.forName(driverClassName, true, Thread.currentThread().getContextClassLoader()).newInstance();           

                if ((user == null) && (password == null))
                {
                    connection = DriverManager.getConnection(jdbcURL);
                }
                else
                {
                    connection = DriverManager.getConnection(jdbcURL, user, password);
                }
            }
            else
            {
                Context context = new InitialContext();
                Context environment = (Context)context.lookup("java:comp/env");

                DataSource dataSource = (DataSource)environment.lookup(specString);

                connection = dataSource.getConnection();
            }
        }

        return connection;
    }

    protected Object evaluate(String expression, Pattern pattern) throws Exception
    {
        Object value = null;

        Connection connection = null;
        boolean doesCloseConnection = false;
        PreparedStatement preparedStatement = null;

        try
        {
            TransactionTagSupport transactionTagSupport = getTransactionTagSupport();

            if (transactionTagSupport != null)
            {
                connection = transactionTagSupport.getSharedConnection();
            }
            else
            {
                doesCloseConnection = true;
               
                connection = getConnection(_dataSource);
            }

            preparedStatement = SQLObjectSource.prepareStatement(connection, expression, pattern, this, _recursive, _allowGroup);
            
            value = doSql(preparedStatement);
        }
        catch (Exception e)
        {
            throw e;
        }
        finally
        {
            if (doesCloseConnection)
            {
                if (preparedStatement != null)
                {
                    preparedStatement.close();
                }

                if (connection != null)
                {
                    connection.close();
                }
            }
        }

        return value;
    }

    public void setDataSource(Object expression) throws Exception
    {
        _dataSource = evaluateAttribute("dataSource", expression, Object.class);
    }
}
