/* 

Copyright 2003-2006 MicroNova (R)
All rights reserved.

Redistribution and use in source and binary forms, with or
without modification, are permitted provided that the following
conditions are met:

    * Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.

    * Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

    * Neither the name of MicroNova nor the names of its contributors
    may be used to endorse or promote products derived from this
    software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

*/


package com.micronova.jsp.tag;

import java.util.*;
import java.io.*;
import com.micronova.util.*;

public class SystemTag extends MapTag
{
    public final static String COMMAND = "command";
    public final static String STDIN = "stdin";
    public final static String STDOUT = "stdout";
    public final static String STDERR = "stderr";
    public final static String RC = "rc";

    private static final String DEFAULTEXPORT = "${" + VALUEVAR + "." + STDOUT + "}";

    public void init()
    {
        super.init();

        _export = DEFAULTEXPORT;
    }

    public Object processValue(Object tagValue) throws Exception
    {
        NestedMap map = _map;

        String command = (String)map.get(COMMAND);
        String stdin = (String)map.get(STDIN);

        if (stdin == null)
        {
            stdin = "";
        }

        if (command != null)
        {
            ByteArrayInputStream bIn = new ByteArrayInputStream(stdin.getBytes());
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            ByteArrayOutputStream bErr = new ByteArrayOutputStream();
            
            Process p = Runtime.getRuntime().exec(command);

            Shell shell = new Shell(p, bIn, bOut, bErr);
            
            int rc = shell.exec();
            
            map.put(RC, new Integer(rc));

            map.put(STDOUT, bOut.toString("iso-8859-1"));
            
            map.put(STDERR, bErr.toString("iso-8859-1"));
        }

        return tagValue;
    }

    public void setCommand(Object expression) throws Exception
    {
        _map.put(COMMAND, evaluateAttribute(COMMAND, expression, String.class));
    }

    public void setStdin(Object expression) throws Exception
    {
        _map.put(STDIN, evaluateAttribute(STDIN, expression, String.class));
    }
}
