/* 

Copyright 2003-2006 MicroNova (R)
All rights reserved.

Redistribution and use in source and binary forms, with or
without modification, are permitted provided that the following
conditions are met:

    * Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.

    * Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

    * Neither the name of MicroNova nor the names of its contributors
    may be used to endorse or promote products derived from this
    software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

*/


package com.micronova.jsp.tag;

import javax.servlet.*;
import javax.servlet.http.*;
import java.util.*;

import com.micronova.util.*;

/** controls HTTP response */

public class ResponseTag extends MapTag
{
    public static final String COOKIE = "cookie";
    public static final String HEADER = "header";
    public static final String ERROR = "error";
    public static final String ERRORMESSAGE = "errorMessage";
    public static final String REDIRECT = "redirect";

    protected void init()
    {
        super.init();

        _export = null;
    }

    protected Cookie makeCookie(String name, Object object) throws Exception
    {
        if (object instanceof Cookie)
        {
            return (Cookie)object;
        }
        else if (object != null)
        {
            Cookie cookie = new Cookie(name, null);

            if (object instanceof Map)
            {
                BeanUtil.fill(cookie, (Map)object);
            }
            else
            {
                cookie.setValue(object.toString());
            }

            return cookie;
        }
        else
        {
            return null;
        }
    }

    protected Object processValue(Object tagValue) throws Exception
    {
        HttpServletResponse response = (HttpServletResponse)pageContext.getResponse();

        Map map = _map;

        // process cookies

        Object cookieMap = map.get(COOKIE);

        if (cookieMap instanceof Map)
        {
            Iterator iterator = ((Map)cookieMap).entrySet().iterator();

            while (iterator.hasNext())
            {
                Map.Entry entry = (Map.Entry)iterator.next();

                Object cookieName = entry.getKey();
                Object cookieValue = entry.getValue();


                if (cookieName!= null)
                {
                    Cookie cookie = makeCookie(cookieName.toString(), cookieValue);
                    
                    response.addCookie(cookie);
                }
            }
        }

        // process headers

        Object headerMap = map.get(HEADER);

        if (headerMap instanceof Map)
        {
            Iterator iterator = ((Map)headerMap).entrySet().iterator();

            while (iterator.hasNext())
            {
                Map.Entry entry = (Map.Entry)iterator.next();

                String headerKey = (String)entry.getKey();
                Object headerValue = entry.getValue();

                if (headerKey != null)
                {
                    if (headerValue instanceof String)
                    {
                        response.addHeader(headerKey, headerValue.toString());
                    }
                    else
                    {
                        List list = (List)TypeUtil.isList(headerValue);

                        if (list != null)
                        {
                            Iterator listIterator = list.iterator();
                        
                            while (listIterator.hasNext())
                            {
                                Object element = listIterator.next();
                                
                                response.addHeader(headerKey, element.toString());
                            }
                        }
                    }
                }
            }
        }

        // process error

        String error = (String)map.get(ERROR);
        String errorMessage = (String)map.get(ERRORMESSAGE);

        if (error != null)
        {
            int errorCode = Integer.parseInt(error);

            if (errorMessage == null)
            {
                response.sendError(errorCode);
            }
            else
            {
                response.sendError(errorCode, errorMessage);
            }
        }

        // process redirect

        String redirect = (String)map.get(REDIRECT);

        if (redirect != null)
        {
            response.sendRedirect(redirect);
        }

        return tagValue;
    }
}
