/* 

Copyright 2003-2006 MicroNova (R)
All rights reserved.

Redistribution and use in source and binary forms, with or
without modification, are permitted provided that the following
conditions are met:

    * Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.

    * Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

    * Neither the name of MicroNova nor the names of its contributors
    may be used to endorse or promote products derived from this
    software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

*/


package com.micronova.jsp.tag;

import javax.servlet.*;
import java.io.*;
import com.micronova.util.*;
import com.micronova.util.servlet.*;

/** obtains request data as String */

public class PostDataTag extends YuzuTag
{
    protected String _contentTypePrefix;
    protected String _encoding;

    protected final String DEFAULTENCODING = "*iso-8859-1";

    protected void init()
    {
        super.init();

        _contentTypePrefix = null;
        _encoding = null;
    }

    public void setContentTypePrefix(Object expression) throws Exception
    {
        _contentTypePrefix = (String)evaluateAttribute("contentTypePrefix", expression, String.class);
    }

    public void setEncoding(Object expression) throws Exception
    {
        _encoding = (String)evaluateAttribute("encoding", expression, String.class);
    }

    /** override so no importing is done */

    protected boolean doesImport(Object value)
    {
        return false;
    }

    protected Object prepareValue(Object tagValue) throws Exception
    {
        tagValue = super.prepareValue(tagValue);

        if (tagValue == null)
        {
            ServletRequest request = pageContext.getRequest();

            if (!(request instanceof DispatchHttpServletRequest))
            {
                String contentTypePrefix = _contentTypePrefix;
                
                boolean isContentMatched = (contentTypePrefix == null);
                
                if (!isContentMatched)
                {
                    String contentType = request.getContentType();
                
                    isContentMatched = ((contentType != null) && contentType.startsWith(contentTypePrefix));
                }

                if (isContentMatched)
                {
                    tagValue = request;
                }
            }
        }

        return tagValue;
    }


    protected Object doDefault(Object value, Object defaultValue, String test) throws Exception
    {
        ServletRequest request = pageContext.getRequest();

        if (value == request)
        {
            String requestEncoding = request.getCharacterEncoding();

            String encoding = _encoding;

            if (encoding == null)
            {
                encoding = DEFAULTENCODING;
            }

            if (encoding.startsWith("*"))
            {
                if (requestEncoding != null)
                {
                    encoding = requestEncoding;
                }
                else
                {
                    encoding = encoding.substring(1);
                }
            }

            Reader reader = null;

            try
            {
                reader = new InputStreamReader(request.getInputStream(), encoding);

                value = new String(IOUtil.readAll(reader));
            }
            catch (Exception e)
            {
                throw e;
            }
        }

        return super.doDefault(value, defaultValue, test);
    }
}
