/* 

Copyright 2003-2006 MicroNova (R)
All rights reserved.

Redistribution and use in source and binary forms, with or
without modification, are permitted provided that the following
conditions are met:

    * Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.

    * Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

    * Neither the name of MicroNova nor the names of its contributors
    may be used to endorse or promote products derived from this
    software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

*/


package com.micronova.jsp.tag;

import java.io.*;
import java.util.*;
import javax.servlet.*;

import com.micronova.util.*;
import com.micronova.util.cc.html.Parser;

public class ParseHtmlTag extends YuzuTag
{
    protected NestedMap _controlMap;

    protected void init()
    {
        super.init();

        _controlMap = new NestedMap();
    }

    public void setPrefix(Object expression) throws Exception
    {
        _controlMap.put("prefix", (String)evaluateAttribute("prefix", expression, String.class));
    }

    public void setRootName(Object expression) throws Exception
    {
        _controlMap.put("rootName", (String)evaluateAttribute("rootName", expression, String.class));
    }

    public void setStrategy(Object expression) throws Exception
    {
        _controlMap.put("strategy", (String)evaluateAttribute("strategy", expression, String.class));
    }

    public void setExclude(Object expression) throws Exception
    {
        _controlMap.put("exclude", evaluateAttribute("exclude", expression, String.class));
    }

    public void setInclude(Object expression) throws Exception
    {
        _controlMap.put("include", evaluateAttribute("include", expression, String.class));
    }

    protected Object processValue(Object tagValue) throws Exception
    {
        if (tagValue != null)
        {
            try
            {
                return XMLUtil.parseHtml(tagValue, _controlMap);
            }
            catch (Exception e)
            {
                ServletContext context = pageContext.getServletContext();

                context.log("HtmlTag:BEGIN ========");
                context.log(tagValue.toString());
                context.log("HtmlTag:END   ========");
                
                throw e;
            }
        }
        else
        {
            return null;
        }
    }
}
