/* 

Copyright 2003-2006 MicroNova (R)
All rights reserved.

Redistribution and use in source and binary forms, with or
without modification, are permitted provided that the following
conditions are met:

    * Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.

    * Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

    * Neither the name of MicroNova nor the names of its contributors
    may be used to endorse or promote products derived from this
    software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

*/


package com.micronova.jsp.tag;

import com.micronova.util.*;
import java.util.regex.*;
import java.util.*;

/** Evaluates the tagValue as EL */

public class EvalTag extends YuzuTag implements ObjectSource
{
    protected Object _pattern;
    protected boolean _recursive;
    protected boolean _allowGroup;
    protected String _evalCodec;
    protected Object _environment;

    protected void init()
    {
        super.init();

        _export = DEFAULT;

        _pattern = EL.DEFAULTPATTERNEVAL;
        _recursive = false;
        _allowGroup = false;
        _evalCodec = null;
        _environment = null;
    }

    protected Object evaluate(String expression, Pattern pattern) throws Exception
    {
        return Template.render(expression, pattern, 1, this, this, _recursive, _allowGroup);
    }

    public Object processValue(Object tagValue) throws Exception
    {
        if (tagValue != null)
        {
            Pattern pattern = EL.getPattern(_pattern);

            Object environment = _environment;

            if (environment != null)
            {
                setPageAttribute(VALUEVAR, environment);
            }

            tagValue = evaluate(tagValue.toString(), pattern);
        }

        return tagValue;
    }

    public Object getObject(Object client, Object key)
    {
        try
        {
            return applyCodec(_evalCodec, evaluateExpression("eval", "${" + key.toString() + "}", Object.class));
        }
        catch (Exception e)
        {
            throw new RuntimeException(e);
        }
    }

    public void setPattern(Object expression) throws Exception
    {
        _pattern = evaluateAttribute("pattern", expression, Object.class);
    }

    public void setRecursive(Object expression) throws Exception
    {
        _recursive = ((Boolean)evaluateAttribute("recursive", expression, Boolean.class)).booleanValue();
    }

    public void setAllowGroup(Object expression) throws Exception
    {
        _allowGroup = ((Boolean)evaluateAttribute("allowGroup", expression, Boolean.class)).booleanValue();
    }

    public void setEvalCodec(Object expression) throws Exception
    {
        _evalCodec = (String)evaluateAttribute("evalCodec", expression, EL.class);
    }

    public void setEnvironment(Object expression) throws Exception
    {
        _environment = evaluateAttribute("environment", expression, Object.class);
    }
}
