/* 

Copyright 2003-2006 MicroNova (R)
All rights reserved.

Redistribution and use in source and binary forms, with or
without modification, are permitted provided that the following
conditions are met:

    * Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.

    * Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

    * Neither the name of MicroNova nor the names of its contributors
    may be used to endorse or promote products derived from this
    software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

*/

package com.micronova.jsp.tag;

import com.micronova.util.*;
import java.util.*;
import javax.servlet.jsp.*;
import java.lang.reflect.*;
import java.util.regex.*;

public class ELMap extends MapBean
{
    public static final String PAGECONTEXT = "pageContext";
    public static final String ENVVAR = "_";
    public static final String KEY = "key";
    public static final String VALUE = "value";
    public static final String GET = "get";
    public static final String PUT = "put";
    public static final String GETCODEC = "getCodec";
    public static final String PUTCODEC = "putCodec";

    protected PageContext _pageContext;
    protected NestedMap _environment;

    public ELMap(PageContext pageContext, Object environmentSource) throws Exception
    {
        super();

        _pageContext = pageContext;
        _environment = new NestedMap(environmentSource);
    }

    /** ObjectSource implementation */

    public Object getObject(Object client, Object key)
    {
        Object envVar = null;
        PageContext pageContext = _pageContext;

        try
        {
            NestedMap environment = _environment;

            envVar = EL.getPageAttribute(pageContext, ENVVAR);

            EL.setPageAttribute(pageContext, ENVVAR, environment);

            String getCodec = EL.replaceEvalEscape(environment.getString(GETCODEC));
            environment.put(KEY, key);

            return EL.applyCodec(pageContext, getCodec, environment);
        }
        catch (Exception e)
        {
            throw new RuntimeException(e);
        }
        finally
        {
            if (envVar != null)
            {
                EL.setPageAttribute(pageContext, ENVVAR, envVar);
            }
        }
    }

    /** ObjectTarget implementation (key/value filter for Map client) */

    public Object putObject(Object client, Object key, Object value)
    {

        Object envVar = null;
        PageContext pageContext = _pageContext;

        try
        {
            NestedMap environment = _environment;

            envVar = EL.getPageAttribute(pageContext, ENVVAR);

            EL.setPageAttribute(pageContext, ENVVAR, environment);

            String putCodec = EL.replaceEvalEscape(environment.getString(PUTCODEC));
            environment.put(KEY, key);
            environment.put(VALUE, value);

            return EL.applyCodec(pageContext, putCodec, environment);
        }
        catch (Exception e)
        {
            throw new RuntimeException(e);
        }
        finally
        {
            if (envVar != null)
            {
                EL.setPageAttribute(pageContext, ENVVAR, envVar);
            }
        }
    }
}
