/* 

Copyright 2003-2006 MicroNova (R)
All rights reserved.

Redistribution and use in source and binary forms, with or
without modification, are permitted provided that the following
conditions are met:

    * Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.

    * Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

    * Neither the name of MicroNova nor the names of its contributors
    may be used to endorse or promote products derived from this
    software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

*/

package com.micronova.jsp.tag;

import com.micronova.util.*;
import java.util.*;
import javax.servlet.jsp.*;
import java.lang.reflect.*;
import java.util.regex.*;

public class ELComparator extends NestedMap implements Comparator
{
    public static final String EQUAL = "equal";
    public static final String LESS = "less";
    public static final String MORE = "more";
    public static final String X = "x";
    public static final String Y = "y";
    public static final String CODEC = "codec";

    protected PageContext _pageContext;

    public ELComparator(PageContext pageContext, Object source) throws Exception
    {
        super(source);

        _pageContext = pageContext;
    }

    public int compare(Object o1, Object o2)
    {
        try
        {
            PageContext pageContext = _pageContext;

            String codec = getString(CODEC);

            if (!TypeUtil.isEmptyString(codec))
            {
                o1 = EL.applyCodec(pageContext, codec, o1);
                o2 = EL.applyCodec(pageContext, codec, o2);
            }

            put(X, o1);
            put(Y, o2);

            String equalCodec = getString(EQUAL);
            
            if (!TypeUtil.isEmptyString(equalCodec))
            {
                Object equalValue = EL.applyCodec(pageContext, equalCodec, this);
               
                if (TypeUtil.isTrue(equalValue))
                {
                    return 0;
                }
            }

            int comparison = -2;
            
            if (o1 == null)
            {
                if (o2 == null)
                {
                    return 0;
                }
                else
                {
                    return -1;
                }
            }
            else
            {
                comparison = ((Comparable)o1).compareTo(o2);

                if (comparison == 0)
                {
                    return 0;
                }
            }

            String lessCodec = getString(LESS);
            
            if (!TypeUtil.isEmptyString(lessCodec))
            {
                Object lessValue = EL.applyCodec(pageContext, lessCodec, this);
                
                if (TypeUtil.isTrue(lessValue))
                {
                    return -1;
                }
                else
                {
                    return 1;
                }
            }
            
            String moreCodec = getString(MORE);
            
            if (!TypeUtil.isEmptyString(moreCodec))
            {
                Object moreValue = EL.applyCodec(pageContext, moreCodec, this);
                
                if (TypeUtil.isTrue(moreValue))
                {
                    return 1;
                }
                else
                {
                    return -1;
                }
            }

            return comparison;
        }
        catch (Exception e)
        {
            throw new RuntimeException(e);
        }
    }
}
