/* 

Copyright 2003-2006 MicroNova (R)
All rights reserved.

Redistribution and use in source and binary forms, with or
without modification, are permitted provided that the following
conditions are met:

    * Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.

    * Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

    * Neither the name of MicroNova nor the names of its contributors
    may be used to endorse or promote products derived from this
    software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

*/


package com.micronova.jsp.tag;

import com.micronova.util.*;
import com.micronova.util.servlet.*;
import java.util.*;
import java.util.regex.*;
import javax.servlet.*;
import javax.servlet.jsp.*;
import javax.servlet.http.*;

/** dispatching function call. */

public class CallTag extends MapTag
{
    protected String _bodyProperty;
    protected String _path;
    protected String _contextPath;
    protected Object _body;
    protected boolean _doesForward;

    public final static String BODYPROPERTY = "parameter";
    public final static String RETURNPROPERTY = "_return";
    public final static String VALUEPROPERTY = "value";

    protected void init()
    {
        super.init();

        _path = null;
        _contextPath = null;
        _bodyProperty = BODYPROPERTY;
        _body = null;
        _doesForward = false;
    }

    protected boolean doesImport(Object tagValue)
    {
        return (!isEmptyString(_bodyProperty));
    }

    protected Object importBody(Object tagValue) throws Exception
    {
        if (_body == null)
        {
            Object importedValue = super.importBody(tagValue);

            if (importedValue != tagValue)
            {
                _body = importedValue;
            }
        }

        return tagValue;
    }

    /** converts relative path (not string with a "/") to absolute, if necessary */

    public String getPath(String path, HttpServletRequest request)
    {
        if (!path.startsWith("/"))
        {
            path = request.getServletPath().replaceFirst("/[^/]*$", "") + "/" + path;
        }

        return path;
    }

    public String getContextPath(String contextPath)
    {
        if (contextPath != null)
        {
            if (!contextPath.startsWith("/"))
            {
                contextPath = "/" + contextPath;
            }
        }

        return contextPath;
    }

    protected Object processValue(Object tagValue) throws Exception
    {
        if (tagValue != null)
        {
            NestedMap map = _map;

            Map returnMap = map.getSubMap(RETURNPROPERTY);

            returnMap.put(VALUEPROPERTY, null);

            String bodyProperty = _bodyProperty;

            if (!isEmptyString(bodyProperty))
            {
                map.put(bodyProperty, _body);
            }

            HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();

            String path = getPath(_path, request);
            String contextPath = getContextPath(_contextPath);

            if (_doesForward)
            {
                HttpDispatch.forward(pageContext, path, contextPath, map);
            }
            else
            {
                tagValue = HttpDispatch.include(pageContext, path, contextPath, map);
            }

            Object returnValue = returnMap.get(VALUEPROPERTY);

            if (!isEmptyString(returnValue))
            {
                tagValue = returnValue;
            }
        }

        return tagValue;
    }

    protected void copyFromSource(Object source) throws Exception
    {
        super.copyFromSource(source);
    }

    public void setPath(Object expression) throws Exception
    {
        _path = (String)evaluateAttribute("path", expression, String.class);
    }

    public void setContextPath(Object expression) throws Exception
    {
        _contextPath = (String)evaluateAttribute("contextPath", expression, String.class);
    }

    public void setBodyProperty(Object expression) throws Exception
    {
        _bodyProperty = (String)evaluateAttribute("bodyProperty", expression, String.class);
    }

    public void setBody(Object expression) throws Exception
    {
        _body = evaluateAttribute("body", expression, Object.class);
    }

    public void setDoesForward(Object expression) throws Exception
    {
        _doesForward = ((Boolean)evaluateAttribute("doesForward", expression, Boolean.class)).booleanValue();
    }
}
