/*
 * Decompiled with CFR 0.152.
 */
package com.micronova.util.codec;

import com.micronova.util.StringUtil;
import com.micronova.util.TypeUtil;
import com.micronova.util.codec.Codec;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;

public class CodecURL
extends Codec {
    public static Object encode(Object object, Object object2) throws Exception {
        if (object != null) {
            String string = object.toString();
            object = URLEncoder.encode(string, object2.toString());
        }
        return object;
    }

    public static Object encode(Object object) throws Exception {
        return CodecURL.encode(object, "utf-8");
    }

    public static Object decode(Object object, Object object2) throws Exception {
        if (object != null) {
            String string = object.toString();
            object = URLDecoder.decode(string, object2.toString());
        }
        return object;
    }

    public static Object decode(Object object) throws Exception {
        return CodecURL.decode(object, "utf-8");
    }

    public static Object streamType(Object object) {
        if (object != null) {
            try {
                String string;
                InputStream inputStream = null;
                if (object instanceof String) {
                    inputStream = new ByteArrayInputStream(StringUtil.fromBinaryString(object.toString()));
                } else if (object instanceof byte[]) {
                    inputStream = new ByteArrayInputStream((byte[])object);
                } else if (object instanceof InputStream) {
                    inputStream = (InputStream)object;
                }
                if (inputStream != null && !object.equals(string = URLConnection.guessContentTypeFromStream(inputStream))) {
                    object = string;
                }
            }
            catch (Exception exception) {
                object = null;
            }
        }
        return object;
    }

    public static Object nameType(Object object) {
        if (object != null) {
            object = URLConnection.guessContentTypeFromName(object.toString());
        }
        return object;
    }

    public static Object normalize(Object object) {
        URI uRI;
        URI uRI2 = null;
        if (object != null && (uRI = TypeUtil.isURI(object)) != null) {
            uRI2 = uRI.normalize();
        }
        return uRI2;
    }

    public static Object relativize(Object object, Object object2) {
        URI uRI;
        URI uRI2;
        URI uRI3 = null;
        if (object != null && (uRI2 = TypeUtil.isURI(object)) != null && (uRI = TypeUtil.isURI(object2)) != null) {
            uRI3 = uRI.relativize(uRI2);
        }
        return uRI3;
    }

    public static Object resolve(Object object, Object object2) {
        URI uRI;
        URI uRI2;
        URI uRI3 = null;
        if (object != null && (uRI2 = TypeUtil.isURI(object)) != null && (uRI = TypeUtil.isURI(object2)) != null) {
            uRI3 = uRI.resolve(uRI2);
        }
        return uRI3;
    }
}

