/*
 * Decompiled with CFR 0.152.
 */
package com.micronova.util.codec;

import com.micronova.util.NumberUtil;
import com.micronova.util.TypeUtil;
import com.micronova.util.codec.Codec;

public class CodecNumber
extends Codec {
    public static Object toBinaryString(Object object, Object object2) {
        if (object != null) {
            Long l = TypeUtil.isLong(object);
            object = l != null ? NumberUtil.toBinaryString(l, (String)object2) : null;
        }
        return object;
    }

    public static Object toBinaryString(Object object) {
        return CodecNumber.toBinaryString(object, null);
    }

    public static Object toHexString(Object object, Object object2) {
        if (object != null) {
            Long l = TypeUtil.isLong(object);
            object = l != null ? NumberUtil.toHexString(l, (String)object2) : null;
        }
        return object;
    }

    public static Object toHexString(Object object) {
        return CodecNumber.toHexString(object, null);
    }

    public static Object toOctalString(Object object, Object object2) {
        if (object != null) {
            Long l = TypeUtil.isLong(object);
            object = l != null ? NumberUtil.toOctalString(l, (String)object2) : null;
        }
        return object;
    }

    public static Object toOctalString(Object object) {
        return CodecNumber.toOctalString(object, null);
    }

    public static Object fromBinaryString(Object object) {
        if (object != null) {
            object = new Long(NumberUtil.fromBinaryString(object.toString()));
        }
        return object;
    }

    public static Object fromHexString(Object object) {
        if (object != null) {
            object = new Long(NumberUtil.fromHexString(object.toString()));
        }
        return object;
    }

    public static Object fromOctalString(Object object) {
        if (object != null) {
            object = new Long(NumberUtil.fromOctalString(object.toString()));
        }
        return object;
    }

    private static Object asDouble(double d) {
        return new Double(d);
    }

    private static Object asLong(double d) {
        return new Long((long)d);
    }

    public static Object e() {
        return CodecNumber.asDouble(Math.E);
    }

    public static Object pi() {
        return CodecNumber.asDouble(Math.PI);
    }

    public static Object abs(Object object) {
        Double d = TypeUtil.isDouble(object);
        if (d != null) {
            return CodecNumber.asDouble(Math.abs(d));
        }
        return null;
    }

    public static Object max(Object object, Object object2) {
        Double d = TypeUtil.isDouble(object);
        Double d2 = TypeUtil.isDouble(object2);
        if (d != null && d2 != null) {
            return CodecNumber.asDouble(Math.max(d, d2));
        }
        return null;
    }

    public static Object min(Object object, Object object2) {
        Double d = TypeUtil.isDouble(object);
        Double d2 = TypeUtil.isDouble(object2);
        if (d != null && d2 != null) {
            return CodecNumber.asDouble(Math.min(d, d2));
        }
        return null;
    }

    public static Object ceil(Object object) {
        Double d = TypeUtil.isDouble(object);
        if (d != null) {
            return CodecNumber.asLong(Math.ceil(d));
        }
        return null;
    }

    public static Object floor(Object object) {
        Double d = TypeUtil.isDouble(object);
        if (d != null) {
            return CodecNumber.asLong(Math.floor(d));
        }
        return null;
    }

    public static Object round(Object object) {
        Double d = TypeUtil.isDouble(object);
        if (d != null) {
            return CodecNumber.asLong(Math.round(d));
        }
        return null;
    }

    public static Object exp(Object object) {
        Double d = TypeUtil.isDouble(object);
        if (d != null) {
            return CodecNumber.asDouble(Math.exp(d));
        }
        return null;
    }

    public static Object log(Object object) {
        Double d = TypeUtil.isDouble(object);
        if (d != null) {
            return CodecNumber.asDouble(Math.log(d));
        }
        return null;
    }

    public static Object sqrt(Object object) {
        Double d = TypeUtil.isDouble(object);
        if (d != null) {
            return CodecNumber.asDouble(Math.sqrt(d));
        }
        return null;
    }

    public static Object pow(Object object, Object object2) {
        Double d = TypeUtil.isDouble(object);
        Double d2 = TypeUtil.isDouble(object2);
        if (d != null && d2 != null) {
            return CodecNumber.asDouble(Math.pow(d, d2));
        }
        return null;
    }

    public static Object sin(Object object) {
        Double d = TypeUtil.isDouble(object);
        if (d != null) {
            return CodecNumber.asDouble(Math.sin(d));
        }
        return null;
    }

    public static Object cos(Object object) {
        Double d = TypeUtil.isDouble(object);
        if (d != null) {
            return CodecNumber.asDouble(Math.cos(d));
        }
        return null;
    }

    public static Object tan(Object object) {
        Double d = TypeUtil.isDouble(object);
        if (d != null) {
            return CodecNumber.asDouble(Math.tan(d));
        }
        return null;
    }

    public static Object asin(Object object) {
        Double d = TypeUtil.isDouble(object);
        if (d != null) {
            return CodecNumber.asDouble(Math.asin(d));
        }
        return null;
    }

    public static Object acos(Object object) {
        Double d = TypeUtil.isDouble(object);
        if (d != null) {
            return CodecNumber.asDouble(Math.acos(d));
        }
        return null;
    }

    public static Object atan(Object object) {
        Double d = TypeUtil.isDouble(object);
        if (d != null) {
            return CodecNumber.asDouble(Math.atan(d));
        }
        return null;
    }

    public static Object toDegrees(Object object) {
        Double d = TypeUtil.isDouble(object);
        if (d != null) {
            return CodecNumber.asDouble(Math.toDegrees(d));
        }
        return null;
    }

    public static Object toRadians(Object object) {
        Double d = TypeUtil.isDouble(object);
        if (d != null) {
            return CodecNumber.asDouble(Math.toRadians(d));
        }
        return null;
    }
}

